/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.util.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ExcludeFilterInputStream
extends BufferedInputStream {
    private String end = "";
    private String start = "";
    private String searchFor = "";
    boolean skip = false;

    public ExcludeFilterInputStream(InputStream in, String start, String end) {
        super(in);
        this.start = start;
        this.end = end;
        this.searchFor = this.start;
    }

    @Override
    public int read() throws IOException {
        char symbol = (char)super.read();
        if (this.searchFor.startsWith(new String(new char[]{symbol}))) {
            super.mark(this.searchFor.length());
            StringBuffer startBuffer = new StringBuffer();
            startBuffer.append(symbol);
            for (int i = 1; i < this.searchFor.length(); ++i) {
                startBuffer.append((char)super.read());
            }
            if (this.searchFor.equals(startBuffer.toString())) {
                this.searchFor = this.end;
                boolean bl = this.skip = !this.skip;
                if (!this.skip) {
                    symbol = (char)this.read();
                }
                while (this.skip) {
                    symbol = (char)this.read();
                }
                this.searchFor = this.start;
                return symbol;
            }
            super.reset();
            return symbol;
        }
        return symbol;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        for (i = 0; i < len; ++i) {
            byte symbol = (byte)this.read();
            if (symbol == -1) {
                return i > 0 ? i : -1;
            }
            b[i] = symbol;
        }
        return i;
    }
}

