/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.token.ClientAssertionType;
import org.xdi.oxauth.model.uma.UmaScopeType;

public class TokenRequest
extends BaseRequest {
    private static final Logger LOG = Logger.getLogger(TokenRequest.class);
    private GrantType grantType;
    private String code;
    private String redirectUri;
    private String username;
    private String password;
    private String scope;
    private String assertion;
    private String refreshToken;
    private String audience;
    private String codeVerifier;
    private SignatureAlgorithm algorithm;
    private String sharedKey;
    private RSAPrivateKey rsaPrivateKey;
    private ECDSAPrivateKey ecPrivateKey;
    private AbstractCryptoProvider cryptoProvider;
    private String keyId;

    public TokenRequest(GrantType grantType) {
        this.grantType = grantType;
        this.setContentType("application/x-www-form-urlencoded");
        this.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder umaBuilder() {
        return new Builder().grantType(GrantType.CLIENT_CREDENTIALS);
    }

    public GrantType getGrantType() {
        return this.grantType;
    }

    public void setGrantType(GrantType grantType) {
        this.grantType = grantType;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public void setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getAssertion() {
        return this.assertion;
    }

    public void setAssertion(String assertion) {
        this.assertion = assertion;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public void setAlgorithm(SignatureAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }

    @Deprecated
    public void setRsaPrivateKey(RSAPrivateKey rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    @Deprecated
    public void setEcPrivateKey(ECDSAPrivateKey ecPrivateKey) {
        this.ecPrivateKey = ecPrivateKey;
    }

    public void setCryptoProvider(AbstractCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getClientAssertion() {
        Jwt clientAssertion = new Jwt();
        if (this.algorithm == null) {
            this.algorithm = SignatureAlgorithm.HS256;
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        Date issuedAt = calendar.getTime();
        calendar.add(12, 5);
        Date expirationTime = calendar.getTime();
        clientAssertion.getHeader().setType(JwtType.JWT);
        clientAssertion.getHeader().setAlgorithm(this.algorithm);
        if (StringUtils.isNotBlank((String)this.keyId)) {
            clientAssertion.getHeader().setKeyId(this.keyId);
        }
        clientAssertion.getClaims().setIssuer(this.getAuthUsername());
        clientAssertion.getClaims().setSubjectIdentifier(this.getAuthUsername());
        clientAssertion.getClaims().setAudience(this.audience);
        clientAssertion.getClaims().setJwtId(UUID.randomUUID());
        clientAssertion.getClaims().setExpirationTime(expirationTime);
        clientAssertion.getClaims().setIssuedAt(issuedAt);
        try {
            if (this.sharedKey == null) {
                this.sharedKey = this.getAuthPassword();
            }
            String signature = this.cryptoProvider.sign(clientAssertion.getSigningInput(), this.keyId, this.sharedKey, this.algorithm);
            clientAssertion.setEncodedSignature(signature);
        }
        catch (InvalidJwtException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return clientAssertion.toString();
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            if (this.grantType != null) {
                queryStringBuilder.append("grant_type=").append(this.grantType.toString());
            }
            if (this.code != null && !this.code.isEmpty()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append("code=").append(this.code);
            }
            if (this.redirectUri != null && !this.redirectUri.isEmpty()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append("redirect_uri=").append(URLEncoder.encode(this.redirectUri, "UTF-8"));
            }
            if (this.scope != null && !this.scope.isEmpty()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append("scope=").append(URLEncoder.encode(this.scope, "UTF-8"));
            }
            if (this.username != null && !this.username.isEmpty()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append("username=").append(this.username);
            }
            if (this.password != null && !this.password.isEmpty()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append("password=").append(this.password);
            }
            if (this.assertion != null && !this.assertion.isEmpty()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append("assertion=").append(this.assertion);
            }
            if (this.refreshToken != null && !this.refreshToken.isEmpty()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append("refresh_token=").append(this.refreshToken);
            }
            if (this.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_POST) {
                if (this.getAuthUsername() != null && !this.getAuthUsername().isEmpty()) {
                    queryStringBuilder.append("&");
                    queryStringBuilder.append("client_id=").append(URLEncoder.encode(this.getAuthUsername(), "UTF-8"));
                }
                if (this.getAuthPassword() != null && !this.getAuthPassword().isEmpty()) {
                    queryStringBuilder.append("&");
                    queryStringBuilder.append("client_secret=").append(URLEncoder.encode(this.getAuthPassword(), "UTF-8"));
                }
            } else if (this.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_JWT || this.getAuthenticationMethod() == AuthenticationMethod.PRIVATE_KEY_JWT) {
                queryStringBuilder.append("&client_assertion_type=").append(URLEncoder.encode(ClientAssertionType.JWT_BEARER.toString(), "UTF-8"));
                queryStringBuilder.append("&");
                queryStringBuilder.append("client_assertion=").append(this.getClientAssertion());
            }
            for (String key : this.getCustomParameters().keySet()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append(key).append("=").append(this.getCustomParameters().get(key));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return queryStringBuilder.toString();
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.grantType != null) {
            parameters.put("grant_type", this.grantType.toString());
        }
        if (this.code != null && !this.code.isEmpty()) {
            parameters.put("code", this.code);
        }
        if (this.redirectUri != null && !this.redirectUri.isEmpty()) {
            parameters.put("redirect_uri", this.redirectUri);
        }
        if (this.username != null && !this.username.isEmpty()) {
            parameters.put("username", this.username);
        }
        if (this.password != null && !this.password.isEmpty()) {
            parameters.put("password", this.password);
        }
        if (this.scope != null && !this.scope.isEmpty()) {
            parameters.put("scope", this.scope);
        }
        if (this.assertion != null && !this.assertion.isEmpty()) {
            parameters.put("assertion", this.assertion);
        }
        if (this.refreshToken != null && !this.refreshToken.isEmpty()) {
            parameters.put("refresh_token", this.refreshToken);
        }
        if (this.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_POST) {
            if (this.getAuthUsername() != null && !this.getAuthUsername().isEmpty()) {
                parameters.put("client_id", this.getAuthUsername());
            }
            if (this.getAuthPassword() != null && !this.getAuthPassword().isEmpty()) {
                parameters.put("client_secret", this.getAuthPassword());
            }
        } else if (this.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_JWT || this.getAuthenticationMethod() == AuthenticationMethod.PRIVATE_KEY_JWT) {
            parameters.put("client_assertion_type", ClientAssertionType.JWT_BEARER.toString());
            parameters.put("client_assertion", this.getClientAssertion());
        }
        for (String key : this.getCustomParameters().keySet()) {
            parameters.put(key, this.getCustomParameters().get(key));
        }
        return parameters;
    }

    public static class Builder {
        private GrantType grantType;
        private String scope;

        public Builder grantType(GrantType grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder pat(String ... scopeArray) {
            String scope = UmaScopeType.PROTECTION.getValue();
            if (scopeArray != null && scopeArray.length > 0) {
                for (String s : scopeArray) {
                    scope = scope + " " + s;
                }
            }
            return this.scope(scope);
        }

        public TokenRequest build() {
            TokenRequest request = new TokenRequest(this.grantType);
            request.setScope(this.scope);
            return request;
        }
    }
}

