/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.client.BaseResponse;

public class OpenIdConfigurationResponse
extends BaseResponse
implements Serializable {
    private String issuer;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String userInfoEndpoint;
    private String clientInfoEndpoint;
    private String checkSessionIFrame;
    private String endSessionEndpoint;
    private String jwksUri;
    private String registrationEndpoint;
    private String idGenerationEndpoint;
    private String introspectionEndpoint;
    private List<String> scopesSupported;
    private List<String> responseTypesSupported;
    private List<String> grantTypesSupported;
    private List<String> acrValuesSupported;
    private List<String> subjectTypesSupported;
    private List<String> userInfoSigningAlgValuesSupported;
    private List<String> userInfoEncryptionAlgValuesSupported;
    private List<String> userInfoEncryptionEncValuesSupported;
    private List<String> idTokenSigningAlgValuesSupported;
    private List<String> idTokenEncryptionAlgValuesSupported;
    private List<String> idTokenEncryptionEncValuesSupported;
    private List<String> requestObjectSigningAlgValuesSupported;
    private List<String> requestObjectEncryptionAlgValuesSupported;
    private List<String> requestObjectEncryptionEncValuesSupported;
    private List<String> tokenEndpointAuthMethodsSupported;
    private List<String> tokenEndpointAuthSigningAlgValuesSupported;
    private List<String> displayValuesSupported;
    private List<String> claimTypesSupported;
    private List<String> claimsSupported;
    private List<String> idTokenTokenBindingCnfValuesSupported;
    private String serviceDocumentation;
    private List<String> claimsLocalesSupported;
    private List<String> uiLocalesSupported;
    private Boolean claimsParameterSupported;
    private Boolean requestParameterSupported;
    private Boolean requestUriParameterSupported;
    private Boolean requireRequestUriRegistration;
    private Boolean frontChannelLogoutSupported;
    private Boolean frontChannelLogoutSessionSupported;
    private String opPolicyUri;
    private String opTosUri;
    private Map<String, List<String>> scopeToClaimsMapping = new HashMap<String, List<String>>();

    public OpenIdConfigurationResponse(int status) {
        super(status);
        this.scopesSupported = new ArrayList<String>();
        this.responseTypesSupported = new ArrayList<String>();
        this.grantTypesSupported = new ArrayList<String>();
        this.acrValuesSupported = new ArrayList<String>();
        this.subjectTypesSupported = new ArrayList<String>();
        this.userInfoSigningAlgValuesSupported = new ArrayList<String>();
        this.userInfoEncryptionAlgValuesSupported = new ArrayList<String>();
        this.userInfoEncryptionEncValuesSupported = new ArrayList<String>();
        this.idTokenSigningAlgValuesSupported = new ArrayList<String>();
        this.idTokenEncryptionAlgValuesSupported = new ArrayList<String>();
        this.idTokenEncryptionEncValuesSupported = new ArrayList<String>();
        this.requestObjectSigningAlgValuesSupported = new ArrayList<String>();
        this.requestObjectEncryptionAlgValuesSupported = new ArrayList<String>();
        this.requestObjectEncryptionEncValuesSupported = new ArrayList<String>();
        this.tokenEndpointAuthMethodsSupported = new ArrayList<String>();
        this.tokenEndpointAuthSigningAlgValuesSupported = new ArrayList<String>();
        this.displayValuesSupported = new ArrayList<String>();
        this.claimTypesSupported = new ArrayList<String>();
        this.claimsSupported = new ArrayList<String>();
        this.idTokenTokenBindingCnfValuesSupported = new ArrayList<String>();
        this.claimsLocalesSupported = new ArrayList<String>();
        this.uiLocalesSupported = new ArrayList<String>();
    }

    public static Map<String, List<String>> parseScopeToClaimsMapping(String p_scopeToClaimsJson) throws JSONException {
        return OpenIdConfigurationResponse.parseScopeToClaimsMapping(new JSONArray(p_scopeToClaimsJson));
    }

    public static Map<String, List<String>> parseScopeToClaimsMapping(JSONArray p_jsonArray) throws JSONException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (p_jsonArray != null) {
            for (int i = 0; i < p_jsonArray.length(); ++i) {
                JSONObject obj = p_jsonArray.getJSONObject(i);
                String scope = obj.names().getString(0);
                JSONArray claimsArray = obj.getJSONArray(scope);
                ArrayList<String> claimsList = new ArrayList<String>();
                for (int j = 0; j < claimsArray.length(); ++j) {
                    String claim = claimsArray.getString(j);
                    if (!StringUtils.isNotBlank((String)claim)) continue;
                    claimsList.add(claim);
                }
                map.put(scope, claimsList);
            }
        }
        return map;
    }

    @Deprecated
    public Map<String, List<String>> getScopeToClaimsMapping() {
        return this.scopeToClaimsMapping;
    }

    @Deprecated
    public void setScopeToClaimsMapping(Map<String, List<String>> p_scopeToClaimsMapping) {
        this.scopeToClaimsMapping = p_scopeToClaimsMapping;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public String getClientInfoEndpoint() {
        return this.clientInfoEndpoint;
    }

    public void setClientInfoEndpoint(String clientInfoEndpoint) {
        this.clientInfoEndpoint = clientInfoEndpoint;
    }

    public String getCheckSessionIFrame() {
        return this.checkSessionIFrame;
    }

    public void setCheckSessionIFrame(String checkSessionIFrame) {
        this.checkSessionIFrame = checkSessionIFrame;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    public void setRegistrationEndpoint(String registrationEndpoint) {
        this.registrationEndpoint = registrationEndpoint;
    }

    @Deprecated
    public String getIdGenerationEndpoint() {
        return this.idGenerationEndpoint;
    }

    @Deprecated
    public void setIdGenerationEndpoint(String p_idGenerationEndpoint) {
        this.idGenerationEndpoint = p_idGenerationEndpoint;
    }

    @Deprecated
    public String getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    @Deprecated
    public void setIntrospectionEndpoint(String p_introspectionEndpoint) {
        this.introspectionEndpoint = p_introspectionEndpoint;
    }

    public List<String> getScopesSupported() {
        return this.scopesSupported;
    }

    public void setScopesSupported(List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    public List<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    public void setResponseTypesSupported(List<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    public List<String> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    public void setGrantTypesSupported(List<String> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    public List<String> getAcrValuesSupported() {
        return this.acrValuesSupported;
    }

    public void setAcrValuesSupported(List<String> acrValuesSupported) {
        this.acrValuesSupported = acrValuesSupported;
    }

    public List<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public void setSubjectTypesSupported(List<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    public List<String> getUserInfoSigningAlgValuesSupported() {
        return this.userInfoSigningAlgValuesSupported;
    }

    public void setUserInfoSigningAlgValuesSupported(List<String> userInfoSigningAlgValuesSupported) {
        this.userInfoSigningAlgValuesSupported = userInfoSigningAlgValuesSupported;
    }

    public List<String> getUserInfoEncryptionAlgValuesSupported() {
        return this.userInfoEncryptionAlgValuesSupported;
    }

    public void setUserInfoEncryptionAlgValuesSupported(List<String> userInfoEncryptionAlgValuesSupported) {
        this.userInfoEncryptionAlgValuesSupported = userInfoEncryptionAlgValuesSupported;
    }

    public List<String> getUserInfoEncryptionEncValuesSupported() {
        return this.userInfoEncryptionEncValuesSupported;
    }

    public void setUserInfoEncryptionEncValuesSupported(List<String> userInfoEncryptionEncValuesSupported) {
        this.userInfoEncryptionEncValuesSupported = userInfoEncryptionEncValuesSupported;
    }

    public List<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    public void setIdTokenSigningAlgValuesSupported(List<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    }

    public List<String> getIdTokenEncryptionAlgValuesSupported() {
        return this.idTokenEncryptionAlgValuesSupported;
    }

    public void setIdTokenEncryptionAlgValuesSupported(List<String> idTokenEncryptionAlgValuesSupported) {
        this.idTokenEncryptionAlgValuesSupported = idTokenEncryptionAlgValuesSupported;
    }

    public List<String> getIdTokenEncryptionEncValuesSupported() {
        return this.idTokenEncryptionEncValuesSupported;
    }

    public void setIdTokenEncryptionEncValuesSupported(List<String> idTokenEncryptionEncValuesSupported) {
        this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
    }

    public List<String> getRequestObjectSigningAlgValuesSupported() {
        return this.requestObjectSigningAlgValuesSupported;
    }

    public void setRequestObjectSigningAlgValuesSupported(List<String> requestObjectSigningAlgValuesSupported) {
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
    }

    public List<String> getRequestObjectEncryptionAlgValuesSupported() {
        return this.requestObjectEncryptionAlgValuesSupported;
    }

    public void setRequestObjectEncryptionAlgValuesSupported(List<String> requestObjectEncryptionAlgValuesSupported) {
        this.requestObjectEncryptionAlgValuesSupported = requestObjectEncryptionAlgValuesSupported;
    }

    public List<String> getRequestObjectEncryptionEncValuesSupported() {
        return this.requestObjectEncryptionEncValuesSupported;
    }

    public void setRequestObjectEncryptionEncValuesSupported(List<String> requestObjectEncryptionEncValuesSupported) {
        this.requestObjectEncryptionEncValuesSupported = requestObjectEncryptionEncValuesSupported;
    }

    public List<String> getTokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported;
    }

    public void setTokenEndpointAuthMethodsSupported(List<String> tokenEndpointAuthMethodsSupported) {
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
    }

    public List<String> getTokenEndpointAuthSigningAlgValuesSupported() {
        return this.tokenEndpointAuthSigningAlgValuesSupported;
    }

    public void setTokenEndpointAuthSigningAlgValuesSupported(List<String> tokenEndpointAuthSigningAlgValuesSupported) {
        this.tokenEndpointAuthSigningAlgValuesSupported = tokenEndpointAuthSigningAlgValuesSupported;
    }

    public List<String> getDisplayValuesSupported() {
        return this.displayValuesSupported;
    }

    public void setDisplayValuesSupported(List<String> displayValuesSupported) {
        this.displayValuesSupported = displayValuesSupported;
    }

    public List<String> getClaimTypesSupported() {
        return this.claimTypesSupported;
    }

    public void setClaimTypesSupported(List<String> claimTypesSupported) {
        this.claimTypesSupported = claimTypesSupported;
    }

    public List<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    public void setClaimsSupported(List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    public List<String> getIdTokenTokenBindingCnfValuesSupported() {
        return this.idTokenTokenBindingCnfValuesSupported;
    }

    public void setIdTokenTokenBindingCnfValuesSupported(List<String> idTokenTokenBindingCnfValuesSupported) {
        this.idTokenTokenBindingCnfValuesSupported = idTokenTokenBindingCnfValuesSupported;
    }

    public String getServiceDocumentation() {
        return this.serviceDocumentation;
    }

    public void setServiceDocumentation(String serviceDocumentation) {
        this.serviceDocumentation = serviceDocumentation;
    }

    public List<String> getClaimsLocalesSupported() {
        return this.claimsLocalesSupported;
    }

    public void setClaimsLocalesSupported(List<String> claimsLocalesSupported) {
        this.claimsLocalesSupported = claimsLocalesSupported;
    }

    public List<String> getUiLocalesSupported() {
        return this.uiLocalesSupported;
    }

    public void setUiLocalesSupported(List<String> uiLocalesSupported) {
        this.uiLocalesSupported = uiLocalesSupported;
    }

    public Boolean getClaimsParameterSupported() {
        return this.claimsParameterSupported;
    }

    public void setClaimsParameterSupported(Boolean claimsParameterSupported) {
        this.claimsParameterSupported = claimsParameterSupported;
    }

    public Boolean getRequestParameterSupported() {
        return this.requestParameterSupported;
    }

    public void setRequestParameterSupported(Boolean requestParameterSupported) {
        this.requestParameterSupported = requestParameterSupported;
    }

    public Boolean getRequestUriParameterSupported() {
        return this.requestUriParameterSupported;
    }

    public void setRequestUriParameterSupported(Boolean requestUriParameterSupported) {
        this.requestUriParameterSupported = requestUriParameterSupported;
    }

    public Boolean getRequireRequestUriRegistration() {
        return this.requireRequestUriRegistration;
    }

    public void setRequireRequestUriRegistration(Boolean requireRequestUriRegistration) {
        this.requireRequestUriRegistration = requireRequestUriRegistration;
    }

    public String getOpPolicyUri() {
        return this.opPolicyUri;
    }

    public void setOpPolicyUri(String opPolicyUri) {
        this.opPolicyUri = opPolicyUri;
    }

    public String getOpTosUri() {
        return this.opTosUri;
    }

    public void setOpTosUri(String opTosUri) {
        this.opTosUri = opTosUri;
    }

    public Boolean getFrontChannelLogoutSupported() {
        return this.frontChannelLogoutSupported;
    }

    public void setFrontChannelLogoutSupported(Boolean frontChannelLogoutSupported) {
        this.frontChannelLogoutSupported = frontChannelLogoutSupported;
    }

    public Boolean getFrontChannelLogoutSessionSupported() {
        return this.frontChannelLogoutSessionSupported;
    }

    public void setFrontChannelLogoutSessionSupported(Boolean frontChannelLogoutSessionSupported) {
        this.frontChannelLogoutSessionSupported = frontChannelLogoutSessionSupported;
    }

    public String toString() {
        return "OpenIdConfigurationResponse{issuer='" + this.issuer + '\'' + ", authorizationEndpoint='" + this.authorizationEndpoint + '\'' + ", tokenEndpoint='" + this.tokenEndpoint + '\'' + ", userInfoEndpoint='" + this.userInfoEndpoint + '\'' + ", clientInfoEndpoint='" + this.clientInfoEndpoint + '\'' + ", checkSessionIFrame='" + this.checkSessionIFrame + '\'' + ", endSessionEndpoint='" + this.endSessionEndpoint + '\'' + ", jwksUri='" + this.jwksUri + '\'' + ", registrationEndpoint='" + this.registrationEndpoint + '\'' + ", idGenerationEndpoint='" + this.idGenerationEndpoint + '\'' + ", introspectionEndpoint='" + this.introspectionEndpoint + '\'' + ", scopesSupported=" + this.scopesSupported + ", responseTypesSupported=" + this.responseTypesSupported + ", grantTypesSupported=" + this.grantTypesSupported + ", acrValuesSupported=" + this.acrValuesSupported + ", subjectTypesSupported=" + this.subjectTypesSupported + ", userInfoSigningAlgValuesSupported=" + this.userInfoSigningAlgValuesSupported + ", userInfoEncryptionAlgValuesSupported=" + this.userInfoEncryptionAlgValuesSupported + ", userInfoEncryptionEncValuesSupported=" + this.userInfoEncryptionEncValuesSupported + ", idTokenSigningAlgValuesSupported=" + this.idTokenSigningAlgValuesSupported + ", idTokenEncryptionAlgValuesSupported=" + this.idTokenEncryptionAlgValuesSupported + ", idTokenEncryptionEncValuesSupported=" + this.idTokenEncryptionEncValuesSupported + ", requestObjectSigningAlgValuesSupported=" + this.requestObjectSigningAlgValuesSupported + ", requestObjectEncryptionAlgValuesSupported=" + this.requestObjectEncryptionAlgValuesSupported + ", requestObjectEncryptionEncValuesSupported=" + this.requestObjectEncryptionEncValuesSupported + ", tokenEndpointAuthMethodsSupported=" + this.tokenEndpointAuthMethodsSupported + ", tokenEndpointAuthSigningAlgValuesSupported=" + this.tokenEndpointAuthSigningAlgValuesSupported + ", displayValuesSupported=" + this.displayValuesSupported + ", claimTypesSupported=" + this.claimTypesSupported + ", claimsSupported=" + this.claimsSupported + ", idTokenTokenBindingCnfValuesSupported=" + this.idTokenTokenBindingCnfValuesSupported + ", serviceDocumentation='" + this.serviceDocumentation + '\'' + ", claimsLocalesSupported=" + this.claimsLocalesSupported + ", uiLocalesSupported=" + this.uiLocalesSupported + ", claimsParameterSupported=" + this.claimsParameterSupported + ", requestParameterSupported=" + this.requestParameterSupported + ", requestUriParameterSupported=" + this.requestUriParameterSupported + ", frontChannelLogoutSupported=" + this.frontChannelLogoutSupported + ", frontChannelLogoutSessionSupported=" + this.frontChannelLogoutSessionSupported + ", requireRequestUriRegistration=" + this.requireRequestUriRegistration + ", opPolicyUri='" + this.opPolicyUri + '\'' + ", opTosUri='" + this.opTosUri + '\'' + ", scopeToClaimsMapping=" + this.scopeToClaimsMapping + '}';
    }
}

