/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.idp.externalauth;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import org.apache.commons.lang.StringUtils;
import org.gluu.idp.externalauth.AuthenticatedNameTranslator;
import org.gluu.idp.externalauth.OxAuthToShibTranslator;
import org.gluu.idp.externalauth.openid.client.IdpAuthClient;
import org.gluu.oxauth.client.auth.principal.OpenIdCredentials;
import org.gluu.oxauth.client.auth.user.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.web.context.WebApplicationContext;
import org.xdi.context.J2EContext;
import org.xdi.context.WebContext;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.Jwt;

@WebServlet(name="ShibOxAuthAuthServlet", urlPatterns={"/Authn/oxAuth/*"})
public class ShibOxAuthAuthServlet
extends HttpServlet {
    private static final long serialVersionUID = -4864851392327422662L;
    private final Logger logger = LoggerFactory.getLogger(ShibOxAuthAuthServlet.class);
    private final String OXAUTH_PARAM_ENTITY_ID = "entityId";
    @Autowired
    @Qualifier(value="idpOxAuthClient")
    private IdpAuthClient idpAuthClient;
    private final Set<OxAuthToShibTranslator> translators = new HashSet<OxAuthToShibTranslator>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.idpAuthClient = new IdpAuthClient();
        ApplicationContext ac = (ApplicationContext)config.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        this.buildTranslators(ac.getEnvironment());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String requestUrl = request.getRequestURL().toString();
            this.logger.trace("Get request to: '{}'", (Object)requestUrl);
            boolean logoutEndpoint = requestUrl.endsWith("/logout");
            if (logoutEndpoint) {
                this.processLogoutRequest(request, response);
                return;
            }
            J2EContext context = new J2EContext(request, response);
            boolean authorizationResponse = this.idpAuthClient.isAuthorizationResponse((WebContext)context);
            Object externalRequest = request;
            if (authorizationResponse) {
                try {
                    final Jwt jwt = Jwt.parse((String)this.idpAuthClient.getRequestState((WebContext)context));
                    externalRequest = new HttpServletRequestWrapper(request){

                        public String getParameter(String name) {
                            if (jwt.getClaims().hasClaim(name)) {
                                return jwt.getClaims().getClaimAsString(name);
                            }
                            return super.getParameter(name);
                        }
                    };
                }
                catch (InvalidJwtException ex) {
                    this.logger.debug("State is not in JWT format", (Throwable)ex);
                }
            }
            String authenticationKey = ExternalAuthentication.startExternalAuthentication((HttpServletRequest)externalRequest);
            boolean force = Boolean.parseBoolean(request.getAttribute("forceAuthn").toString());
            if (!authorizationResponse) {
                this.logger.debug("Initiating oxAuth login redirect");
                this.startLoginRequest(request, response, force);
                return;
            }
            this.logger.info("Procession authorization response");
            if (!this.idpAuthClient.isValidRequestState((WebContext)context)) {
                this.logger.error("The state in session and in request are not equals");
                this.startLoginRequest(request, response, force);
                return;
            }
            this.processAuthorizationResponse(request, response, authenticationKey);
        }
        catch (ExternalAuthenticationException ex) {
            this.logger.warn("Error processing oxAuth authentication request", (Throwable)ex);
            this.loadErrorPage(request, response);
        }
        catch (Exception ex) {
            this.logger.error("Something unexpected happened", (Throwable)ex);
            request.setAttribute("authnError", (Object)"AuthenticationException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAuthorizationResponse(HttpServletRequest request, HttpServletResponse response, String authenticationKey) throws ExternalAuthenticationException, IOException {
        try {
            J2EContext context = new J2EContext(request, response);
            OpenIdCredentials openIdCredentials = this.idpAuthClient.getCredentials((WebContext)context);
            this.logger.debug("Client name : '{}'", (Object)openIdCredentials.getClientName());
            UserProfile userProfile = this.idpAuthClient.getUserProfile(openIdCredentials, (WebContext)context);
            this.logger.debug("User profile : {}", (Object)userProfile);
            if (userProfile == null) {
                this.logger.error("Token validation failed, returning InvalidToken");
                request.setAttribute("authnError", (Object)"InvalidToken");
            } else {
                for (OxAuthToShibTranslator translator : this.translators) {
                    translator.doTranslation(request, response, userProfile, authenticationKey);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Token validation failed, returning InvalidToken", (Throwable)ex);
            request.setAttribute("authnError", (Object)"InvalidToken");
        }
        finally {
            ExternalAuthentication.finishExternalAuthentication((String)authenticationKey, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected void startLoginRequest(HttpServletRequest request, HttpServletResponse response, Boolean force) {
        try {
            J2EContext context = new J2EContext(request, response);
            HashMap<String, String> customResponseHeaders = new HashMap<String, String>();
            String convId = request.getParameter("conversation");
            customResponseHeaders.put("conversation", convId);
            HashMap<String, String> customParameters = new HashMap<String, String>();
            String relayingPartyId = request.getAttribute("relyingParty").toString();
            customParameters.put("entityId", relayingPartyId);
            String loginUrl = this.idpAuthClient.getRedirectionUrl((WebContext)context, customResponseHeaders, customParameters);
            this.logger.debug("Generated redirection Url", (Object)loginUrl);
            this.logger.debug("loginUrl: {}", (Object)loginUrl);
            response.sendRedirect(loginUrl);
        }
        catch (IOException ex) {
            this.logger.error("Unable to redirect to oxAuth from ShibOxAuth", (Throwable)ex);
        }
    }

    protected void processLogoutRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            J2EContext context = new J2EContext(request, response);
            String logoutUrl = this.idpAuthClient.getLogoutRedirectionUrl((WebContext)context);
            this.logger.debug("Generated logout redirection Url", (Object)logoutUrl);
            this.logger.debug("logoutUrl: {}", (Object)logoutUrl);
            response.sendRedirect(logoutUrl);
        }
        catch (IOException ex) {
            this.logger.error("Unable to redirect to oxAuth from ShibOxAuth", (Throwable)ex);
        }
    }

    private void buildTranslators(Environment environment) {
        this.translators.add(new AuthenticatedNameTranslator());
        String oxAuthToShibTranslators = StringUtils.defaultString((String)environment.getProperty("shib.oxauth.oxAuthToShibTranslator", ""));
        for (String classname : StringUtils.split((String)oxAuthToShibTranslators, (char)';')) {
            try {
                this.logger.debug("Loading translator class {}", (Object)classname);
                Class<?> c = Class.forName(classname);
                OxAuthToShibTranslator e = (OxAuthToShibTranslator)c.newInstance();
                if (e instanceof EnvironmentAware) {
                    ((EnvironmentAware)e).setEnvironment(environment);
                }
                this.translators.add(e);
                this.logger.debug("Added translator class {}", (Object)classname);
            }
            catch (Exception ex) {
                this.logger.error("Error building oxAuth to Shib translator with name: " + classname, (Throwable)ex);
            }
        }
    }

    private void loadErrorPage(HttpServletRequest request, HttpServletResponse response) {
        RequestDispatcher requestDispatcher = request.getRequestDispatcher("/no-conversation-state.jsp");
        try {
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            this.logger.error("Error rendering the empty conversation state (shib-oxauth-authn3) error view.");
            response.resetBuffer();
            response.setStatus(404);
        }
    }
}

