/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.token.ClientAssertionType;

public class TokenClient
extends BaseClient<TokenRequest, TokenResponse> {
    private static final Logger LOG = Logger.getLogger(TokenClient.class);

    public TokenClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public TokenResponse execAuthorizationCode(String code, String redirectUri, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.AUTHORIZATION_CODE));
        ((TokenRequest)this.getRequest()).setCode(code);
        ((TokenRequest)this.getRequest()).setRedirectUri(redirectUri);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execResourceOwnerPasswordCredentialsGrant(String username, String password, String scope, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS));
        ((TokenRequest)this.getRequest()).setUsername(username);
        ((TokenRequest)this.getRequest()).setPassword(password);
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execClientCredentialsGrant(String scope, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.CLIENT_CREDENTIALS));
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execExtensionGrant(String grantTypeUri, String assertion, String clientId, String clientSecret) {
        GrantType grantType = GrantType.fromString((String)grantTypeUri);
        this.setRequest(new TokenRequest(grantType));
        ((TokenRequest)this.getRequest()).setAssertion(assertion);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execRefreshToken(String scope, String refreshToken, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.REFRESH_TOKEN));
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setRefreshToken(refreshToken);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse exec() {
        this.initClientRequest();
        if (((TokenRequest)this.request).getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC && ((TokenRequest)this.request).hasCredentials()) {
            this.clientRequest.header("Authorization", (Object)("Basic " + ((TokenRequest)this.request).getEncodedCredentials()));
        }
        this.clientRequest.header("Content-Type", (Object)((TokenRequest)this.request).getContentType());
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (((TokenRequest)this.getRequest()).getGrantType() != null) {
            this.clientRequest.formParameter("grant_type", (Object)((TokenRequest)this.getRequest()).getGrantType());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getCode())) {
            this.clientRequest.formParameter("code", (Object)((TokenRequest)this.getRequest()).getCode());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getCodeVerifier())) {
            this.clientRequest.formParameter("code_verifier", (Object)((TokenRequest)this.getRequest()).getCodeVerifier());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getRedirectUri())) {
            this.clientRequest.formParameter("redirect_uri", (Object)((TokenRequest)this.getRequest()).getRedirectUri());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getUsername())) {
            this.clientRequest.formParameter("username", (Object)((TokenRequest)this.getRequest()).getUsername());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getPassword())) {
            this.clientRequest.formParameter("password", (Object)((TokenRequest)this.getRequest()).getPassword());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getScope())) {
            this.clientRequest.formParameter("scope", (Object)((TokenRequest)this.getRequest()).getScope());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getAssertion())) {
            this.clientRequest.formParameter("assertion", (Object)((TokenRequest)this.getRequest()).getAssertion());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getRefreshToken())) {
            this.clientRequest.formParameter("refresh_token", (Object)((TokenRequest)this.getRequest()).getRefreshToken());
        }
        if (((TokenRequest)this.getRequest()).getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_POST) {
            if (((TokenRequest)this.getRequest()).getAuthUsername() != null && !((TokenRequest)this.getRequest()).getAuthUsername().isEmpty()) {
                this.clientRequest.formParameter("client_id", (Object)((TokenRequest)this.getRequest()).getAuthUsername());
            }
            if (((TokenRequest)this.getRequest()).getAuthPassword() != null && !((TokenRequest)this.getRequest()).getAuthPassword().isEmpty()) {
                this.clientRequest.formParameter("client_secret", (Object)((TokenRequest)this.getRequest()).getAuthPassword());
            }
        } else if (((TokenRequest)this.getRequest()).getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_JWT || ((TokenRequest)this.getRequest()).getAuthenticationMethod() == AuthenticationMethod.PRIVATE_KEY_JWT) {
            this.clientRequest.formParameter("client_assertion_type", (Object)ClientAssertionType.JWT_BEARER);
            this.clientRequest.formParameter("client_assertion", (Object)((TokenRequest)this.getRequest()).getClientAssertion());
            if (((TokenRequest)this.getRequest()).getAuthUsername() != null && !((TokenRequest)this.getRequest()).getAuthUsername().isEmpty()) {
                this.clientRequest.formParameter("client_id", (Object)((TokenRequest)this.getRequest()).getAuthUsername());
            }
        }
        for (String key : ((TokenRequest)this.getRequest()).getCustomParameters().keySet()) {
            this.clientRequest.formParameter(key, (Object)((TokenRequest)this.getRequest()).getCustomParameters().get(key));
        }
        try {
            this.clientResponse = this.clientRequest.post(String.class);
            TokenResponse tokenResponse = new TokenResponse((ClientResponse<String>)this.clientResponse);
            tokenResponse.injectDataFromJson();
            this.setResponse(tokenResponse);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (TokenResponse)this.getResponse();
    }
}

