/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.IOException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.OpenIdConfigurationRequest;
import org.xdi.oxauth.client.OpenIdConfigurationResponse;
import org.xdi.oxauth.model.util.Util;

public class OpenIdConfigurationClient
extends BaseClient<OpenIdConfigurationRequest, OpenIdConfigurationResponse> {
    private static final Logger LOG = Logger.getLogger(OpenIdConfigurationClient.class);
    private static final String mediaTypes = String.join((CharSequence)",", "text/plain", "application/json");

    public OpenIdConfigurationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public OpenIdConfigurationResponse execOpenIdConfiguration() throws IOException {
        this.initClientRequest();
        return this._execOpenIdConfiguration();
    }

    @Deprecated
    public OpenIdConfigurationResponse execOpenIdConfiguration(ClientExecutor executor) throws IOException {
        this.clientRequest = new ClientRequest(this.getUrl(), executor);
        return this._execOpenIdConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenIdConfigurationResponse _execOpenIdConfiguration() throws IOException {
        this.setRequest(new OpenIdConfigurationRequest());
        this.clientRequest.accept(mediaTypes);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        try {
            this.clientResponse = this.clientRequest.get(String.class);
            int status = this.clientResponse.getStatus();
            this.setResponse(new OpenIdConfigurationResponse(status));
            String entity = (String)this.clientResponse.getEntity(String.class);
            ((OpenIdConfigurationResponse)this.getResponse()).setEntity(entity);
            ((OpenIdConfigurationResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
            if (StringUtils.isNotBlank((String)entity)) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("issuer")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setIssuer(jsonObj.getString("issuer"));
                }
                if (jsonObj.has("authorization_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setAuthorizationEndpoint(jsonObj.getString("authorization_endpoint"));
                }
                if (jsonObj.has("token_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setTokenEndpoint(jsonObj.getString("token_endpoint"));
                }
                if (jsonObj.has("userinfo_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setUserInfoEndpoint(jsonObj.getString("userinfo_endpoint"));
                }
                if (jsonObj.has("clientinfo_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setClientInfoEndpoint(jsonObj.getString("clientinfo_endpoint"));
                }
                if (jsonObj.has("check_session_iframe")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setCheckSessionIFrame(jsonObj.getString("check_session_iframe"));
                }
                if (jsonObj.has("end_session_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setEndSessionEndpoint(jsonObj.getString("end_session_endpoint"));
                }
                if (jsonObj.has("jwks_uri")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setJwksUri(jsonObj.getString("jwks_uri"));
                }
                if (jsonObj.has("registration_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setRegistrationEndpoint(jsonObj.getString("registration_endpoint"));
                }
                if (jsonObj.has("id_generation_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setIdGenerationEndpoint(jsonObj.getString("id_generation_endpoint"));
                }
                if (jsonObj.has("introspection_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setIntrospectionEndpoint(jsonObj.getString("introspection_endpoint"));
                }
                if (jsonObj.has("scope_to_claims_mapping")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setScopeToClaimsMapping(OpenIdConfigurationResponse.parseScopeToClaimsMapping(jsonObj.getJSONArray("scope_to_claims_mapping")));
                }
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getScopesSupported(), (JSONObject)jsonObj, (String)"scopes_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getResponseTypesSupported(), (JSONObject)jsonObj, (String)"response_types_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getGrantTypesSupported(), (JSONObject)jsonObj, (String)"grant_types_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getAcrValuesSupported(), (JSONObject)jsonObj, (String)"acr_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getSubjectTypesSupported(), (JSONObject)jsonObj, (String)"subject_types_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getUserInfoSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_signing_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getUserInfoEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_encryption_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getUserInfoEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_encryption_enc_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getIdTokenSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"id_token_signing_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getIdTokenEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"id_token_encryption_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getIdTokenEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"id_token_encryption_enc_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getRequestObjectSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"request_object_signing_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getRequestObjectEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"request_object_encryption_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getRequestObjectEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"request_object_encryption_enc_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getTokenEndpointAuthMethodsSupported(), (JSONObject)jsonObj, (String)"token_endpoint_auth_methods_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getTokenEndpointAuthSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"token_endpoint_auth_signing_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getDisplayValuesSupported(), (JSONObject)jsonObj, (String)"display_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getClaimTypesSupported(), (JSONObject)jsonObj, (String)"claim_types_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getClaimsSupported(), (JSONObject)jsonObj, (String)"claims_supported");
                if (jsonObj.has("service_documentation")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setServiceDocumentation(jsonObj.getString("service_documentation"));
                }
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getClaimsLocalesSupported(), (JSONObject)jsonObj, (String)"claims_locales_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getUiLocalesSupported(), (JSONObject)jsonObj, (String)"ui_locales_supported");
                if (jsonObj.has("claims_parameter_supported")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setClaimsParameterSupported(jsonObj.getBoolean("claims_parameter_supported"));
                }
                if (jsonObj.has("request_parameter_supported")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setRequestParameterSupported(jsonObj.getBoolean("request_parameter_supported"));
                }
                if (jsonObj.has("request_uri_parameter_supported")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setRequestUriParameterSupported(jsonObj.getBoolean("request_uri_parameter_supported"));
                }
                if (jsonObj.has("frontchannel_logout_supported")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setFrontChannelLogoutSupported(jsonObj.getBoolean("frontchannel_logout_supported"));
                }
                if (jsonObj.has("frontchannel_logout_session_supported")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setFrontChannelLogoutSessionSupported(jsonObj.getBoolean("frontchannel_logout_session_supported"));
                }
                if (jsonObj.has("require_request_uri_registration")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setRequireRequestUriRegistration(jsonObj.getBoolean("require_request_uri_registration"));
                }
                if (jsonObj.has("op_policy_uri")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setOpPolicyUri(jsonObj.getString("op_policy_uri"));
                }
                if (jsonObj.has("op_tos_uri")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setOpTosUri(jsonObj.getString("op_tos_uri"));
                }
            }
        }
        catch (JSONException e) {
            LOG.error((Object)"There is an error in the JSON response. Check if there is a syntax error in the JSON response or there is a wrong key", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (OpenIdConfigurationResponse)this.getResponse();
    }
}

