/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.RandomStringUtils;
import org.gluu.oxauth.client.Client;
import org.gluu.oxauth.client.auth.principal.OpenIdCredentials;
import org.gluu.oxauth.client.auth.user.CommonProfile;
import org.gluu.oxauth.client.auth.user.UserProfile;
import org.gluu.oxauth.client.conf.AppConfiguration;
import org.gluu.oxauth.client.conf.ClaimToAttributeMapping;
import org.gluu.oxauth.client.conf.Configuration;
import org.gluu.oxauth.client.conf.LdapAppConfiguration;
import org.gluu.oxauth.client.exception.CommunicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.context.WebContext;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.EndSessionRequest;
import org.xdi.oxauth.client.OpenIdConfigurationClient;
import org.xdi.oxauth.client.OpenIdConfigurationResponse;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.util.StringHelper;
import org.xdi.util.exception.ConfigurationException;
import org.xdi.util.init.Initializable;
import org.xdi.util.security.StringEncrypter;

public class OpenIdClient<C extends AppConfiguration, L extends LdapAppConfiguration>
extends Initializable
implements Client<UserProfile> {
    private final Logger logger = LoggerFactory.getLogger(OpenIdClient.class);
    private static final String SESSION_STATE_PARAMETER = "#session_state_parameter";
    private static final String SESSION_NONCE_PARAMETER = "#session_nonce_parameter";
    private static final String SESSION_ID_TOKEN_PARAMETER = "#session_id_token";
    private static final long NEW_CLIENT_EXPIRATION_OVERLAP = 60000L;
    private final ReentrantLock clientLock = new ReentrantLock();
    private C appConfiguration;
    private String clientId;
    private String clientSecret;
    private long clientExpiration;
    private boolean preRegisteredClient;
    private OpenIdConfigurationResponse openIdConfiguration;
    private Configuration<C, L> configuration;

    public OpenIdClient(Configuration<C, L> configuration) {
        this.configuration = configuration;
        this.appConfiguration = configuration.getAppConfiguration();
    }

    public void init() {
        super.init();
        this.initClient();
    }

    protected void initInternal() {
        this.clientId = ((AppConfiguration)this.appConfiguration).getOpenIdClientId();
        this.clientSecret = ((AppConfiguration)this.appConfiguration).getOpenIdClientPassword();
        if (StringHelper.isNotEmpty((String)this.clientSecret)) {
            try {
                StringEncrypter stringEncrypter = StringEncrypter.instance((String)this.configuration.getCryptoConfigurationSalt());
                this.clientSecret = stringEncrypter.decrypt(this.clientSecret);
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.logger.warn("Assuming that client password is not encrypted!");
            }
        }
        this.preRegisteredClient = StringHelper.isNotEmpty((String)this.clientId) && StringHelper.isNotEmpty((String)this.clientSecret);
        try {
            this.loadOpenIdConfiguration();
        }
        catch (IOException ex) {
            throw new ConfigurationException("Failed to load oxAuth configuration");
        }
    }

    private void loadOpenIdConfiguration() throws IOException {
        String openIdProvider = ((AppConfiguration)this.appConfiguration).getOpenIdProviderUrl();
        if (StringHelper.isEmpty((String)openIdProvider)) {
            throw new ConfigurationException("OpenIdProvider Url is invalid");
        }
        OpenIdConfigurationClient openIdConfigurationClient = new OpenIdConfigurationClient(openIdProvider);
        OpenIdConfigurationResponse response = openIdConfigurationClient.execOpenIdConfiguration();
        if (response == null || response.getStatus() != 200) {
            throw new ConfigurationException("Failed to load oxAuth configuration");
        }
        this.logger.info("Successfully loaded oxAuth configuration");
        this.openIdConfiguration = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClient() {
        if (this.preRegisteredClient) {
            return;
        }
        long now = System.currentTimeMillis();
        if (!this.isValidClient(now)) {
            this.clientLock.lock();
            try {
                now = System.currentTimeMillis();
                if (!this.isValidClient(now)) {
                    RegisterResponse clientRegisterResponse = this.registerOpenIdClient();
                    this.clientId = clientRegisterResponse.getClientId();
                    this.clientSecret = clientRegisterResponse.getClientSecret();
                    this.clientExpiration = clientRegisterResponse.getClientSecretExpiresAt().getTime();
                }
            }
            finally {
                this.clientLock.unlock();
            }
        }
    }

    private boolean isValidClient(long now) {
        return !StringHelper.isEmpty((String)this.clientId) && !StringHelper.isEmpty((String)this.clientSecret) && this.clientExpiration - 60000L > now;
    }

    private RegisterResponse registerOpenIdClient() {
        this.logger.info("Registering OpenId client");
        String clientName = ((AppConfiguration)this.appConfiguration).getApplicationName() + " client";
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, clientName, Arrays.asList(((AppConfiguration)this.appConfiguration).getOpenIdRedirectUrl()));
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        RegisterClient registerClient = new RegisterClient(this.openIdConfiguration.getRegistrationEndpoint());
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        if (response == null || response.getStatus() != 200) {
            throw new ConfigurationException("Failed to register new client");
        }
        return response;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getRedirectionUrl(WebContext context) {
        return this.getRedirectionUrl(context, null, null);
    }

    @Override
    public String getRedirectionUrl(WebContext context, Map<String, String> customStateParameters, Map<String, String> customParameters) {
        this.init();
        String state = RandomStringUtils.randomAlphanumeric((int)10);
        String nonce = RandomStringUtils.randomAlphanumeric((int)10);
        if (customStateParameters != null) {
            Jwt jwt = new Jwt();
            jwt.getHeader().setType(JwtType.JWT);
            jwt.getHeader().setAlgorithm(SignatureAlgorithm.NONE);
            for (Map.Entry<String, String> entry : customStateParameters.entrySet()) {
                jwt.getClaims().setClaim(entry.getKey(), entry.getValue());
            }
            jwt.getClaims().setClaim("state", state);
            state = jwt.toString();
        }
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(Arrays.asList(ResponseType.CODE), this.clientId, ((AppConfiguration)this.appConfiguration).getOpenIdScopes(), ((AppConfiguration)this.appConfiguration).getOpenIdRedirectUrl(), null);
        authorizationRequest.setState(state);
        authorizationRequest.setNonce(nonce);
        context.setSessionAttribute(this.getName() + SESSION_STATE_PARAMETER, (Object)state);
        context.setSessionAttribute(this.getName() + SESSION_NONCE_PARAMETER, (Object)nonce);
        if (customParameters != null) {
            for (Map.Entry<String, String> entry : customParameters.entrySet()) {
                authorizationRequest.addCustomParameter(entry.getKey(), entry.getValue());
            }
        }
        String redirectionUrl = this.openIdConfiguration.getAuthorizationEndpoint() + "?" + authorizationRequest.getQueryString();
        this.logger.debug("oxAuth redirection Url: '{}'", (Object)redirectionUrl);
        return redirectionUrl;
    }

    @Override
    public String getLogoutRedirectionUrl(WebContext context) {
        this.init();
        String state = RandomStringUtils.randomAlphanumeric((int)10);
        String postLogoutRedirectUri = ((AppConfiguration)this.appConfiguration).getOpenIdPostLogoutRedirectUri();
        String idToken = (String)context.getSessionAttribute(this.getName() + SESSION_ID_TOKEN_PARAMETER);
        if (idToken == null) {
            idToken = "";
        }
        EndSessionRequest endSessionRequest = new EndSessionRequest(idToken, postLogoutRedirectUri, state);
        String redirectionUrl = this.openIdConfiguration.getEndSessionEndpoint() + "?" + endSessionRequest.getQueryString();
        this.logger.debug("oxAuth redirection Url: '{}'", (Object)redirectionUrl);
        return redirectionUrl;
    }

    @Override
    public boolean isAuthorizationResponse(WebContext context) {
        String authorizationCode = context.getRequestParameter(ResponseType.CODE.getValue());
        this.logger.debug("oxAuth authorization code: '{}'", (Object)authorizationCode);
        boolean result = StringHelper.isNotEmpty((String)authorizationCode);
        this.logger.debug("Is authorization request: '{}'", (Object)result);
        return result;
    }

    @Override
    public boolean isValidRequestState(WebContext context) {
        String state = context.getRequestParameter("state");
        this.logger.debug("oxAuth request state: '{}'", (Object)state);
        Object sessionState = context.getSessionAttribute(this.getName() + SESSION_STATE_PARAMETER);
        this.logger.debug("Session context state: '{}'", sessionState);
        boolean emptySessionState = StringHelper.isEmptyString((Object)sessionState);
        if (emptySessionState) {
            return false;
        }
        boolean result = StringHelper.equals((String)state, (String)((String)sessionState));
        this.logger.debug("Is valid state: '{}'", (Object)result);
        return result;
    }

    @Override
    public String getRequestState(WebContext context) {
        String state = context.getRequestParameter("state");
        return state;
    }

    @Override
    public final OpenIdCredentials getCredentials(WebContext context) {
        String authorizationCode = context.getRequestParameter(ResponseType.CODE.getValue());
        OpenIdCredentials clientCredential = new OpenIdCredentials(authorizationCode);
        clientCredential.setClientName(this.getName());
        this.logger.debug("Client credential: '{}'", (Object)clientCredential);
        return clientCredential;
    }

    @Override
    public UserProfile getUserProfile(OpenIdCredentials credential, WebContext context) {
        this.init();
        try {
            Jwt jwt;
            this.logger.debug("Getting access token");
            TokenClient tokenClient = new TokenClient(this.openIdConfiguration.getTokenEndpoint());
            TokenResponse tokenResponse = tokenClient.execAuthorizationCode(credential.getAuthorizationCode(), ((AppConfiguration)this.appConfiguration).getOpenIdRedirectUrl(), this.clientId, this.clientSecret);
            this.logger.trace("tokenResponse.getStatus(): '{}'", (Object)tokenResponse.getStatus());
            this.logger.trace("tokenResponse.getErrorType(): '{}'", (Object)tokenResponse.getErrorType());
            String accessToken = tokenResponse.getAccessToken();
            this.logger.trace("accessToken : " + accessToken);
            String idToken = tokenResponse.getIdToken();
            this.logger.trace("idToken : " + idToken);
            context.setSessionAttribute(this.getName() + SESSION_ID_TOKEN_PARAMETER, (Object)idToken);
            try {
                jwt = Jwt.parse((String)idToken);
            }
            catch (InvalidJwtException ex) {
                this.logger.error("Failed to parse id_token: {}", (Object)idToken);
                throw new CommunicationException("Failed to parse id_token");
            }
            UserInfoResponse userInfoResponse = this.getUserInfo(accessToken);
            CommonProfile profile = this.retrieveUserProfileFromUserInfoResponse(context, jwt, userInfoResponse);
            this.logger.debug("User profile: '{}'", (Object)profile);
            return profile;
        }
        catch (Exception ex) {
            throw new CommunicationException(ex);
        }
    }

    private UserInfoResponse getUserInfo(String accessToken) {
        this.logger.debug("Session validation successful. Getting user information");
        UserInfoClient userInfoClient = new UserInfoClient(this.openIdConfiguration.getUserInfoEndpoint());
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        this.logger.trace("userInfoResponse.getStatus(): '{}'", (Object)userInfoResponse.getStatus());
        this.logger.trace("userInfoResponse.getErrorType(): '{}'", (Object)userInfoResponse.getErrorType());
        this.logger.debug("userInfoResponse.getClaims(): '{}'", (Object)userInfoResponse.getClaims());
        return userInfoResponse;
    }

    protected CommonProfile retrieveUserProfileFromUserInfoResponse(WebContext context, Jwt jwt, UserInfoResponse userInfoResponse) {
        CommonProfile profile = new CommonProfile();
        String nonceResponse = (String)jwt.getClaims().getClaim("nonce");
        String nonceSession = (String)context.getSessionAttribute(this.getName() + SESSION_NONCE_PARAMETER);
        this.logger.debug("Session nonce: '{}'", (Object)nonceSession);
        if (!StringHelper.equals((String)nonceSession, (String)nonceResponse)) {
            this.logger.error("User info response:  nonce is not matching.");
            throw new CommunicationException("Nonce is not match" + nonceResponse + " : " + nonceSession);
        }
        String id = this.getFirstClaim(userInfoResponse, "user_name");
        if (StringHelper.isEmpty((String)id)) {
            id = this.getFirstClaim(userInfoResponse, "sub");
        }
        profile.setId(id);
        List<ClaimToAttributeMapping> claimMappings = ((AppConfiguration)this.appConfiguration).getOpenIdClaimMapping();
        if (claimMappings == null || claimMappings.size() == 0) {
            this.logger.info("Using default claims to attributes mapping");
            profile.setUserName(id);
            profile.setEmail(this.getFirstClaim(userInfoResponse, "email"));
            profile.setDisplayName(this.getFirstClaim(userInfoResponse, "name"));
            profile.setFirstName(this.getFirstClaim(userInfoResponse, "given_name"));
            profile.setFamilyName(this.getFirstClaim(userInfoResponse, "family_name"));
            profile.setZone(this.getFirstClaim(userInfoResponse, "zoneinfo"));
            profile.setLocale(this.getFirstClaim(userInfoResponse, "locale"));
        } else {
            for (ClaimToAttributeMapping mapping : claimMappings) {
                String attribute = mapping.getAttribute();
                String value = this.getFirstClaim(userInfoResponse, mapping.getClaim());
                profile.addAttribute(attribute, value);
                this.logger.trace("Adding attribute '{}' with value '{}'", (Object)attribute, (Object)value);
            }
        }
        return profile;
    }

    protected String getFirstClaim(UserInfoResponse userInfoResponse, String claimName) {
        List claims = userInfoResponse.getClaim(claimName);
        if (claims == null || claims.isEmpty()) {
            return null;
        }
        return (String)claims.get(0);
    }

    public C getAppConfiguration() {
        return this.appConfiguration;
    }

    public OpenIdConfigurationResponse getOpenIdConfiguration() {
        return this.openIdConfiguration;
    }
}

