/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.util.repository;

import java.util.Random;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;

public class RepositoryUtility {
    private static final Random random = new Random();

    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static String generateTreeFolderPath(int countLevels, int countFolderPerLevel, String fileName) {
        StringBuilder result = new StringBuilder();
        for (int remainLevels = countLevels; remainLevels > 0; --remainLevels) {
            result.append(RepositoryUtility.getRandomFolder(countFolderPerLevel)).append('/');
        }
        return result.append(fileName).toString();
    }

    private static String getRandomFolder(int countFolderPerLevel) {
        return String.valueOf((int)(random.nextFloat() * (float)countFolderPerLevel));
    }

    public static String getFileNameExtension(String fileName) {
        int idx = fileName.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return fileName.substring(idx);
    }

    public static String getFileName(String fileName) {
        return FilenameUtils.getName((String)fileName);
    }
}

