/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.util.io;

import java.io.IOException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.xdi.util.EasySSLProtocolSocketFactory;

public class HTTPFileDownloader {
    private static Logger log = Logger.getLogger(HTTPFileDownloader.class);
    private static Protocol easyhttps;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResource(String path, String contentType, String user, String password) {
        boolean isUseAuthentication;
        boolean bl = isUseAuthentication = user != null && password != null;
        if (!path.contains("://")) {
            path = "http://" + path;
        }
        String result = null;
        GetMethod method = new GetMethod(path);
        try {
            method.setRequestHeader("Accept", contentType);
            if (HTTPFileDownloader.getEasyhttps() == null) {
                HTTPFileDownloader.setEasyhttps(new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
            }
            Protocol.registerProtocol((String)"https", (Protocol)HTTPFileDownloader.getEasyhttps());
            HttpClient httpClient = isUseAuthentication ? HTTPFileDownloader.createHttpClientWithBasicAuth(user, password) : new HttpClient();
            httpClient.executeMethod((HttpMethod)method);
            if (method.getStatusCode() == 200) {
                result = method.getResponseBodyAsString();
            }
        }
        catch (IOException ex) {
            result = null;
            log.error((Object)String.format("Failed to get resource %s", path), (Throwable)ex);
        }
        catch (Exception ex) {
            result = null;
            log.error((Object)String.format("Failed to get resource %s", path), (Throwable)ex);
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    private static HttpClient createHttpClientWithBasicAuth(String userid, String password) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userid, password);
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        return httpClient;
    }

    public static void setEasyhttps(Protocol easyhttps) {
        HTTPFileDownloader.easyhttps = easyhttps;
    }

    public static Protocol getEasyhttps() {
        return easyhttps;
    }
}

