/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim2.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gluu.scim2.client.AbstractScimClient;
import gluu.scim2.client.exception.ScimInitializationException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gluu.oxauth.client.BaseRequest;
import org.gluu.oxauth.client.TokenClient;
import org.gluu.oxauth.client.TokenRequest;
import org.gluu.oxauth.client.TokenResponse;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.OxAuthCryptoProvider;
import org.gluu.util.StringHelper;

public class OAuthScimClient<T>
extends AbstractScimClient<T> {
    private static final long serialVersionUID = 3141592672017122134L;
    private static final String SCOPES = Stream.of("https://gluu.org/scim/users.read", "https://gluu.org/scim/users.write", "https://gluu.org/scim/groups.read", "https://gluu.org/scim/groups.write", "https://gluu.org/scim/fido.read", "https://gluu.org/scim/fido.write", "https://gluu.org/scim/fido2.read", "https://gluu.org/scim/fido2.write", "https://gluu.org/scim/all-resources.search", "https://gluu.org/scim/bulk").collect(Collectors.joining(" "));
    private Logger logger = LogManager.getLogger(this.getClass());
    private String access_token;
    private String tokenEndpoint;
    private String clientId;
    private String password;
    private AuthenticationMethod tokenEndpointAuthnMethod;
    private String keyId;
    private ObjectMapper mapper = new ObjectMapper();
    private OxAuthCryptoProvider cryptoProvider;

    public OAuthScimClient(Class<T> serviceClass, String serviceUrl, String OIDCMetadataUrl, String id, String secret, boolean secretPostAuthnMethod) throws Exception {
        super(serviceUrl, serviceClass);
        this.checkRequiredness(id, secret, OIDCMetadataUrl);
        this.clientId = id;
        this.password = secret;
        this.tokenEndpoint = this.getTokenEndpoint(OIDCMetadataUrl);
        this.tokenEndpointAuthnMethod = secretPostAuthnMethod ? AuthenticationMethod.CLIENT_SECRET_POST : AuthenticationMethod.CLIENT_SECRET_BASIC;
        this.updateTokens();
    }

    public OAuthScimClient(Class<T> serviceClass, String serviceUrl, String OIDCMetadataUrl, String id, Path keyStorePath, String keyStorePassword, String keyId) throws Exception {
        super(serviceUrl, serviceClass);
        this.checkRequiredness(id, keyStorePassword, OIDCMetadataUrl);
        try {
            this.cryptoProvider = new OxAuthCryptoProvider(keyStorePath.toString(), keyStorePassword, null);
        }
        catch (Exception ex) {
            throw new ScimInitializationException("Failed to initialize crypto provider");
        }
        if (StringHelper.isEmpty((String)keyId)) {
            List aliases = this.cryptoProvider.getKeys();
            if (aliases.size() > 0) {
                keyId = (String)aliases.get(0);
            } else {
                throw new ScimInitializationException("No keys found in keystore");
            }
        }
        this.clientId = id;
        this.tokenEndpoint = this.getTokenEndpoint(OIDCMetadataUrl);
        this.tokenEndpointAuthnMethod = AuthenticationMethod.PRIVATE_KEY_JWT;
        this.keyId = keyId;
        this.updateTokens();
    }

    private void checkRequiredness(String ... args) throws ScimInitializationException {
        if (Stream.of(args).anyMatch(StringHelper::isEmpty)) {
            throw new ScimInitializationException("One or more required values are missing");
        }
    }

    private String getTokenEndpoint(String metadataUrl) throws Exception {
        JsonNode tree = this.mapper.readTree(new URL(metadataUrl));
        return tree.get("token_endpoint").asText();
    }

    private void updateTokens() throws Exception {
        this.access_token = this.getTokens().getAccessToken();
        this.logger.debug("Got token: " + this.access_token);
    }

    private TokenResponse getTokens() throws Exception {
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setAuthenticationMethod(this.tokenEndpointAuthnMethod);
        tokenRequest.setScope(SCOPES);
        tokenRequest.setAuthUsername(this.clientId);
        if (this.keyId == null) {
            tokenRequest.setAuthPassword(this.password);
        } else {
            tokenRequest.setCryptoProvider((AbstractCryptoProvider)this.cryptoProvider);
            tokenRequest.setAlgorithm(this.cryptoProvider.getSignatureAlgorithm(this.keyId));
            tokenRequest.setKeyId(this.keyId);
            tokenRequest.setAudience(this.tokenEndpoint);
        }
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        return tokenClient.exec();
    }

    @Override
    String getAuthenticationHeader() {
        return "Bearer " + this.access_token;
    }

    @Override
    boolean authorize(Response response) {
        try {
            this.updateTokens();
            return this.access_token != null;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

