/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim2.client;

import gluu.scim2.client.ClientMap;
import gluu.scim2.client.rest.FreelyAccessible;
import gluu.scim2.client.rest.provider.AuthorizationInjectionFilter;
import gluu.scim2.client.rest.provider.ListResponseProvider;
import gluu.scim2.client.rest.provider.ScimResourceProvider;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;

public abstract class AbstractScimClient<T>
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 9098930517944520482L;
    private Logger logger = LogManager.getLogger(this.getClass());
    private T scimService;
    private ResteasyClient client;

    AbstractScimClient(String domain, Class<T> serviceClass) {
        if (System.getProperty("httpclient.multithreaded") == null) {
            this.client = new ResteasyClientBuilder().build();
        } else {
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
            this.getIntegerProperty("httpclient.multithreaded.maxtotal").ifPresent(arg_0 -> ((PoolingHttpClientConnectionManager)cm).setMaxTotal(arg_0));
            this.getIntegerProperty("httpclient.multithreaded.maxperroute").ifPresent(arg_0 -> ((PoolingHttpClientConnectionManager)cm).setDefaultMaxPerRoute(arg_0));
            this.getIntegerProperty("httpclient.multithreaded.validateafterinactivity").ifPresent(arg_0 -> ((PoolingHttpClientConnectionManager)cm).setValidateAfterInactivity(arg_0));
            this.logger.debug("Using multithreaded support with maxTotalConnections={} and maxPerRoutConnections={}", (Object)cm.getMaxTotal(), (Object)cm.getDefaultMaxPerRoute());
            this.logger.warn("Ensure your oxTrust 'rptConnectionPoolUseConnectionPooling' property is set to true");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)cm).build();
            ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
            this.client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
        }
        ResteasyWebTarget target = this.client.target(domain);
        this.scimService = target.proxy(serviceClass);
        target.register(ListResponseProvider.class);
        target.register(AuthorizationInjectionFilter.class);
        target.register(ScimResourceProvider.class);
        ClientMap.update((Client)this.client, null);
    }

    private Response invokeServiceMethod(Method method, Object[] args) throws ReflectiveOperationException {
        this.logger.trace("Sending service request for method {}", (Object)method.getName());
        Response response = (Response)method.invoke(this.scimService, args);
        boolean buffered = false;
        try {
            buffered = response.bufferEntity();
        }
        catch (Exception e) {
            this.logger.trace(e.getMessage(), (Throwable)e);
        }
        this.logger.trace("Received response entity was{} buffered", (Object)(buffered ? "" : " not"));
        this.logger.trace("Response status code was {}", (Object)response.getStatus());
        return response;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Response response;
        String methodName = method.getName();
        if (methodName.equals("close")) {
            this.logger.info("Closing RestEasy client");
            ClientMap.remove((Client)this.client);
            return null;
        }
        FreelyAccessible unprotected = method.getAnnotation(FreelyAccessible.class);
        if (unprotected != null) {
            response = this.invokeServiceMethod(method, args);
        } else {
            ClientMap.update((Client)this.client, this.getAuthenticationHeader());
            response = this.invokeServiceMethod(method, args);
            if (response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                if (this.authorize(response)) {
                    this.logger.trace("Trying second attempt of request (former received unauthorized response code)");
                    ClientMap.update((Client)this.client, this.getAuthenticationHeader());
                    response = this.invokeServiceMethod(method, args);
                } else {
                    this.logger.error("Could not get access token for current request: {}", (Object)methodName);
                }
            }
        }
        return response;
    }

    abstract String getAuthenticationHeader();

    abstract boolean authorize(Response var1);

    private Optional<Integer> getIntegerProperty(String name) {
        return Optional.ofNullable(System.getProperty(name)).map(prop -> {
            try {
                return new Integer((String)prop);
            }
            catch (Exception e) {
                return null;
            }
        });
    }
}

