/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.config;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.config.oxtrust.AttributeResolverConfiguration;
import org.gluu.config.oxtrust.Configuration;
import org.gluu.exception.ConfigurationException;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.PersistenceConfiguration;
import org.gluu.persist.service.PersistanceFactoryService;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.AppConfigurationReloadEvent;
import org.gluu.service.cdi.event.ApplicationInitialized;
import org.gluu.service.cdi.event.ApplicationInitializedEvent;
import org.gluu.service.cdi.event.BaseConfigurationReload;
import org.gluu.service.cdi.event.ConfigurationEvent;
import org.gluu.service.cdi.event.ConfigurationUpdate;
import org.gluu.service.cdi.event.LdapConfigurationReload;
import org.gluu.service.cdi.event.Scheduled;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.gluu.util.StringHelper;
import org.gluu.util.init.Initializable;
import org.gluu.util.properties.FileConfiguration;
import org.slf4j.Logger;

public abstract class ConfigurationFactory<C>
extends Initializable {
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private Event<AppConfigurationReloadEvent> configurationUpdateEvent;
    @Inject
    private Event<String> event;
    @Inject
    @Named(value="persistenceEntryManager")
    private Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    @Inject
    private PersistanceFactoryService persistanceFactoryService;
    @Inject
    private Instance<Configuration> configurationInstance;
    public static final String PERSISTENCE_CONFIGUARION_RELOAD_EVENT_TYPE = "persistenceConfigurationReloadEvent";
    public static final String BASE_CONFIGUARION_RELOAD_EVENT_TYPE = "baseConfigurationReloadEvent";
    private static final int DEFAULT_INTERVAL = 30;
    public static final String BASE_DIR = System.getProperty("gluu.base") != null ? System.getProperty("gluu.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
    public static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    private static final String BASE_PROPERTIES_FILE = DIR + "gluu.properties";
    public static final String APP_PROPERTIES_FILE = DIR + "oxtrust.properties";
    public static final String APPLICATION_CONFIGURATION = "oxtrust-config.json";
    public static final String CACHE_PROPERTIES_FILE = "oxTrustCacheRefresh.properties";
    public static final String LOG_ROTATION_CONFIGURATION = "oxTrustLogRotationConfiguration.xml";
    public static final String SALT_FILE_NAME = "salt";
    private String confDir;
    private String configFilePath;
    private String cacheRefreshFilePath;
    private String logRotationFilePath;
    private String saltFilePath;
    private boolean loaded = false;
    protected FileConfiguration baseConfiguration;
    private PersistenceConfiguration persistenceConfiguration;
    protected AttributeResolverConfiguration attributeResolverConfiguration;
    private String cryptoConfigurationSalt;
    private AtomicBoolean isActive;
    private long baseConfigurationFileLastModifiedTime = -1L;
    private boolean loadedFromLdap = true;

    public void init(@Observes @ApplicationInitialized(value=ApplicationScoped.class) ApplicationInitializedEvent init) {
        this.init();
    }

    protected void initInternal() {
        this.isActive = new AtomicBoolean(true);
        try {
            this.log.info("Creating oxTrustConfiguration");
            this.loadBaseConfiguration();
            this.persistenceConfiguration = this.persistanceFactoryService.loadPersistenceConfiguration(this.getApplicationPropertiesFileName());
            this.confDir = this.confDir();
            this.configFilePath = this.confDir + APPLICATION_CONFIGURATION;
            this.cacheRefreshFilePath = this.confDir + CACHE_PROPERTIES_FILE;
            this.logRotationFilePath = this.confDir + LOG_ROTATION_CONFIGURATION;
            this.saltFilePath = this.confDir + SALT_FILE_NAME;
            this.loadCryptoConfigurationSalt();
        }
        finally {
            this.isActive.set(false);
        }
    }

    public void create() {
        this.init();
        if (!this.createFromDb()) {
            this.log.error("Failed to load configuration from LDAP. Please fix it!!!.");
            throw new ConfigurationException("Failed to load configuration from LDAP.");
        }
        this.log.info("Configuration loaded successfully.");
    }

    public void initTimer() {
        this.log.debug("Initializing Configuration Timer");
        int delay = 30;
        int interval = 30;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new ConfigurationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled ConfigurationEvent configurationEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading application configuration", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void reloadConfiguration() {
        long lastModified;
        File baseConfiguration;
        PersistenceConfiguration newPersistenceConfiguration = this.persistanceFactoryService.loadPersistenceConfiguration(this.getApplicationPropertiesFileName());
        if (!(newPersistenceConfiguration == null || StringHelper.equalsIgnoreCase((String)this.persistenceConfiguration.getFileName(), (String)newPersistenceConfiguration.getFileName()) && newPersistenceConfiguration.getLastModifiedTime() <= this.persistenceConfiguration.getLastModifiedTime())) {
            this.persistenceConfiguration = newPersistenceConfiguration;
            this.event.select(new Annotation[]{LdapConfigurationReload.Literal.INSTANCE}).fire((Object)PERSISTENCE_CONFIGUARION_RELOAD_EVENT_TYPE);
        }
        if ((baseConfiguration = new File(BASE_PROPERTIES_FILE)).exists() && (lastModified = baseConfiguration.lastModified()) > this.baseConfigurationFileLastModifiedTime) {
            this.loadBaseConfiguration();
            this.event.select(new Annotation[]{BaseConfigurationReload.Literal.INSTANCE}).fire((Object)BASE_CONFIGUARION_RELOAD_EVENT_TYPE);
        }
        if (!this.loadedFromLdap) {
            return;
        }
        C conf = this.loadConfigurationFromDb("oxRevision");
        if (conf == null) {
            return;
        }
        if (!this.isNewRevision(conf)) {
            return;
        }
        this.createFromDb();
    }

    public String confDir() {
        String confDir = this.baseConfiguration.getString("confDir", null);
        if (StringUtils.isNotBlank((String)confDir)) {
            return confDir;
        }
        return DIR;
    }

    public FileConfiguration getBaseConfiguration() {
        return this.baseConfiguration;
    }

    public PersistenceConfiguration getPersistenceConfiguration() {
        return this.persistenceConfiguration;
    }

    public AttributeResolverConfiguration getAttributeResolverConfiguration() {
        return this.attributeResolverConfiguration;
    }

    public String getCryptoConfigurationSalt() {
        return this.cryptoConfigurationSalt;
    }

    private void loadBaseConfiguration() {
        this.baseConfiguration = this.createFileConfiguration(BASE_PROPERTIES_FILE, true);
        File baseConfiguration = new File(BASE_PROPERTIES_FILE);
        this.baseConfigurationFileLastModifiedTime = baseConfiguration.lastModified();
    }

    public void loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = this.createFileConfiguration(this.saltFilePath, true);
            this.cryptoConfigurationSalt = cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            this.log.error("Failed to load configuration from {}", (Object)this.saltFilePath, (Object)ex);
            throw new ConfigurationException("Failed to load configuration from " + this.saltFilePath, (Throwable)ex);
        }
    }

    private FileConfiguration createFileConfiguration(String fileName, boolean isMandatory) {
        block3: {
            try {
                FileConfiguration fileConfiguration = new FileConfiguration(fileName);
                if (fileConfiguration.isLoaded()) {
                    this.log.debug("########## fileName = " + fileConfiguration.getFileName());
                    this.log.debug("########## oxtrust_ConfigurationEntryDN = " + fileConfiguration.getString("oxtrust_ConfigurationEntryDN"));
                    return fileConfiguration;
                }
            }
            catch (Exception ex) {
                if (!isMandatory) break block3;
                this.log.error("Failed to load configuration from {}", (Object)fileName, (Object)ex);
                throw new ConfigurationException("Failed to load configuration from " + fileName, (Throwable)ex);
            }
        }
        return null;
    }

    private boolean createFromDb() {
        this.log.info("Loading configuration from '{}' DB...", (Object)this.baseConfiguration.getString("persistence.type"));
        try {
            C conf = this.loadConfigurationFromDb(new String[0]);
            if (conf != null) {
                this.init(conf);
                if (this.loaded) {
                    this.destroryLoadedConfiguration();
                }
                this.loaded = true;
                this.configurationUpdateEvent.select(new Annotation[]{ConfigurationUpdate.Literal.INSTANCE}).fire((Object)new AppConfigurationReloadEvent());
                return true;
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    protected void destroy(Class<? extends Configuration> clazz) {
        Instance confInstance = this.configurationInstance.select(clazz, new Annotation[0]);
        this.configurationInstance.destroy((Object)((Configuration)confInstance.get()));
    }

    public abstract String getConfigurationDn();

    protected abstract String getApplicationPropertiesFileName();

    protected abstract void init(C var1);

    protected abstract C loadConfigurationFromDb(String ... var1);

    protected abstract void destroryLoadedConfiguration();

    protected abstract boolean isNewRevision(C var1);
}

