/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.util;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gluu.model.ldap.GluuLdapConfiguration;
import org.gluu.oxtrust.util.LdapConfigurationNamePredicate;
import org.gluu.oxtrust.util.LdapConfigurationNotFoundException;

public class LdapConfigurationLookup {
    private final List<GluuLdapConfiguration> ldapConfigurations;

    public LdapConfigurationLookup(List<GluuLdapConfiguration> ldapConfigurations) {
        this.ldapConfigurations = ldapConfigurations;
    }

    public boolean shouldEncryptPassword(GluuLdapConfiguration ldapConfiguration) {
        try {
            GluuLdapConfiguration oldConfiguration = this.findByName(ldapConfiguration.getConfigId());
            String encryptedOldPassword = oldConfiguration.getBindPassword();
            return !StringUtils.equals((CharSequence)encryptedOldPassword, (CharSequence)ldapConfiguration.getBindPassword());
        }
        catch (LdapConfigurationNotFoundException e) {
            return true;
        }
    }

    public GluuLdapConfiguration findByName(String name) {
        return (GluuLdapConfiguration)FluentIterable.from(this.ldapConfigurations).filter((Predicate)new LdapConfigurationNamePredicate(name)).first().or(this.notFound(name));
    }

    private Supplier<GluuLdapConfiguration> notFound(final String name) {
        return new Supplier<GluuLdapConfiguration>(){

            public GluuLdapConfiguration get() {
                throw new LdapConfigurationNotFoundException(name);
            }
        };
    }
}

