/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.util;

import org.gluu.config.oxtrust.ShibbolethCASProtocolConfiguration;
import org.gluu.oxtrust.service.CASService;
import org.gluu.oxtrust.util.CASProtocolAvailability;

public class CASProtocolConfiguration {
    private String casBaseURL;
    private ShibbolethCASProtocolConfiguration configuration;

    public CASProtocolConfiguration(String casBaseURL, ShibbolethCASProtocolConfiguration configuration) {
        this.casBaseURL = casBaseURL;
        this.configuration = configuration;
    }

    public String getCasBaseURL() {
        return this.casBaseURL;
    }

    public void setCasBaseURL(String casBaseURL) {
        this.casBaseURL = casBaseURL;
    }

    public ShibbolethCASProtocolConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ShibbolethCASProtocolConfiguration configuration) {
        this.configuration = configuration;
    }

    public void save(CASService casService) throws Exception {
        CASProtocolAvailability casProtocolAvailability = CASProtocolAvailability.get();
        if (!casProtocolAvailability.isAvailable()) {
            throw new Exception();
        }
        if (this.configuration.getInum() == null || this.configuration.getInum().isEmpty()) {
            casService.addCASConfiguration(this.configuration);
        } else {
            casService.updateCASConfiguration(this.configuration);
        }
    }

    public boolean isShibbolethEnabled() {
        return this.configuration.isEnabled();
    }
}

