/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service.uma;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.util.StringHelper;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@ApplicationScoped
public class UmaScopeService
implements Serializable {
    private static final long serialVersionUID = -3537567020929600777L;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private Logger log;

    public void addBranch() {
        String branchDn = this.getDnForScope(null);
        if (!this.persistenceEntryManager.hasBranchesSupport(branchDn)) {
            return;
        }
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("scopes");
        branch.setDn(branchDn);
        this.persistenceEntryManager.persist((Object)branch);
    }

    public boolean containsBranch() {
        String branchDn = this.getDnForScope(null);
        if (!this.persistenceEntryManager.hasBranchesSupport(branchDn)) {
            return true;
        }
        return this.persistenceEntryManager.contains(branchDn, SimpleBranch.class);
    }

    public void prepareScopeDescriptionBranch() {
        if (!this.containsBranch()) {
            this.addBranch();
        }
    }

    public Scope getUmaScopeByDn(String dn) {
        return (Scope)this.persistenceEntryManager.find(Scope.class, (Object)dn);
    }

    public void addUmaScope(Scope scope) {
        this.persistenceEntryManager.persist((Object)scope);
    }

    public void updateUmaScope(Scope scope) {
        this.persistenceEntryManager.merge((Object)scope);
    }

    public void removeUmaScope(Scope scope) {
        this.persistenceEntryManager.remove((Object)scope);
    }

    public boolean containsUmaScope(String dn) {
        return this.persistenceEntryManager.contains(dn, Scope.class);
    }

    public List<Scope> getAllUmaScope(String ... ldapReturnAttributes) {
        List scopes = this.persistenceEntryManager.findEntries(this.getDnForScope(null), Scope.class, null, ldapReturnAttributes);
        return this.filter(scopes);
    }

    public List<Scope> findUmaScopes(String pattern, int sizeLimit) {
        String[] targetArray = new String[]{pattern};
        Filter oxIdFilter = Filter.createSubstringFilter((String)"oxId", null, (String[])targetArray, null);
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{oxIdFilter, displayNameFilter});
        List scopes = this.persistenceEntryManager.findEntries(this.getDnForScope(null), Scope.class, searchFilter, sizeLimit);
        return this.filter(scopes);
    }

    private List<Scope> filter(List<Scope> scopes) {
        if (scopes != null) {
            return scopes.stream().filter(Scope::isUmaType).collect(Collectors.toList());
        }
        return new ArrayList<Scope>();
    }

    public List<Scope> getAllUmaScopes(int sizeLimit) {
        List scopes = this.persistenceEntryManager.findEntries(this.getDnForScope(null), Scope.class, null, sizeLimit);
        return this.filter(scopes);
    }

    public List<Scope> findScope(Scope scopeDescription) {
        List scopes = this.persistenceEntryManager.findEntries((Object)scopeDescription);
        return this.filter(scopes);
    }

    public List<Scope> findUmaScopeById(String id) {
        return this.persistenceEntryManager.findEntries(this.getDnForScope(null), Scope.class, Filter.createEqualityFilter((String)"oxId", (Object)id));
    }

    public String generateInumForNewScope() {
        String newDn = null;
        String newInum = null;
        while (this.containsUmaScope(newDn = this.getDnForScope(newInum = this.generateInumForNewScopeImpl()))) {
        }
        return newInum;
    }

    private String generateInumForNewScopeImpl() {
        return UUID.randomUUID().toString();
    }

    public String getDnForScope(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=scopes,%s", orgDn);
        }
        return String.format("inum=%s,ou=scopes,%s", inum, orgDn);
    }

    public Scope getUmaScopeByInum(String inum) {
        Scope umaScope = null;
        try {
            umaScope = (Scope)this.persistenceEntryManager.find(Scope.class, (Object)this.getDnForScope(inum));
        }
        catch (Exception e) {
            this.log.error("Failed to find scope by Inum " + inum, (Throwable)e);
        }
        return umaScope;
    }

    public Scope getScopeByDn(String Dn) {
        try {
            return (Scope)this.persistenceEntryManager.find(Scope.class, (Object)Dn);
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
            return null;
        }
    }
}

