/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service.uma;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxauth.model.uma.persistence.UmaResource;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.util.StringHelper;

@ApplicationScoped
public class ResourceSetService
implements Serializable {
    private static final long serialVersionUID = -1537567020929600777L;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;

    public void addBranch() {
        String branchDn = this.getDnForResource(null);
        if (!this.persistenceEntryManager.hasBranchesSupport(branchDn)) {
            return;
        }
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("resources");
        branch.setDn(branchDn);
        this.persistenceEntryManager.persist((Object)branch);
    }

    public boolean containsBranch() {
        String branchDn = this.getDnForResource(null);
        if (!this.persistenceEntryManager.hasBranchesSupport(branchDn)) {
            return true;
        }
        return this.persistenceEntryManager.contains(branchDn, SimpleBranch.class);
    }

    public void prepareResourceBranch() {
        if (!this.containsBranch()) {
            this.addBranch();
        }
    }

    public void addResource(UmaResource resource) {
        this.persistenceEntryManager.persist((Object)resource);
    }

    public void updateResource(UmaResource resource) {
        this.persistenceEntryManager.merge((Object)resource);
    }

    public void removeResource(UmaResource resource) {
        this.persistenceEntryManager.remove((Object)resource);
    }

    public boolean containsResource(String dn) {
        return this.persistenceEntryManager.contains(dn, UmaResource.class);
    }

    public List<UmaResource> getAllResources(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForResource(null), UmaResource.class, null, sizeLimit);
    }

    public List<UmaResource> getAllResources(String ... ldapReturnAttributes) {
        return this.persistenceEntryManager.findEntries(this.getDnForResource(null), UmaResource.class, null, ldapReturnAttributes);
    }

    public List<UmaResource> findResources(String pattern, int sizeLimit) {
        String[] targetArray = new String[]{pattern};
        Filter oxIdFilter = Filter.createSubstringFilter((String)"oxId", null, (String[])targetArray, null);
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{oxIdFilter, displayNameFilter});
        List result = this.persistenceEntryManager.findEntries(this.getDnForResource(null), UmaResource.class, searchFilter, sizeLimit);
        return result;
    }

    public List<UmaResource> findResourceSets(UmaResource resource) {
        return this.persistenceEntryManager.findEntries((Object)resource);
    }

    public List<UmaResource> findResourcesById(String id) {
        return this.persistenceEntryManager.findEntries(this.getDnForResource(null), UmaResource.class, Filter.createEqualityFilter((String)"oxId", (Object)id));
    }

    public UmaResource getResourceByDn(String dn) {
        return (UmaResource)this.persistenceEntryManager.find(UmaResource.class, (Object)dn);
    }

    public String generateInumForNewResource() {
        String newDn = null;
        String newInum = null;
        while (this.containsResource(newDn = this.getDnForResource(newInum = this.generateInumForNewResourceImpl()))) {
        }
        return newInum;
    }

    private String generateInumForNewResourceImpl() {
        return UUID.randomUUID().toString();
    }

    public String getDnForResource(String oxId) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)oxId)) {
            return String.format("ou=resources,ou=uma,%s", orgDn);
        }
        return String.format("oxId=%s,ou=resources,ou=uma,%s", oxId, orgDn);
    }

    public List<UmaResource> findResourcesByScope(String scopeId) {
        return this.persistenceEntryManager.findEntries(this.getDnForResource(null), UmaResource.class, Filter.createEqualityFilter((String)"oxAuthUmaScope", (Object)scopeId));
    }
}

