/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service.radius;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.radius.model.RadiusClient;
import org.gluu.search.filter.Filter;
import org.slf4j.Logger;

@ApplicationScoped
public class GluuRadiusClientService
implements Serializable {
    private static final long serialVersionUID = 8095893988896942051L;
    private static final String CLIENT_NAME_ATTR = "oxRadiusClientName";
    private static final String CLIENT_IP_ADDRESS_ATTR = "oxRadiusClientIpAddress";
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private Logger logger;

    public List<RadiusClient> getAllClients() {
        String clientsBaseDn = this.getRadiusClientsBaseDn();
        return this.persistenceEntryManager.findEntries(clientsBaseDn, RadiusClient.class, null);
    }

    public List<RadiusClient> getAllClients(Integer sizeLimit) {
        String clientsBaseDn = this.getRadiusClientsBaseDn();
        return this.persistenceEntryManager.findEntries(clientsBaseDn, RadiusClient.class, null, sizeLimit.intValue());
    }

    public List<RadiusClient> searchClients(String pattern, Integer sizeLimit) {
        String[] targetArray = new String[]{pattern};
        String clientsBaseDn = this.getRadiusClientsBaseDn();
        Filter nameFilter = Filter.createSubstringFilter((String)CLIENT_NAME_ATTR, null, (String[])targetArray, null);
        Filter ipFilter = Filter.createSubstringFilter((String)CLIENT_IP_ADDRESS_ATTR, null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{nameFilter, ipFilter});
        return this.persistenceEntryManager.findEntries(clientsBaseDn, RadiusClient.class, searchFilter, sizeLimit.intValue());
    }

    public RadiusClient getRadiusClientByInum(String inum) {
        RadiusClient client = null;
        try {
            client = (RadiusClient)this.persistenceEntryManager.find(RadiusClient.class, (Object)this.getRadiusClientDn(inum));
        }
        catch (Exception e) {
            this.logger.debug("Could not load radius client", (Throwable)e);
        }
        return client;
    }

    public void addRadiusClient(RadiusClient client) {
        this.persistenceEntryManager.persist((Object)client);
    }

    public void updateRadiusClient(RadiusClient client) {
        this.persistenceEntryManager.merge((Object)client);
    }

    public void deleteRadiusClient(RadiusClient client) {
        this.persistenceEntryManager.remove((Object)client);
    }

    public String getRadiusClientsBaseDn() {
        return String.format("ou=radius_clients,%s", this.organizationService.getDnForOrganization());
    }

    public String getRadiusClientDn(String inum) {
        if (inum == null) {
            return null;
        }
        String orgDn = this.organizationService.getDnForOrganization();
        return String.format("inum=%s,ou=radius_clients,%s", inum, orgDn);
    }

    public String generateInum() {
        String inum = null;
        String dn = null;
        while (this.persistenceEntryManager.contains(dn = this.getRadiusClientDn(inum = this.generateInumInternal()), RadiusClient.class)) {
        }
        return inum;
    }

    public String generateInumInternal() {
        return UUID.randomUUID().toString();
    }
}

