/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxtrust.model.OxTrustedIdp;
import org.gluu.oxtrust.service.IdGenService;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.gluu.service.DataSourceTypeService;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
public class TrustedIDPService
implements Serializable {
    private static final long serialVersionUID = 7622866899884574305L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private IdGenService idGenService;
    @Inject
    private DataSourceTypeService dataSourceTypeService;

    public List<OxTrustedIdp> getAllTrustedIDP() {
        return this.persistenceEntryManager.findEntries(this.getDnForTrustedIDP(null), OxTrustedIdp.class, null);
    }

    public OxTrustedIdp getTrustedIDPByInumCustom(String inum) {
        return (OxTrustedIdp)this.persistenceEntryManager.find(OxTrustedIdp.class, (Object)this.getDnForTrustedIDP(inum));
    }

    public String getDnForTrustedIDP(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=trusted-idp,%s", orgDn);
        }
        return String.format("inum=%s,ou=trusted-idp,%s", inum, orgDn);
    }

    public void addTrustedIDP(OxTrustedIdp oxTrustedIdp) {
        this.persistenceEntryManager.persist((Object)oxTrustedIdp);
    }

    public void removeTrustedIDP(OxTrustedIdp oxTrustedIdp) {
        this.persistenceEntryManager.removeRecursively(oxTrustedIdp.getDn(), OxTrustedIdp.class);
    }

    public OxTrustedIdp getTrustedIDPByInum(String inum, String ... ldapReturnAttributes) {
        OxTrustedIdp result = null;
        try {
            result = (OxTrustedIdp)this.persistenceEntryManager.find((Object)this.getDnForTrustedIDP(inum), OxTrustedIdp.class, ldapReturnAttributes);
        }
        catch (Exception ex) {
            this.log.debug("Failed to load TrustedIDP entry", (Throwable)ex);
        }
        return result;
    }

    public void updateTrustedIDP(OxTrustedIdp oxTrustedIdp) {
        this.persistenceEntryManager.merge((Object)oxTrustedIdp);
    }

    public String generateInumForTrustedIDP() {
        String newInum = null;
        String newDn = null;
        int trycount = 0;
        do {
            if (trycount < 10) {
                newInum = this.idGenService.generateId("TrustedIDP");
                ++trycount;
                continue;
            }
            newInum = this.idGenService.generateDefaultId();
        } while (this.persistenceEntryManager.contains(newDn = this.getDnForTrustedIDP(newInum), OxTrustedIdp.class));
        return newInum;
    }

    public OxTrustedIdp getTrustedIDPByRemoteIdpHost(String remoteIdpHost, String ... returnAttributes) {
        this.log.debug("Getting user information from DB: TrustedIDP = {}", (Object)remoteIdpHost);
        OxTrustedIdp oxTrustedIdp = null;
        if (StringHelper.isEmpty((String)remoteIdpHost)) {
            return null;
        }
        String gluuPassportConfigDn = this.getDnForTrustedIDP(null);
        Filter gluuPassportConfigIdpHostFilter = this.dataSourceTypeService.isSpanner(gluuPassportConfigDn) ? Filter.createEqualityFilter((String)"remoteIdpHost", (Object)StringHelper.toLowerCase((String)remoteIdpHost)) : Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"remoteIdpHost"), (Object)StringHelper.toLowerCase((String)remoteIdpHost));
        List entries = this.persistenceEntryManager.findEntries(gluuPassportConfigDn, OxTrustedIdp.class, gluuPassportConfigIdpHostFilter, returnAttributes);
        this.log.debug("Found {} entries for TrustedIDP = {}", (Object)entries.size(), (Object)remoteIdpHost);
        if (entries.size() > 0) {
            oxTrustedIdp = (OxTrustedIdp)entries.get(0);
        }
        return oxTrustedIdp;
    }
}

