/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class ShibbolethReloadService
implements Serializable {
    private static final String SHIBBOLETH_SERVICE_PREFIX = "shibboleth";
    private static final int HTTP_DEFAULT_MAX_TOTAL_CONNECTIONS = 1000;
    private static final int HTTP_DEFAULT_MAX_CONN_PER_ROUTE = 20;
    private static final String RELYING_PARTY_SERVICE_NAME = "shibboleth.RelyingPartyResolverService";
    private static final String METADATA_RESOLVER_SERVICE_NAME = "shibboleth.MetadataResolverService";
    private static final String ATTRIBUTE_REGISTRY_SERVICE_NAME = "shibboleth.AttributeRegistryService";
    private static final String ATTRIBUTE_RESOLVER_SERVICE_NAME = "shibboleth.AttributeResolverService";
    private static final String ATTRIBUTE_FILTER_SERVICE_NAME = "shibboleth.AttributeFilterService";
    private static final String NAMEID_GENERATION_SERVICE_NAME = "shibboleth.NameIdentifierGenerationService";
    private static final String CN_IDP_HOST = "CN_IDP_HOST";
    @Inject
    private Logger log;
    private HttpClientConnectionManager connectionManager;

    @PostConstruct
    public void create() {
        try {
            this.log.info(">>>>> Initializing ShibbolethReloadService");
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslConnSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnSocketFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
            PoolingHttpClientConnectionManager poolingHttpConnMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            poolingHttpConnMgr.setMaxTotal(1000);
            poolingHttpConnMgr.setDefaultMaxPerRoute(20);
            this.connectionManager = poolingHttpConnMgr;
            this.log.info(">>>> ShibbolethReloadService Initialization complete");
        }
        catch (Exception e) {
            this.connectionManager = null;
            this.log.info("Could not initialize ShibbolethReloadService", (Throwable)e);
        }
    }

    public boolean reloadRelyingPartyService() {
        return this.reloadService(RELYING_PARTY_SERVICE_NAME);
    }

    public boolean reloadMetadataResolverService() {
        return this.reloadService(METADATA_RESOLVER_SERVICE_NAME);
    }

    public boolean reloadAttributeRegistryService() {
        return this.reloadService(ATTRIBUTE_REGISTRY_SERVICE_NAME);
    }

    public boolean reloadAttributeResolverService() {
        return this.reloadService(ATTRIBUTE_RESOLVER_SERVICE_NAME);
    }

    public boolean reloadAttributeFilterService() {
        return this.reloadService(ATTRIBUTE_FILTER_SERVICE_NAME);
    }

    public boolean reloadNameIdGenerationService() {
        return this.reloadService(NAMEID_GENERATION_SERVICE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reloadService(String serviceName) {
        boolean ret = false;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        String urlTemplate = this.getIdpHost().orElse("https://localhost") + "/idp/profile/admin/reload-service?id=%s";
        String url = String.format(urlTemplate, serviceName);
        try {
            HttpGet httpGet = new HttpGet(url);
            httpClient = this.getHttpClient();
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            String responseData = null;
            if (entity != null) {
                responseData = EntityUtils.toString((HttpEntity)entity);
            }
            this.log.debug("Service reload response for url {} is {}", (Object)url, (Object)responseData);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                this.log.debug("Service reload operation for url {} succeeded", (Object)url);
                ret = true;
            } else {
                this.log.debug("Service reload operation for url {} failed", (Object)url);
                ret = false;
            }
        }
        catch (Exception e) {
            this.log.debug("Service reload for url " + url + "failed", (Throwable)e);
            ret = false;
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ret;
    }

    private CloseableHttpClient getHttpClient() {
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        RequestConfig defaultRequestConfig = RequestConfig.custom().setCookieSpec("default").setExpectContinueEnabled(true).build();
        return HttpClients.custom().setConnectionManager(this.connectionManager).setDefaultCookieStore((CookieStore)cookieStore).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultRequestConfig(defaultRequestConfig).build();
    }

    private Optional<String> getIdpHost() {
        return Optional.ofNullable(System.getProperty(CN_IDP_HOST));
    }
}

