/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxtrust.model.OxAuthClient;
import org.gluu.oxtrust.model.OxAuthSectorIdentifier;
import org.gluu.oxtrust.service.ClientService;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
public class SectorIdentifierService
implements Serializable {
    private static final long serialVersionUID = -9167587377957719153L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private ClientService clientService;

    public String getDnForSectorIdentifier(String oxId) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)oxId)) {
            return String.format("ou=sector_identifiers,%s", orgDn);
        }
        return String.format("oxId=%s,ou=sector_identifiers,%s", oxId, orgDn);
    }

    public List<OxAuthSectorIdentifier> searchSectorIdentifiers(String pattern, int sizeLimit) {
        String[] targetArray = new String[]{pattern};
        Filter searchFilter = Filter.createSubstringFilter((String)"oxId", null, (String[])targetArray, null);
        List result = this.persistenceEntryManager.findEntries(this.getDnForSectorIdentifier(null), OxAuthSectorIdentifier.class, searchFilter, sizeLimit);
        return result;
    }

    public List<OxAuthSectorIdentifier> getAllSectorIdentifiers() {
        return this.persistenceEntryManager.findEntries(this.getDnForSectorIdentifier(null), OxAuthSectorIdentifier.class, null);
    }

    public OxAuthSectorIdentifier getSectorIdentifierById(String oxId) {
        try {
            return (OxAuthSectorIdentifier)this.persistenceEntryManager.find(OxAuthSectorIdentifier.class, (Object)this.getDnForSectorIdentifier(oxId));
        }
        catch (Exception e) {
            this.log.warn("Failed to find sector identifier by oxId " + oxId, (Throwable)e);
            return null;
        }
    }

    public String generateIdForNewSectorIdentifier() {
        OxAuthSectorIdentifier sectorIdentifier = new OxAuthSectorIdentifier();
        String newId = null;
        String newDn = null;
        do {
            newId = this.generateIdForNewSectorIdentifierImpl();
            newDn = this.getDnForSectorIdentifier(newId);
            sectorIdentifier.setDn(newDn);
        } while (this.persistenceEntryManager.contains(newDn, OxAuthSectorIdentifier.class));
        return newId;
    }

    private String generateIdForNewSectorIdentifierImpl() {
        return UUID.randomUUID().toString();
    }

    public void addSectorIdentifier(OxAuthSectorIdentifier sectorIdentifier) {
        this.persistenceEntryManager.persist((Object)sectorIdentifier);
    }

    public void updateSectorIdentifier(OxAuthSectorIdentifier sectorIdentifier) {
        this.persistenceEntryManager.merge((Object)sectorIdentifier);
    }

    public void removeSectorIdentifier(OxAuthSectorIdentifier sectorIdentifier) {
        if (sectorIdentifier.getClientIds() != null) {
            List clientDNs = sectorIdentifier.getClientIds();
            for (String clientDN : clientDNs) {
                OxAuthClient client = this.clientService.getClientByDn(clientDN);
                client.setSectorIdentifierUri(null);
                this.clientService.updateClient(client);
            }
        }
        this.persistenceEntryManager.remove((Object)sectorIdentifier);
    }
}

