/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxtrust.model.SamlAcr;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
public class SamlAcrService
implements Serializable {
    private static final long serialVersionUID = 5692082015849025306L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;

    public String getDn(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=samlAcrs,%s", orgDn);
        }
        return String.format("inum=%s,ou=samlAcrs,%s", inum, orgDn);
    }

    public SamlAcr getByInum(String inum) {
        SamlAcr samlAcr = null;
        try {
            samlAcr = (SamlAcr)this.persistenceEntryManager.find(SamlAcr.class, (Object)this.getDn(inum));
        }
        catch (Exception e) {
            this.log.error("Failed to find samlAcr by Inum " + inum, (Throwable)e);
        }
        return samlAcr;
    }

    public void update(SamlAcr samlAcr) {
        this.persistenceEntryManager.merge((Object)samlAcr);
    }

    public void add(SamlAcr samlAcr) {
        this.persistenceEntryManager.persist((Object)samlAcr);
    }

    public void remove(SamlAcr samlAcr) {
        if (samlAcr.getDn() == null) {
            samlAcr.setDn(this.getDn(samlAcr.getInum()));
        }
        this.persistenceEntryManager.remove((Object)samlAcr);
    }

    public SamlAcr[] getAll() {
        return (SamlAcr[])this.persistenceEntryManager.findEntries(this.getDn(null), SamlAcr.class, null).stream().toArray(SamlAcr[]::new);
    }

    public boolean contains(String dn) {
        boolean result = false;
        try {
            result = this.persistenceEntryManager.contains(dn, SamlAcr.class);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String generateInumForSamlAcr() {
        SamlAcr samlAcr = null;
        String newInum = null;
        String newDn = null;
        do {
            newInum = this.generateInumImpl();
            newDn = this.getDn(newInum);
            samlAcr = new SamlAcr();
            samlAcr.setDn(newDn);
        } while (this.persistenceEntryManager.contains(newDn, SamlAcr.class));
        return newInum;
    }

    private String generateInumImpl() {
        return UUID.randomUUID().toString();
    }
}

