/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.velocity.VelocityContext;
import org.gluu.oxtrust.model.GluuSAMLTrustRelationship;
import org.gluu.oxtrust.model.ProfileConfiguration;
import org.gluu.oxtrust.service.Shibboleth3ConfService;
import org.gluu.oxtrust.service.TemplateService;
import org.gluu.service.XmlService;
import org.gluu.util.StringHelper;
import org.gluu.util.io.FileUploadWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@ApplicationScoped
public class ProfileConfigurationService
implements Serializable {
    private static final long serialVersionUID = -4691360522345319673L;
    private static final String SHIBBOLETH_SSO = "ShibbolethSSO";
    private static final String SAML1_ARTIFACT_RESOLUTION = "SAML1ArtifactResolution";
    private static final String SAML1_ATTRIBUTE_QUERY = "SAML1AttributeQuery";
    private static final String SAML2_SSO = "SAML2SSO";
    private static final String SAML2_LOGOUT = "SAML2Logout";
    private static final String SAML2_ARTIFACT_RESOLUTION = "SAML2ArtifactResolution";
    private static final String SAML2_ATTRIBUTE_QUERY = "SAML2AttributeQuery";
    @Inject
    private TemplateService templateService;
    @Inject
    private XmlService xmlService;
    @Inject
    private Shibboleth3ConfService shibboleth3ConfService;

    public List<ProfileConfiguration> getAvailableProfileConfigurations() {
        List<String> templateNames = this.templateService.getTemplateNames("shibboleth3" + File.separator + "idp" + File.separator + "ProfileConfiguration");
        ArrayList<ProfileConfiguration> profileConfigurations = new ArrayList<ProfileConfiguration>();
        for (String templateName : templateNames) {
            if (!templateName.endsWith("ProfileConfiguration.xml.vm")) continue;
            profileConfigurations.add(this.createProfileConfiguration(templateName.split("ProfileConfiguration")[0]));
        }
        return profileConfigurations;
    }

    private ProfileConfiguration createProfileConfiguration(String profileConfigurationName) {
        ProfileConfiguration profileConfiguration = new ProfileConfiguration();
        profileConfiguration.setName(profileConfigurationName);
        if (SHIBBOLETH_SSO.equals(profileConfigurationName)) {
            profileConfiguration.setIncludeAttributeStatement(false);
            profileConfiguration.setAssertionLifetime(300000);
            profileConfiguration.setSignResponses("conditional");
            profileConfiguration.setSignAssertions("never");
            profileConfiguration.setSignRequests("conditional");
        }
        if (SAML1_ARTIFACT_RESOLUTION.equals(profileConfigurationName)) {
            profileConfiguration.setSignResponses("conditional");
            profileConfiguration.setSignAssertions("never");
            profileConfiguration.setSignRequests("conditional");
        }
        if (SAML1_ATTRIBUTE_QUERY.equals(profileConfigurationName)) {
            profileConfiguration.setAssertionLifetime(300000);
            profileConfiguration.setSignResponses("conditional");
            profileConfiguration.setSignAssertions("never");
            profileConfiguration.setSignRequests("conditional");
        }
        if (SAML2_SSO.equals(profileConfigurationName)) {
            profileConfiguration.setIncludeAttributeStatement(true);
            profileConfiguration.setAssertionLifetime(300000);
            profileConfiguration.setAssertionProxyCount(0);
            profileConfiguration.setSignResponses("conditional");
            profileConfiguration.setSignAssertions("never");
            profileConfiguration.setSignRequests("conditional");
            profileConfiguration.setEncryptAssertions("conditional");
            profileConfiguration.setEncryptNameIds("never");
            profileConfiguration.setDefaultAuthenticationMethod("none");
            profileConfiguration.setNameIDFormatPrecedence("none");
        }
        if (SAML2_LOGOUT.equals(profileConfigurationName)) {
            profileConfiguration.setAssertionLifetime(300000);
            profileConfiguration.setSignResponses("conditional");
            profileConfiguration.setSignAssertions("never");
            profileConfiguration.setSignRequests("conditional");
            profileConfiguration.setEncryptAssertions("conditional");
        }
        if (SAML2_ARTIFACT_RESOLUTION.equals(profileConfigurationName)) {
            profileConfiguration.setSignResponses("conditional");
            profileConfiguration.setSignAssertions("never");
            profileConfiguration.setSignRequests("conditional");
            profileConfiguration.setEncryptAssertions("conditional");
            profileConfiguration.setEncryptNameIds("never");
        }
        if (SAML2_ATTRIBUTE_QUERY.equals(profileConfigurationName)) {
            profileConfiguration.setAssertionLifetime(300000);
            profileConfiguration.setAssertionProxyCount(0);
            profileConfiguration.setSignResponses("conditional");
            profileConfiguration.setSignAssertions("never");
            profileConfiguration.setSignRequests("conditional");
            profileConfiguration.setEncryptAssertions("conditional");
            profileConfiguration.setEncryptNameIds("never");
        }
        return profileConfiguration;
    }

    public List<ProfileConfiguration> getProfileConfigurationsList(GluuSAMLTrustRelationship trustRelationship) {
        ArrayList<ProfileConfiguration> profileConfigurations = new ArrayList<ProfileConfiguration>();
        for (String profileConfigurationName : trustRelationship.getProfileConfigurations().keySet()) {
            profileConfigurations.add((ProfileConfiguration)trustRelationship.getProfileConfigurations().get(profileConfigurationName));
        }
        return profileConfigurations;
    }

    public void parseProfileConfigurations(GluuSAMLTrustRelationship trustRelationship) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError, XPathExpressionException {
        if (trustRelationship.getGluuProfileConfiguration() != null) {
            for (String profileConfigurationXML : trustRelationship.getGluuProfileConfiguration()) {
                Node attribute;
                ProfileConfiguration profileConfiguration;
                Document xmlDocument = this.xmlService.getXmlDocument(profileConfigurationXML.getBytes(), true);
                if (xmlDocument.getFirstChild().getAttributes().getNamedItem("xsi:type").getNodeValue().contains(SHIBBOLETH_SSO)) {
                    profileConfiguration = this.createProfileConfiguration(SHIBBOLETH_SSO);
                    profileConfiguration.setIncludeAttributeStatement(Boolean.parseBoolean(xmlDocument.getFirstChild().getAttributes().getNamedItem("includeAttributeStatement").getNodeValue()));
                    profileConfiguration.setAssertionLifetime(Integer.parseInt(xmlDocument.getFirstChild().getAttributes().getNamedItem("assertionLifetime").getNodeValue()));
                    profileConfiguration.setSignResponses(xmlDocument.getFirstChild().getAttributes().getNamedItem("signResponses").getNodeValue());
                    profileConfiguration.setSignAssertions(xmlDocument.getFirstChild().getAttributes().getNamedItem("signAssertions").getNodeValue());
                    profileConfiguration.setSignRequests(xmlDocument.getFirstChild().getAttributes().getNamedItem("signRequests").getNodeValue());
                    attribute = xmlDocument.getFirstChild().getAttributes().getNamedItem("signingCredentialRef");
                    if (attribute != null) {
                        profileConfiguration.setProfileConfigurationCertFileName(attribute.getNodeValue());
                    }
                    trustRelationship.getProfileConfigurations().put(SHIBBOLETH_SSO, profileConfiguration);
                    continue;
                }
                if (xmlDocument.getFirstChild().getAttributes().getNamedItem("xsi:type").getNodeValue().contains(SAML1_ARTIFACT_RESOLUTION)) {
                    profileConfiguration = this.createProfileConfiguration(SAML1_ARTIFACT_RESOLUTION);
                    profileConfiguration.setSignResponses(xmlDocument.getFirstChild().getAttributes().getNamedItem("signResponses").getNodeValue());
                    profileConfiguration.setSignAssertions(xmlDocument.getFirstChild().getAttributes().getNamedItem("signAssertions").getNodeValue());
                    profileConfiguration.setSignRequests(xmlDocument.getFirstChild().getAttributes().getNamedItem("signRequests").getNodeValue());
                    attribute = xmlDocument.getFirstChild().getAttributes().getNamedItem("signingCredentialRef");
                    if (attribute != null) {
                        profileConfiguration.setProfileConfigurationCertFileName(attribute.getNodeValue());
                    }
                    trustRelationship.getProfileConfigurations().put(SAML1_ARTIFACT_RESOLUTION, profileConfiguration);
                    continue;
                }
                if (xmlDocument.getFirstChild().getAttributes().getNamedItem("xsi:type").getNodeValue().contains(SAML1_ATTRIBUTE_QUERY)) {
                    profileConfiguration = this.createProfileConfiguration(SAML1_ATTRIBUTE_QUERY);
                    profileConfiguration.setAssertionLifetime(Integer.parseInt(xmlDocument.getFirstChild().getAttributes().getNamedItem("assertionLifetime").getNodeValue()));
                    profileConfiguration.setSignResponses(xmlDocument.getFirstChild().getAttributes().getNamedItem("signResponses").getNodeValue());
                    profileConfiguration.setSignAssertions(xmlDocument.getFirstChild().getAttributes().getNamedItem("signAssertions").getNodeValue());
                    profileConfiguration.setSignRequests(xmlDocument.getFirstChild().getAttributes().getNamedItem("signRequests").getNodeValue());
                    attribute = xmlDocument.getFirstChild().getAttributes().getNamedItem("signingCredentialRef");
                    if (attribute != null) {
                        profileConfiguration.setProfileConfigurationCertFileName(attribute.getNodeValue());
                    }
                    trustRelationship.getProfileConfigurations().put(SAML1_ATTRIBUTE_QUERY, profileConfiguration);
                    continue;
                }
                if (xmlDocument.getFirstChild().getAttributes().getNamedItem("xsi:type").getNodeValue().contains(SAML2_SSO)) {
                    Node attribute3;
                    Node attribute2;
                    profileConfiguration = this.createProfileConfiguration(SAML2_SSO);
                    profileConfiguration.setIncludeAttributeStatement(Boolean.parseBoolean(xmlDocument.getFirstChild().getAttributes().getNamedItem("includeAttributeStatement").getNodeValue()));
                    profileConfiguration.setAssertionLifetime(Integer.parseInt(xmlDocument.getFirstChild().getAttributes().getNamedItem("assertionLifetime").getNodeValue()));
                    profileConfiguration.setAssertionProxyCount(Integer.parseInt(xmlDocument.getFirstChild().getAttributes().getNamedItem("assertionProxyCount").getNodeValue()));
                    profileConfiguration.setSignResponses(xmlDocument.getFirstChild().getAttributes().getNamedItem("signResponses").getNodeValue());
                    profileConfiguration.setSignAssertions(xmlDocument.getFirstChild().getAttributes().getNamedItem("signAssertions").getNodeValue());
                    profileConfiguration.setSignRequests(xmlDocument.getFirstChild().getAttributes().getNamedItem("signRequests").getNodeValue());
                    profileConfiguration.setEncryptAssertions(xmlDocument.getFirstChild().getAttributes().getNamedItem("encryptAssertions").getNodeValue());
                    profileConfiguration.setEncryptNameIds(xmlDocument.getFirstChild().getAttributes().getNamedItem("encryptNameIds").getNodeValue());
                    attribute = xmlDocument.getFirstChild().getAttributes().getNamedItem("defaultAuthenticationMethod");
                    if (attribute != null) {
                        profileConfiguration.setDefaultAuthenticationMethod(attribute.getNodeValue());
                    }
                    if ((attribute2 = xmlDocument.getFirstChild().getAttributes().getNamedItem("nameIDFormatPrecedence")) != null) {
                        profileConfiguration.setNameIDFormatPrecedence(attribute2.getNodeValue());
                    }
                    if ((attribute3 = xmlDocument.getFirstChild().getAttributes().getNamedItem("signingCredentialRef")) != null) {
                        profileConfiguration.setProfileConfigurationCertFileName(attribute3.getNodeValue());
                    }
                    trustRelationship.getProfileConfigurations().put(SAML2_SSO, profileConfiguration);
                    continue;
                }
                if (xmlDocument.getFirstChild().getAttributes().getNamedItem("xsi:type").getNodeValue().contains(SAML2_LOGOUT)) {
                    profileConfiguration = this.createProfileConfiguration(SAML2_LOGOUT);
                    profileConfiguration.setAssertionLifetime(Integer.parseInt(xmlDocument.getFirstChild().getAttributes().getNamedItem("assertionLifetime").getNodeValue()));
                    profileConfiguration.setSignResponses(xmlDocument.getFirstChild().getAttributes().getNamedItem("signResponses").getNodeValue());
                    profileConfiguration.setSignAssertions(xmlDocument.getFirstChild().getAttributes().getNamedItem("signAssertions").getNodeValue());
                    profileConfiguration.setSignRequests(xmlDocument.getFirstChild().getAttributes().getNamedItem("signRequests").getNodeValue());
                    profileConfiguration.setEncryptAssertions(xmlDocument.getFirstChild().getAttributes().getNamedItem("encryptAssertions").getNodeValue());
                    attribute = xmlDocument.getFirstChild().getAttributes().getNamedItem("signingCredentialRef");
                    if (attribute != null) {
                        profileConfiguration.setProfileConfigurationCertFileName(attribute.getNodeValue());
                    }
                    trustRelationship.getProfileConfigurations().put(SAML2_LOGOUT, profileConfiguration);
                    continue;
                }
                if (xmlDocument.getFirstChild().getAttributes().getNamedItem("xsi:type").getNodeValue().contains(SAML2_ARTIFACT_RESOLUTION)) {
                    profileConfiguration = this.createProfileConfiguration(SAML2_ARTIFACT_RESOLUTION);
                    profileConfiguration.setSignResponses(xmlDocument.getFirstChild().getAttributes().getNamedItem("signResponses").getNodeValue());
                    profileConfiguration.setSignAssertions(xmlDocument.getFirstChild().getAttributes().getNamedItem("signAssertions").getNodeValue());
                    profileConfiguration.setSignRequests(xmlDocument.getFirstChild().getAttributes().getNamedItem("signRequests").getNodeValue());
                    profileConfiguration.setEncryptAssertions(xmlDocument.getFirstChild().getAttributes().getNamedItem("encryptNameIds").getNodeValue());
                    profileConfiguration.setEncryptNameIds(xmlDocument.getFirstChild().getAttributes().getNamedItem("encryptNameIds").getNodeValue());
                    attribute = xmlDocument.getFirstChild().getAttributes().getNamedItem("signingCredentialRef");
                    if (attribute != null) {
                        profileConfiguration.setProfileConfigurationCertFileName(attribute.getNodeValue());
                    }
                    trustRelationship.getProfileConfigurations().put(SAML2_ARTIFACT_RESOLUTION, profileConfiguration);
                    continue;
                }
                if (!xmlDocument.getFirstChild().getAttributes().getNamedItem("xsi:type").getNodeValue().contains(SAML2_ATTRIBUTE_QUERY)) continue;
                profileConfiguration = this.createProfileConfiguration(SAML2_ATTRIBUTE_QUERY);
                profileConfiguration.setAssertionLifetime(Integer.parseInt(xmlDocument.getFirstChild().getAttributes().getNamedItem("assertionLifetime").getNodeValue()));
                profileConfiguration.setAssertionProxyCount(Integer.parseInt(xmlDocument.getFirstChild().getAttributes().getNamedItem("assertionProxyCount").getNodeValue()));
                profileConfiguration.setSignResponses(xmlDocument.getFirstChild().getAttributes().getNamedItem("signResponses").getNodeValue());
                profileConfiguration.setSignAssertions(xmlDocument.getFirstChild().getAttributes().getNamedItem("signAssertions").getNodeValue());
                profileConfiguration.setSignRequests(xmlDocument.getFirstChild().getAttributes().getNamedItem("signRequests").getNodeValue());
                profileConfiguration.setEncryptAssertions(xmlDocument.getFirstChild().getAttributes().getNamedItem("encryptNameIds").getNodeValue());
                profileConfiguration.setEncryptNameIds(xmlDocument.getFirstChild().getAttributes().getNamedItem("encryptNameIds").getNodeValue());
                attribute = xmlDocument.getFirstChild().getAttributes().getNamedItem("signingCredentialRef");
                if (attribute != null) {
                    profileConfiguration.setProfileConfigurationCertFileName(attribute.getNodeValue());
                }
                trustRelationship.getProfileConfigurations().put(SAML2_ATTRIBUTE_QUERY, profileConfiguration);
            }
        }
    }

    public boolean isProfileConfigurationPresent(GluuSAMLTrustRelationship trustRelationship, ProfileConfiguration profileConfiguration) {
        if (trustRelationship.getProfileConfigurations().keySet().contains(profileConfiguration.getName())) {
            ProfileConfiguration storedConfiguration = (ProfileConfiguration)trustRelationship.getProfileConfigurations().get(profileConfiguration.getName());
            return profileConfiguration.equals(storedConfiguration);
        }
        return false;
    }

    public void updateProfileConfiguration(GluuSAMLTrustRelationship trustRelationship, ProfileConfiguration profileConfiguration) {
        trustRelationship.getProfileConfigurations().put(profileConfiguration.getName(), profileConfiguration);
    }

    public void removeProfileConfiguration(GluuSAMLTrustRelationship trustRelationship, ProfileConfiguration profileConfiguration) {
        trustRelationship.getProfileConfigurations().remove(profileConfiguration.getName());
    }

    public void saveProfileConfigurations(GluuSAMLTrustRelationship trustRelationship, Map<String, FileUploadWrapper> fileWrappers) {
        String certName;
        ProfileConfiguration profileConfiguration;
        VelocityContext context = new VelocityContext();
        if (trustRelationship.getProfileConfigurations().get(SHIBBOLETH_SSO) != null) {
            profileConfiguration = (ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SHIBBOLETH_SSO);
            context.put("ShibbolethSSOIncludeAttributeStatement", (Object)profileConfiguration.isIncludeAttributeStatement());
            context.put("ShibbolethSSOAssertionLifetime", (Object)profileConfiguration.getAssertionLifetime());
            context.put("ShibbolethSSOSignResponses", (Object)profileConfiguration.getSignResponses());
            context.put("ShibbolethSSOSignAssertions", (Object)profileConfiguration.getSignAssertions());
            context.put("ShibbolethSSOSignRequests", (Object)profileConfiguration.getSignRequests());
            this.saveCertificate(trustRelationship, fileWrappers, SHIBBOLETH_SSO);
            certName = ((ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SHIBBOLETH_SSO)).getProfileConfigurationCertFileName();
            if (StringHelper.isNotEmpty((String)certName)) {
                context.put("ShibbolethSSOSigningCredentialRef", (Object)certName);
            }
        }
        if (trustRelationship.getProfileConfigurations().get(SAML1_ARTIFACT_RESOLUTION) != null) {
            profileConfiguration = (ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML1_ARTIFACT_RESOLUTION);
            context.put("SAML1ArtifactResolutionSignResponses", (Object)profileConfiguration.getSignResponses());
            context.put("SAML1ArtifactResolutionSignAssertions", (Object)profileConfiguration.getSignAssertions());
            context.put("SAML1ArtifactResolutionSignRequests", (Object)profileConfiguration.getSignRequests());
            this.saveCertificate(trustRelationship, fileWrappers, SAML1_ARTIFACT_RESOLUTION);
            certName = ((ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML1_ARTIFACT_RESOLUTION)).getProfileConfigurationCertFileName();
            if (StringHelper.isNotEmpty((String)certName)) {
                context.put("SAML1ArtifactResolutionSigningCredentialRef", (Object)certName);
            }
        }
        if (trustRelationship.getProfileConfigurations().get(SAML1_ATTRIBUTE_QUERY) != null) {
            profileConfiguration = (ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML1_ATTRIBUTE_QUERY);
            context.put("SAML1AttributeQueryAssertionLifetime", (Object)profileConfiguration.getAssertionLifetime());
            context.put("SAML1AttributeQuerySignResponses", (Object)profileConfiguration.getSignResponses());
            context.put("SAML1AttributeQuerySignAssertions", (Object)profileConfiguration.getSignAssertions());
            context.put("SAML1AttributeQuerySignRequests", (Object)profileConfiguration.getSignRequests());
            this.saveCertificate(trustRelationship, fileWrappers, SAML1_ATTRIBUTE_QUERY);
            certName = ((ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML1_ATTRIBUTE_QUERY)).getProfileConfigurationCertFileName();
            if (StringHelper.isNotEmpty((String)certName)) {
                context.put("SAML1AttributeQuerySigningCredentialRef", (Object)certName);
            }
        }
        if (trustRelationship.getProfileConfigurations().get(SAML2_SSO) != null) {
            profileConfiguration = (ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML2_SSO);
            context.put("SAML2SSOIncludeAttributeStatement", (Object)profileConfiguration.isIncludeAttributeStatement());
            context.put("SAML2SSOAssertionLifetime", (Object)profileConfiguration.getAssertionLifetime());
            context.put("SAML2SSOAssertionProxyCount", (Object)profileConfiguration.getAssertionProxyCount());
            context.put("SAML2SSOSignResponses", (Object)profileConfiguration.getSignResponses());
            context.put("SAML2SSOSignAssertions", (Object)profileConfiguration.getSignAssertions());
            context.put("SAML2SSOSignRequests", (Object)profileConfiguration.getSignRequests());
            context.put("SAML2SSOEncryptNameIds", (Object)profileConfiguration.getEncryptNameIds());
            context.put("SAML2SSOEncryptAssertions", (Object)profileConfiguration.getEncryptAssertions());
            context.put("SAML2SSODefaultAuthenticationMethod", (Object)profileConfiguration.getDefaultAuthenticationMethod());
            context.put("SAML2SSONameIDFormatPrecedence", (Object)profileConfiguration.getNameIDFormatPrecedence());
            this.saveCertificate(trustRelationship, fileWrappers, SAML2_SSO);
            certName = ((ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML2_SSO)).getProfileConfigurationCertFileName();
            if (StringHelper.isNotEmpty((String)certName)) {
                context.put("SAML2SSOSigningCredentialRef", (Object)certName);
            }
        }
        if (trustRelationship.getProfileConfigurations().get(SAML2_LOGOUT) != null) {
            profileConfiguration = (ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML2_LOGOUT);
            context.put("SAML2LogoutAssertionLifetime", (Object)profileConfiguration.getAssertionLifetime());
            context.put("SAML2LogoutSignResponses", (Object)profileConfiguration.getSignResponses());
            context.put("SAML2LogoutSignAssertions", (Object)profileConfiguration.getSignAssertions());
            context.put("SAML2LogoutSignRequests", (Object)profileConfiguration.getSignRequests());
            context.put("SAML2LogoutEncryptAssertions", (Object)profileConfiguration.getEncryptAssertions());
            this.saveCertificate(trustRelationship, fileWrappers, SAML2_LOGOUT);
            certName = ((ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML2_LOGOUT)).getProfileConfigurationCertFileName();
            if (StringHelper.isNotEmpty((String)certName)) {
                context.put("SAML2LogoutSigningCredentialRef", (Object)certName);
            }
        }
        if (trustRelationship.getProfileConfigurations().get(SAML2_ARTIFACT_RESOLUTION) != null) {
            profileConfiguration = (ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML2_ARTIFACT_RESOLUTION);
            context.put("SAML2ArtifactResolutionSignResponses", (Object)profileConfiguration.getSignResponses());
            context.put("SAML2ArtifactResolutionSignAssertions", (Object)profileConfiguration.getSignAssertions());
            context.put("SAML2ArtifactResolutionSignRequests", (Object)profileConfiguration.getSignRequests());
            context.put("SAML2ArtifactResolutionEncryptAssertions", (Object)profileConfiguration.getEncryptAssertions());
            context.put("SAML2ArtifactResolutionEncryptNameIds", (Object)profileConfiguration.getEncryptNameIds());
            this.saveCertificate(trustRelationship, fileWrappers, SAML2_ARTIFACT_RESOLUTION);
            certName = ((ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML2_ARTIFACT_RESOLUTION)).getProfileConfigurationCertFileName();
            if (StringHelper.isNotEmpty((String)certName)) {
                context.put("SAML2ArtifactResolutionSigningCredentialRef", (Object)certName);
            }
        }
        if (trustRelationship.getProfileConfigurations().get(SAML2_ATTRIBUTE_QUERY) != null) {
            profileConfiguration = (ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML2_ATTRIBUTE_QUERY);
            context.put("SAML2AttributeQueryAssertionLifetime", (Object)profileConfiguration.getAssertionLifetime());
            context.put("SAML2AttributeQueryAssertionProxyCount", (Object)profileConfiguration.getAssertionProxyCount());
            context.put("SAML2AttributeQuerySignResponses", (Object)profileConfiguration.getSignResponses());
            context.put("SAML2AttributeQuerySignAssertions", (Object)profileConfiguration.getSignAssertions());
            context.put("SAML2AttributeQuerySignRequests", (Object)profileConfiguration.getSignRequests());
            context.put("SAML2AttributeQueryEncryptAssertions", (Object)profileConfiguration.getEncryptAssertions());
            context.put("SAML2AttributeQueryEncryptNameIds", (Object)profileConfiguration.getEncryptNameIds());
            this.saveCertificate(trustRelationship, fileWrappers, SAML2_ATTRIBUTE_QUERY);
            certName = ((ProfileConfiguration)trustRelationship.getProfileConfigurations().get(SAML2_ATTRIBUTE_QUERY)).getProfileConfigurationCertFileName();
            if (StringHelper.isNotEmpty((String)certName)) {
                context.put("SAML2AttributeQuerySigningCredentialRef", (Object)certName);
            }
        }
        if (!trustRelationship.getProfileConfigurations().isEmpty()) {
            trustRelationship.setGluuProfileConfiguration(new ArrayList());
            for (String profileConfigurationName : trustRelationship.getProfileConfigurations().keySet()) {
                trustRelationship.getGluuProfileConfiguration().add(this.templateService.generateConfFile(profileConfigurationName + "ProfileConfiguration.xml", context));
            }
        } else {
            trustRelationship.setGluuProfileConfiguration(null);
        }
    }

    private void saveCertificate(GluuSAMLTrustRelationship trustRelationship, Map<String, FileUploadWrapper> fileWrappers, String name) {
        if (fileWrappers.get(name) != null && fileWrappers.get(name).getStream() != null) {
            String profileConfigurationCertFileName = StringHelper.removePunctuation((String)(name + trustRelationship.getInum()));
            this.shibboleth3ConfService.saveProfileConfigurationCert(profileConfigurationCertFileName, fileWrappers.get(name).getStream());
            ((ProfileConfiguration)trustRelationship.getProfileConfigurations().get(name)).setProfileConfigurationCertFileName(StringHelper.removePunctuation((String)profileConfigurationCertFileName));
        }
    }
}

