/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.model.GluuAttribute;
import org.gluu.oxauth.model.common.IdType;
import org.gluu.oxtrust.exception.DuplicateEmailException;
import org.gluu.oxtrust.model.GluuCustomAttribute;
import org.gluu.oxtrust.model.GluuCustomPerson;
import org.gluu.oxtrust.model.SimplePerson;
import org.gluu.oxtrust.model.User;
import org.gluu.oxtrust.service.AttributeService;
import org.gluu.oxtrust.service.IPersonService;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.oxtrust.service.external.ExternalIdGeneratorService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.operation.DuplicateEntryException;
import org.gluu.persist.model.AttributeData;
import org.gluu.persist.model.PagedResult;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.service.DataSourceTypeService;
import org.gluu.util.ArrayHelper;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
public class PersonService
implements Serializable,
IPersonService {
    private static final long serialVersionUID = 6685720517520443399L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private DataSourceTypeService dataSourceTypeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private ExternalIdGeneratorService idGeneratorService;
    private List<GluuCustomAttribute> mandatoryAttributes;

    @Override
    public void addCustomObjectClass(GluuCustomPerson person) {
        String customObjectClass = this.attributeService.getCustomOrigin();
        Object[] customObjectClassesArray = person.getCustomObjectClasses();
        if (ArrayHelper.isNotEmpty((Object[])customObjectClassesArray)) {
            List<Object> customObjectClassesList = Arrays.asList(customObjectClassesArray);
            if (!customObjectClassesList.contains(customObjectClass)) {
                ArrayList<Object> customObjectClassesListUpdated = new ArrayList<Object>();
                customObjectClassesListUpdated.addAll(customObjectClassesList);
                customObjectClassesListUpdated.add(customObjectClass);
                customObjectClassesList = customObjectClassesListUpdated;
            }
            person.setCustomObjectClasses(customObjectClassesList.toArray(new String[0]));
        } else {
            person.setCustomObjectClasses(new String[]{customObjectClass});
        }
    }

    @Override
    public void addPerson(GluuCustomPerson person) throws Exception {
        try {
            List<GluuCustomPerson> persons = this.getPersonsByUid(person.getUid(), new String[0]);
            if (persons != null && persons.size() != 0) {
                throw new DuplicateEntryException("Duplicate UID value: " + person.getUid());
            }
            this.addPersonWithoutCheck(person);
        }
        catch (Exception e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Failed to add person entry!", (Throwable)e);
            }
            if (e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().contains("unique attribute conflict was detected for attribute mail")) {
                throw new DuplicateEmailException("Email Already Registered");
            }
            throw new DuplicateEmailException("Duplicate UID value: " + person.getUid());
        }
    }

    public void addPersonWithoutCheck(GluuCustomPerson person) {
        person.setCreationDate(new Date());
        this.persistenceEntryManager.persist((Object)person);
    }

    @Override
    public void updatePerson(GluuCustomPerson person) throws Exception {
        try {
            this.updatePersonWithoutCheck(person);
        }
        catch (Exception e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Failed to add person entry!", (Throwable)e);
            }
            if (e.getCause().getMessage().contains("unique attribute conflict was detected for attribute mail")) {
                throw new DuplicateEmailException("Email Already Registered");
            }
            throw new Exception("Duplicate UID value: " + person.getUid(), e);
        }
    }

    public void updatePersonWithoutCheck(GluuCustomPerson person) {
        Date updateDate = new Date();
        person.setUpdatedAt(updateDate);
        if (person.getAttribute("oxTrustMetaLastModified") != null) {
            person.setAttribute("oxTrustMetaLastModified", Instant.ofEpochMilli(updateDate.getTime()).toString());
        }
        this.persistenceEntryManager.merge((Object)person);
    }

    @Override
    public void removePerson(GluuCustomPerson person) {
        this.persistenceEntryManager.removeRecursively(person.getDn(), GluuCustomPerson.class);
    }

    @Override
    public List<GluuCustomPerson> searchPersons(String pattern, int sizeLimit) {
        Filter searchFilter = this.buildFilter(pattern);
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), GluuCustomPerson.class, searchFilter, sizeLimit);
    }

    @Override
    public List<GluuCustomPerson> searchPersons(String pattern) {
        Filter searchFilter = this.buildFilter(pattern);
        String[] attributes = new String[]{"inum", "uid", "displayName", "mail", "gluuStatus"};
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), GluuCustomPerson.class, searchFilter, attributes);
    }

    private Filter buildFilter(String pattern) {
        String[] targetArray = new String[]{pattern};
        Filter uidFilter = Filter.createSubstringFilter((String)"uid", null, (String[])targetArray, null);
        Filter mailFilter = Filter.createSubstringFilter((String)"mail", null, (String[])targetArray, null);
        Filter nameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter ppidFilter = Filter.createSubstringFilter((String)"oxPPID", null, (String[])targetArray, null);
        Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
        Filter snFilter = Filter.createSubstringFilter((String)"sn", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{uidFilter, mailFilter, nameFilter, snFilter, inumFilter, ppidFilter});
        return searchFilter;
    }

    private Filter buildFilterForList(String pattern) {
        String[] targetArray = new String[]{pattern};
        Filter uidFilter = Filter.createSubstringFilter((String)"uid", null, (String[])targetArray, null);
        Filter mailFilter = Filter.createSubstringFilter((String)"mail", null, (String[])targetArray, null);
        Filter nameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter snFilter = Filter.createSubstringFilter((String)"sn", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{uidFilter, mailFilter, nameFilter, snFilter});
        return searchFilter;
    }

    @Override
    public List<GluuCustomPerson> findPersons(GluuCustomPerson person, int sizeLimit) {
        person.setBaseDn(this.getDnForPerson(null));
        return this.persistenceEntryManager.findEntries((Object)person, sizeLimit);
    }

    @Override
    public List<GluuCustomPerson> searchPersons(String pattern, int sizeLimit, List<GluuCustomPerson> excludedPersons) throws Exception {
        Filter orFilter;
        Filter searchFilter = orFilter = this.buildFilter(pattern);
        if (excludedPersons != null && excludedPersons.size() > 0) {
            ArrayList<Filter> excludeFilters = new ArrayList<Filter>();
            for (GluuCustomPerson excludedPerson : excludedPersons) {
                Filter eqFilter = Filter.createEqualityFilter((String)"uid", (Object)excludedPerson.getUid());
                excludeFilters.add(eqFilter);
            }
            Filter orExcludeFilter = null;
            orExcludeFilter = excludedPersons.size() == 1 ? (Filter)excludeFilters.get(0) : Filter.createORFilter(excludeFilters);
            Filter notFilter = Filter.createNOTFilter((Filter)orExcludeFilter);
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{orFilter, notFilter});
        }
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), GluuCustomPerson.class, searchFilter, sizeLimit);
    }

    @Override
    public List<GluuCustomPerson> findAllPersons(String[] returnAttributes) {
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), GluuCustomPerson.class, null, returnAttributes);
    }

    public PagedResult<GluuCustomPerson> findPeople(String pattern, int start, int count) {
        Filter filter = this.buildFilterForList(pattern);
        String[] attributes = new String[]{"inum", "uid", "displayName", "mail", "gluuStatus"};
        return this.persistenceEntryManager.findPagedEntries(this.getDnForPerson(null), GluuCustomPerson.class, filter, attributes, null, null, start, count, count);
    }

    @Override
    public List<GluuCustomPerson> findPersonsByUids(List<String> uids, String[] returnAttributes) throws Exception {
        ArrayList<Filter> uidFilters = new ArrayList<Filter>();
        for (String uid : uids) {
            uidFilters.add(Filter.createEqualityFilter((String)"uid", (Object)uid));
        }
        Filter filter = Filter.createORFilter(uidFilters);
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), GluuCustomPerson.class, filter, returnAttributes);
    }

    @Override
    public List<GluuCustomPerson> findPersonsByMailids(List<String> mailids, String[] returnAttributes) throws Exception {
        ArrayList<Filter> mailidFilters = new ArrayList<Filter>();
        for (String mailid : mailids) {
            mailidFilters.add(Filter.createEqualityFilter((String)"mail", (Object)mailid));
        }
        Filter filter = Filter.createORFilter(mailidFilters);
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), GluuCustomPerson.class, filter, returnAttributes);
    }

    @Override
    public GluuCustomPerson findPersonByDn(String dn, String ... returnAttributes) {
        return (GluuCustomPerson)this.persistenceEntryManager.find((Object)dn, GluuCustomPerson.class, returnAttributes);
    }

    @Override
    public boolean containsPerson(GluuCustomPerson person) {
        boolean result = false;
        try {
            result = this.persistenceEntryManager.contains(GluuCustomPerson.class);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean contains(String dn) {
        return this.persistenceEntryManager.contains(dn, GluuCustomPerson.class);
    }

    @Override
    public GluuCustomPerson getPersonByDn(String dn) {
        GluuCustomPerson result = (GluuCustomPerson)this.persistenceEntryManager.find(GluuCustomPerson.class, (Object)dn);
        return result;
    }

    @Override
    public GluuCustomPerson getPersonByInum(String inum) {
        GluuCustomPerson person = null;
        try {
            person = (GluuCustomPerson)this.persistenceEntryManager.find(GluuCustomPerson.class, (Object)this.getDnForPerson(inum));
        }
        catch (Exception e) {
            this.log.error("Failed to find Person by Inum " + inum, (Throwable)e);
        }
        return person;
    }

    @Override
    public GluuCustomPerson getPersonByUid(String uid, String ... returnAttributes) {
        List<GluuCustomPerson> entries = this.getPersonsByUid(uid, returnAttributes);
        if (entries.size() > 0) {
            return entries.get(0);
        }
        return null;
    }

    @Override
    public int countPersons() {
        String dn = this.getDnForPerson(null);
        Class<GluuCustomPerson> searchClass = GluuCustomPerson.class;
        if (this.persistenceEntryManager.hasBranchesSupport(dn)) {
            searchClass = SimpleBranch.class;
        }
        return this.persistenceEntryManager.countEntries(dn, searchClass, null, SearchScope.BASE);
    }

    @Override
    public String generateInumForNewPerson() {
        GluuCustomPerson person = null;
        String newInum = null;
        String newDn = null;
        do {
            newInum = this.generateInumForNewPersonImpl();
            newDn = this.getDnForPerson(newInum);
            person = new GluuCustomPerson();
            person.setDn(newDn);
        } while (this.persistenceEntryManager.contains(newDn, GluuCustomPerson.class));
        return newInum;
    }

    private String generateInumForNewPersonImpl() {
        String id = null;
        if (this.idGeneratorService.isEnabled()) {
            id = this.idGeneratorService.executeExternalGenerateIdMethod(this.idGeneratorService.getCustomScriptConfigurations().stream().findFirst().orElse(null), "", IdType.PEOPLE.getType(), "");
        }
        return id == null ? UUID.randomUUID().toString() : id;
    }

    @Override
    public String getDnForPerson(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=people,%s", orgDn);
        }
        return String.format("inum=%s,ou=people,%s", inum, orgDn);
    }

    @Override
    public boolean authenticate(String userName, String password) {
        return this.persistenceEntryManager.authenticate(userName, GluuCustomPerson.class, password);
    }

    @Override
    public List<GluuCustomAttribute> getMandatoryAtributes() {
        if (this.mandatoryAttributes == null) {
            this.mandatoryAttributes = new ArrayList<GluuCustomAttribute>();
            this.mandatoryAttributes.add(new GluuCustomAttribute("uid", (Object)"", true, true));
            this.mandatoryAttributes.add(new GluuCustomAttribute("givenName", (Object)"", true, true));
            this.mandatoryAttributes.add(new GluuCustomAttribute("displayName", (Object)"", true, true));
            this.mandatoryAttributes.add(new GluuCustomAttribute("sn", (Object)"", true, true));
            this.mandatoryAttributes.add(new GluuCustomAttribute("mail", (Object)"", true, true));
            this.mandatoryAttributes.add(new GluuCustomAttribute("userPassword", (Object)"", true, true));
            this.mandatoryAttributes.add(new GluuCustomAttribute("gluuStatus", (Object)"", true, true));
        }
        return this.mandatoryAttributes;
    }

    @Override
    public String getPersonUids(List<GluuCustomPerson> persons) throws Exception {
        StringBuilder sb = new StringBuilder();
        Iterator<GluuCustomPerson> iterator = persons.iterator();
        while (iterator.hasNext()) {
            GluuCustomPerson call = iterator.next();
            sb.append('\'').append(call.getUid()).append('\'');
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public String getPersonMailids(List<GluuCustomPerson> persons) throws Exception {
        StringBuilder sb = new StringBuilder();
        Iterator<GluuCustomPerson> iterator = persons.iterator();
        while (iterator.hasNext()) {
            GluuCustomPerson call = iterator.next();
            sb.append('\'').append(call.getMail()).append('\'');
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public List<GluuCustomPerson> createEntities(Map<String, List<AttributeData>> entriesAttributes) throws Exception {
        return this.persistenceEntryManager.createEntities(GluuCustomPerson.class, entriesAttributes);
    }

    @Override
    public GluuCustomPerson getPersonByEmail(String mail, String ... returnAttributes) {
        List<GluuCustomPerson> persons = this.getPersonsByEmail(mail, returnAttributes);
        if (persons != null && persons.size() > 0) {
            return persons.get(0);
        }
        return null;
    }

    @Override
    public List<GluuCustomPerson> getPersonsByUid(String uid, String ... returnAttributes) {
        this.log.debug("Getting user information from DB: userId = {}", (Object)uid);
        if (StringHelper.isEmpty((String)uid)) {
            return null;
        }
        String personDn = this.getDnForPerson(null);
        Filter userUidFilter = this.dataSourceTypeService.isSpanner(personDn) ? Filter.createEqualityFilter((String)"uid", (Object)StringHelper.toLowerCase((String)uid)) : Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)StringHelper.toLowerCase((String)uid));
        List entries = this.persistenceEntryManager.findEntries(personDn, GluuCustomPerson.class, userUidFilter, returnAttributes);
        this.log.debug("Found {} entries for userId = {}", (Object)entries.size(), (Object)uid);
        return entries;
    }

    @Override
    public List<GluuCustomPerson> getPersonsByEmail(String mail, String ... returnAttributes) {
        this.log.debug("Getting user information from DB: mail = {}", (Object)mail);
        if (StringHelper.isEmpty((String)mail)) {
            return null;
        }
        String personDn = this.getDnForPerson(null);
        Filter userMailFilter = this.dataSourceTypeService.isSpanner(personDn) ? Filter.createEqualityFilter((String)"mail", (Object)StringHelper.toLowerCase((String)mail)) : Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"mail"), (Object)StringHelper.toLowerCase((String)mail));
        boolean multiValued = false;
        GluuAttribute mailAttribute = this.attributeService.getAttributeByName("mail");
        if (mailAttribute != null && mailAttribute.getOxMultiValuedAttribute() != null && mailAttribute.getOxMultiValuedAttribute().booleanValue()) {
            multiValued = true;
        }
        userMailFilter.multiValued(Boolean.valueOf(multiValued));
        List entries = this.persistenceEntryManager.findEntries(personDn, GluuCustomPerson.class, userMailFilter, returnAttributes);
        this.log.debug("Found {} entries for mail = {}", (Object)entries.size(), (Object)mail);
        return entries;
    }

    @Override
    public GluuCustomPerson getPersonByAttribute(String attribute, String value) throws Exception {
        GluuCustomPerson person = new GluuCustomPerson();
        person.setBaseDn(this.getDnForPerson(null));
        person.setAttribute(attribute, value);
        List persons = this.persistenceEntryManager.findEntries((Object)person);
        if (persons != null && persons.size() > 0) {
            return (GluuCustomPerson)persons.get(0);
        }
        return null;
    }

    @Override
    public User getUserByUid(String uid) {
        String personDn;
        Filter userUidFilter = this.dataSourceTypeService.isSpanner(personDn = this.getDnForPerson(null)) ? Filter.createEqualityFilter((String)"uid", (Object)StringHelper.toLowerCase((String)uid)) : Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)StringHelper.toLowerCase((String)uid));
        List users = this.persistenceEntryManager.findEntries(personDn, SimplePerson.class, userUidFilter, 1);
        if (users != null && users.size() > 0) {
            return (User)this.persistenceEntryManager.find(User.class, (Object)((SimplePerson)((Object)users.get(0))).getDn());
        }
        return null;
    }

    @Override
    public List<GluuCustomPerson> getPersonsByAttribute(String attribute, String value) throws Exception {
        GluuCustomPerson person = new GluuCustomPerson();
        person.setBaseDn(this.getDnForPerson(null));
        person.setAttribute(attribute, value);
        List persons = this.persistenceEntryManager.findEntries((Object)person);
        if (persons != null && persons.size() > 0) {
            return persons;
        }
        return null;
    }
}

