/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.config.oxtrust.AppConfiguration;
import org.gluu.config.oxtrust.LdapOxAuthConfiguration;
import org.gluu.model.ApplicationType;
import org.gluu.model.GluuStatus;
import org.gluu.model.ProgrammingLanguage;
import org.gluu.oxtrust.model.GluuBoolean;
import org.gluu.oxtrust.model.GluuOrganization;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.BasePersistenceException;
import org.gluu.service.BaseCacheService;
import org.gluu.service.CacheService;
import org.gluu.service.LocalCacheService;
import org.gluu.util.ArrayHelper;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
@Priority(value=5)
@Named(value="organizationService")
public class OrganizationService
extends org.gluu.service.OrganizationService {
    private static final long serialVersionUID = -1959146007518514678L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private CacheService cacheService;
    @Inject
    private LocalCacheService localCacheService;
    @Inject
    private AppConfiguration appConfiguration;

    public void updateOrganization(GluuOrganization organization) {
        this.persistenceEntryManager.merge((Object)organization);
    }

    public boolean containsOrganization(String dn) {
        return this.persistenceEntryManager.contains(dn, GluuOrganization.class);
    }

    public GluuOrganization getOrganization() {
        BaseCacheService usedCacheService = this.getCacheService();
        return (GluuOrganization)usedCacheService.getWithPut("organization_" + this.getApplicationType(), () -> (GluuOrganization)this.persistenceEntryManager.find(GluuOrganization.class, (Object)this.getDnForOrganization()), 60);
    }

    public String getOrgName() {
        return this.getOrganization().getDisplayName();
    }

    public String getDnForOrganization() {
        return this.getDnForOrganization(this.appConfiguration.getBaseDN());
    }

    public String getOrganizationCustomMessage(String customMessageId) {
        BaseCacheService usedCacheService = this.getCacheService();
        GluuOrganization organization = this.getOrganization();
        String key = "organizationCustomMessage";
        HashMap<String, String> organizationCustomMessage = (HashMap<String, String>)usedCacheService.get(key);
        if (organizationCustomMessage == null) {
            organizationCustomMessage = new HashMap<String, String>();
            Object[] customMessages = organization.getCustomMessages();
            if (ArrayHelper.isNotEmpty((Object[])customMessages)) {
                for (Object customMessage : customMessages) {
                    int idx = ((String)customMessage).indexOf(58);
                    if (idx <= 0 || idx + 1 >= ((String)customMessage).length()) continue;
                    String msgKey = ((String)customMessage).substring(0, idx).trim();
                    String msgValue = ((String)customMessage).substring(idx + 1).trim();
                    if (!StringHelper.isNotEmpty((String)msgKey) || !StringHelper.isNotEmpty((String)msgValue)) continue;
                    organizationCustomMessage.put(msgKey, msgValue);
                }
            }
            usedCacheService.put(key, organizationCustomMessage);
        }
        return (String)organizationCustomMessage.get(customMessageId);
    }

    public String[] buildOrganizationCustomMessages(String[][] customMessages) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object[] objectArray : customMessages) {
            if (ArrayHelper.isEmpty((Object[])objectArray) || objectArray.length != 2) continue;
            Object msgKey = objectArray[0];
            Object msgValue = objectArray[1];
            if (!StringHelper.isNotEmpty((String)msgKey) || !StringHelper.isNotEmpty((String)msgValue)) continue;
            result.add((String)msgKey + ": " + (String)msgValue);
        }
        return result.toArray(new String[0]);
    }

    public String getBaseDn() {
        return this.appConfiguration.getBaseDN();
    }

    public boolean isAllowPersonModification() {
        return this.appConfiguration.isAllowPersonModification();
    }

    public GluuBoolean[] getBooleanSelectionTypes() {
        return new GluuBoolean[]{GluuBoolean.DISABLED, GluuBoolean.ENABLED};
    }

    public GluuBoolean[] getJavaBooleanSelectionTypes() {
        return new GluuBoolean[]{GluuBoolean.TRUE, GluuBoolean.FALSE};
    }

    public GluuStatus[] getActiveInactiveStatuses() {
        return new GluuStatus[]{GluuStatus.ACTIVE, GluuStatus.INACTIVE};
    }

    public ProgrammingLanguage[] getProgrammingLanguageTypes() {
        return new ProgrammingLanguage[]{ProgrammingLanguage.PYTHON, ProgrammingLanguage.JAVA_SCRIPT};
    }

    public LdapOxAuthConfiguration getOxAuthSetting(String configurationDn) {
        LdapOxAuthConfiguration ldapOxAuthConfiguration = null;
        try {
            configurationDn = configurationDn.replace("ou=oxtrust", "ou=oxauth");
            ldapOxAuthConfiguration = (LdapOxAuthConfiguration)this.persistenceEntryManager.find(LdapOxAuthConfiguration.class, (Object)configurationDn);
            return ldapOxAuthConfiguration;
        }
        catch (BasePersistenceException ex) {
            this.log.error("Failed to load configuration from LDAP");
            return null;
        }
    }

    public void saveLdapOxAuthConfiguration(LdapOxAuthConfiguration ldapOxAuthConfiguration) {
        this.persistenceEntryManager.merge((Object)ldapOxAuthConfiguration);
    }

    private BaseCacheService getCacheService() {
        if (this.appConfiguration.getUseLocalCache().booleanValue()) {
            return this.localCacheService;
        }
        return this.cacheService;
    }

    public ApplicationType getApplicationType() {
        return ApplicationType.OX_TRUST;
    }
}

