/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxtrust.model.GluuCustomPerson;
import org.gluu.oxtrust.model.GluuFido2Device;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.search.filter.Filter;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
public class Fido2DeviceService
implements Serializable {
    private static final long serialVersionUID = 5874835162873627676L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private OrganizationService organizationService;

    public boolean removeFido2(GluuCustomPerson person, String deviceID) {
        try {
            String finalDn = String.format("oxId=%s,ou=fido2_register,", deviceID);
            finalDn = finalDn.concat(person.getDn());
            this.ldapEntryManager.removeRecursively(finalDn, GluuCustomPerson.class);
            return true;
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return false;
        }
    }

    public String getDnForFido2Device(String oxid, String personInum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (!StringHelper.isEmpty((String)personInum) && StringHelper.isEmpty((String)oxid)) {
            return String.format("ou=fido2_register,inum=%s,ou=people,%s", personInum, orgDn);
        }
        if (!StringHelper.isEmpty((String)oxid) && !StringHelper.isEmpty((String)personInum)) {
            return String.format("oxId=%s,ou=fido2_register,inum=%s,ou=people,%s", oxid, personInum, orgDn);
        }
        return String.format("ou=people,%s", orgDn);
    }

    public List<GluuFido2Device> findAllFido2Devices(GluuCustomPerson person) {
        try {
            String baseDnForU2fDevices = this.getDnForFido2Device(null, person.getInum());
            Filter inumFilter = Filter.createEqualityFilter((String)"personInum", (Object)person.getInum());
            return this.ldapEntryManager.findEntries(baseDnForU2fDevices, GluuFido2Device.class, inumFilter);
        }
        catch (EntryPersistenceException e) {
            this.log.warn("No fido2 devices enrolled for " + person.getDisplayName());
            return new ArrayList<GluuFido2Device>();
        }
    }

    public GluuFido2Device getFido2DeviceById(String userId, String id) {
        GluuFido2Device f2d = null;
        try {
            String dn = this.getDnForFido2Device(id, userId);
            if (StringUtils.isNotEmpty((String)userId)) {
                f2d = (GluuFido2Device)this.ldapEntryManager.find(GluuFido2Device.class, (Object)dn);
            } else {
                Filter filter = Filter.createEqualityFilter((String)"oxId", (Object)id);
                f2d = (GluuFido2Device)this.ldapEntryManager.findEntries(dn, GluuFido2Device.class, filter).get(0);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to find Fido 2 device with id " + id, (Throwable)e);
        }
        return f2d;
    }

    public void updateFido2Device(GluuFido2Device fido2Device) {
        this.ldapEntryManager.merge((Object)fido2Device);
    }

    public void removeFido2Device(GluuFido2Device fido2Device) {
        this.ldapEntryManager.removeRecursively(fido2Device.getDn(), GluuFido2Device.class);
    }

    public GluuFido2Device getGluuCustomFidoDeviceById(String id, String userId) {
        GluuFido2Device gluuCustomFidoDevice = null;
        try {
            String dn = this.getDnForFido2Device(id, userId);
            if (StringUtils.isNotEmpty((String)userId)) {
                gluuCustomFidoDevice = (GluuFido2Device)this.ldapEntryManager.find(GluuFido2Device.class, (Object)dn);
            } else {
                Filter filter = Filter.createEqualityFilter((String)"oxId", (Object)id);
                gluuCustomFidoDevice = (GluuFido2Device)this.ldapEntryManager.findEntries(dn, GluuFido2Device.class, filter).get(0);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to find device by id " + id, (Throwable)e);
        }
        return gluuCustomFidoDevice;
    }
}

