/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.model.ApplicationType;
import org.gluu.model.AuthenticationScriptUsageType;
import org.gluu.model.ProgrammingLanguage;
import org.gluu.model.ScriptLocationType;
import org.gluu.model.SmtpConfiguration;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.oxtrust.model.GluuConfiguration;
import org.gluu.oxtrust.model.GluuOxTrustStat;
import org.gluu.oxtrust.service.EncryptionService;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.service.metric.MetricService;
import org.gluu.util.StringHelper;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="configurationService")
public class ConfigurationService
implements Serializable {
    private static final long serialVersionUID = 8842838732456296435L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private EncryptionService encryptionService;
    @Inject
    private MetricService metricService;
    private static final SimpleDateFormat PERIOD_DATE_FORMAT = new SimpleDateFormat("yyyyMM");
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public boolean contains(String configurationDn) {
        return this.persistenceEntryManager.contains(configurationDn, GluuConfiguration.class);
    }

    public void addConfiguration(GluuConfiguration configuration) {
        this.persistenceEntryManager.persist((Object)configuration);
    }

    public void updateConfiguration(GluuConfiguration configuration) {
        try {
            this.persistenceEntryManager.merge((Object)configuration);
        }
        catch (Exception e) {
            this.log.info("", (Throwable)e);
        }
    }

    public void updateOxtrustStat(GluuOxTrustStat oxTrustStat) {
        try {
            this.persistenceEntryManager.merge((Object)oxTrustStat);
        }
        catch (Exception e) {
            this.log.info("", (Throwable)e);
        }
    }

    public boolean containsConfiguration(String dn) {
        return this.persistenceEntryManager.contains(dn, GluuConfiguration.class);
    }

    public GluuConfiguration getConfigurationByInum(String inum) {
        return (GluuConfiguration)this.persistenceEntryManager.find(GluuConfiguration.class, (Object)this.getDnForConfiguration());
    }

    public GluuConfiguration getConfiguration(String[] returnAttributes) {
        GluuConfiguration result = null;
        result = (GluuConfiguration)this.persistenceEntryManager.find((Object)this.getDnForConfiguration(), GluuConfiguration.class, returnAttributes);
        return result;
    }

    public GluuOxTrustStat getOxtrustStat(String[] returnAttributes) {
        Date statDate = new Date();
        String statDn = this.metricService.buildDn(LocalDateTime.now().format(this.formatter), statDate, ApplicationType.OX_TRUST);
        GluuOxTrustStat result = new GluuOxTrustStat();
        if (this.persistenceEntryManager.contains(statDn, GluuOxTrustStat.class)) {
            result = (GluuOxTrustStat)this.persistenceEntryManager.find((Object)statDn, GluuOxTrustStat.class, returnAttributes);
        } else {
            result.setDn(statDn);
            this.metricService.prepareBranch(statDate, ApplicationType.OX_TRUST);
            this.persistenceEntryManager.persist((Object)result);
        }
        return result;
    }

    public GluuConfiguration getConfiguration() {
        return this.getConfiguration(null);
    }

    public GluuOxTrustStat getOxtrustStat() {
        return this.getOxtrustStat(null);
    }

    public List<GluuConfiguration> getConfigurations() {
        return this.persistenceEntryManager.findEntries(this.getDnForConfiguration(), GluuConfiguration.class, null);
    }

    public String getDnForConfiguration() {
        String baseDn = this.organizationService.getBaseDn();
        return String.format("ou=configuration,%s", baseDn);
    }

    public AuthenticationScriptUsageType[] getScriptUsageTypes() {
        return new AuthenticationScriptUsageType[]{AuthenticationScriptUsageType.INTERACTIVE, AuthenticationScriptUsageType.SERVICE, AuthenticationScriptUsageType.BOTH};
    }

    public ProgrammingLanguage[] getProgrammingLanguages() {
        return new ProgrammingLanguage[]{ProgrammingLanguage.PYTHON};
    }

    public ScriptLocationType[] getLocationTypes() {
        return new ScriptLocationType[]{ScriptLocationType.LDAP, ScriptLocationType.FILE};
    }

    public CustomScriptType[] getCustomScriptTypes() {
        return new CustomScriptType[]{CustomScriptType.PERSON_AUTHENTICATION, CustomScriptType.CONSENT_GATHERING, CustomScriptType.UPDATE_USER, CustomScriptType.USER_REGISTRATION, CustomScriptType.CLIENT_REGISTRATION, CustomScriptType.DYNAMIC_SCOPE, CustomScriptType.ID_GENERATOR, CustomScriptType.CACHE_REFRESH, CustomScriptType.UMA_RPT_POLICY, CustomScriptType.UMA_CLAIMS_GATHERING, CustomScriptType.UMA_RPT_CLAIMS, CustomScriptType.INTROSPECTION, CustomScriptType.RESOURCE_OWNER_PASSWORD_CREDENTIALS, CustomScriptType.APPLICATION_SESSION, CustomScriptType.END_SESSION, CustomScriptType.SCIM, CustomScriptType.POST_AUTHN, CustomScriptType.PERSISTENCE_EXTENSION, CustomScriptType.IDP, CustomScriptType.REVOKE_TOKEN};
    }

    public CustomScriptType[] getOthersCustomScriptTypes() {
        return new CustomScriptType[]{CustomScriptType.CONSENT_GATHERING, CustomScriptType.UPDATE_USER, CustomScriptType.USER_REGISTRATION, CustomScriptType.CLIENT_REGISTRATION, CustomScriptType.DYNAMIC_SCOPE, CustomScriptType.ID_GENERATOR, CustomScriptType.CACHE_REFRESH, CustomScriptType.UMA_RPT_POLICY, CustomScriptType.UMA_CLAIMS_GATHERING, CustomScriptType.UMA_RPT_CLAIMS, CustomScriptType.INTROSPECTION, CustomScriptType.RESOURCE_OWNER_PASSWORD_CREDENTIALS, CustomScriptType.APPLICATION_SESSION, CustomScriptType.END_SESSION, CustomScriptType.SCIM, CustomScriptType.POST_AUTHN, CustomScriptType.PERSISTENCE_EXTENSION, CustomScriptType.IDP, CustomScriptType.REVOKE_TOKEN, CustomScriptType.UPDATE_TOKEN, CustomScriptType.CIBA_END_USER_NOTIFICATION};
    }

    public void encryptedSmtpPassword(SmtpConfiguration smtpConfiguration) {
        if (smtpConfiguration == null) {
            return;
        }
        String password = smtpConfiguration.getPasswordDecrypted();
        if (StringHelper.isNotEmpty((String)password)) {
            try {
                String encryptedPassword = this.encryptionService.encrypt(password);
                smtpConfiguration.setPassword(encryptedPassword);
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to encrypt SMTP password", (Throwable)ex);
            }
        }
    }

    public void decryptSmtpPassword(SmtpConfiguration smtpConfiguration) {
        if (smtpConfiguration == null) {
            return;
        }
        String password = smtpConfiguration.getPassword();
        if (StringHelper.isNotEmpty((String)password)) {
            try {
                smtpConfiguration.setPasswordDecrypted(this.encryptionService.decrypt(password));
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt SMTP password", (Throwable)ex);
            }
        }
    }

    public String getVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        if (version == null) {
            Properties prop = new Properties();
            try (InputStream is = FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream("/META-INF/MANIFEST.MF");){
                if (is != null) {
                    prop.load(is);
                    version = prop.getProperty("Implementation-Version");
                }
            }
            catch (IOException e) {
                this.log.error(e.toString());
            }
        }
        this.log.info("Starting App version " + version);
        if (version != null) {
            version = version.replace("-SNAPSHOT", "");
            return version;
        }
        return "";
    }
}

