/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxtrust.model.AuthenticationMethod;
import org.gluu.oxtrust.model.BlockEncryptionAlgorithm;
import org.gluu.oxtrust.model.KeyEncryptionAlgorithm;
import org.gluu.oxtrust.model.OxAuthApplicationType;
import org.gluu.oxtrust.model.OxAuthClient;
import org.gluu.oxtrust.model.OxAuthCustomClient;
import org.gluu.oxtrust.model.OxAuthSubjectType;
import org.gluu.oxtrust.model.SignatureAlgorithm;
import org.gluu.oxtrust.service.EncryptionService;
import org.gluu.oxtrust.service.IdGenService;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.gluu.util.StringHelper;
import org.python.jline.internal.Log;
import org.slf4j.Logger;

@ApplicationScoped
public class ClientService
implements Serializable {
    private static final long serialVersionUID = 7912416439116338984L;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private Logger logger;
    @Inject
    private EncryptionService encryptionService;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private IdGenService idGenService;

    public boolean contains(String clientDn) {
        return this.persistenceEntryManager.contains(clientDn, OxAuthClient.class);
    }

    public void addClient(OxAuthClient client) {
        this.persistenceEntryManager.persist((Object)client);
    }

    public void removeClient(OxAuthClient client) {
        this.persistenceEntryManager.removeRecursively(client.getDn(), OxAuthClient.class);
    }

    public OxAuthClient getClientByInum(String inum, String ... ldapReturnAttributes) {
        OxAuthClient result = null;
        try {
            result = (OxAuthClient)this.persistenceEntryManager.find((Object)this.getDnForClient(inum), OxAuthClient.class, ldapReturnAttributes);
            String encodedClientSecret = result.getEncodedClientSecret();
            if (StringHelper.isNotEmpty((String)encodedClientSecret)) {
                String clientSecret = this.encryptionService.decrypt(encodedClientSecret);
                result.setOxAuthClientSecret(clientSecret);
            }
        }
        catch (Exception ex) {
            this.logger.debug("Failed to load client entry", (Throwable)ex);
        }
        return result;
    }

    public OxAuthCustomClient getClientByInumCustom(String inum) {
        return (OxAuthCustomClient)this.persistenceEntryManager.find(OxAuthCustomClient.class, (Object)this.getDnForClient(inum));
    }

    public String getDnForClient(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=clients,%s", orgDn);
        }
        return String.format("inum=%s,ou=clients,%s", inum, orgDn);
    }

    public void updateClient(OxAuthClient client) {
        this.persistenceEntryManager.merge((Object)client);
    }

    public void updateCustomClient(OxAuthCustomClient client) {
        this.persistenceEntryManager.merge((Object)client);
    }

    public String generateInumForNewClient() {
        String newInum = null;
        String newDn = null;
        int trycount = 0;
        do {
            if (trycount < 10) {
                newInum = this.idGenService.generateId("client");
                ++trycount;
                continue;
            }
            newInum = this.idGenService.generateDefaultId();
        } while (this.persistenceEntryManager.contains(newDn = this.getDnForClient(newInum), OxAuthClient.class));
        return newInum;
    }

    public List<OxAuthClient> searchClients(String pattern, int sizeLimit) {
        String[] targetArray = new String[]{pattern};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, inumFilter});
        return this.persistenceEntryManager.findEntries(this.getDnForClient(null), OxAuthClient.class, searchFilter, sizeLimit);
    }

    public List<OxAuthClient> getAllClients(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForClient(null), OxAuthClient.class, null, sizeLimit);
    }

    public List<OxAuthClient> getAllClients() {
        return this.persistenceEntryManager.findEntries(this.getDnForClient(null), OxAuthClient.class, null);
    }

    public OxAuthClient getClientByDn(String Dn) {
        try {
            return (OxAuthClient)this.persistenceEntryManager.find(OxAuthClient.class, (Object)Dn);
        }
        catch (Exception e) {
            Log.warn((Object[])new Object[]{"", e});
            return null;
        }
    }

    public OxAuthCustomClient getClientByDnCustom(String Dn) {
        return (OxAuthCustomClient)this.persistenceEntryManager.find(OxAuthCustomClient.class, (Object)Dn);
    }

    public OxAuthClient getClientByDisplayName(String DisplayName) {
        OxAuthClient client = new OxAuthClient();
        client.setBaseDn(this.getDnForClient(null));
        client.setDisplayName(DisplayName);
        List clients = this.persistenceEntryManager.findEntries((Object)client);
        if (clients != null && clients.size() > 0) {
            return (OxAuthClient)clients.get(0);
        }
        return null;
    }

    public OxAuthCustomClient getClientByAttributeCustom(String name, String value) {
        try {
            if (name.equalsIgnoreCase("dn")) {
                return this.getClientByDnCustom(value);
            }
            if (name.equalsIgnoreCase("inum")) {
                return this.getClientByInumCustom(value);
            }
            OxAuthCustomClient client = new OxAuthCustomClient();
            client.setBaseDn(this.getDnForClient(null));
            client.setAttribute(name, value);
            List clients = this.persistenceEntryManager.findEntries((Object)client);
            if (clients != null && clients.size() > 0) {
                return (OxAuthCustomClient)clients.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            this.logger.info("", (Throwable)ex);
            return null;
        }
    }

    public OxAuthApplicationType[] getApplicationType() {
        return OxAuthApplicationType.values();
    }

    public OxAuthSubjectType[] getSubjectTypes() {
        return OxAuthSubjectType.values();
    }

    public SignatureAlgorithm[] getSignatureAlgorithms() {
        return SignatureAlgorithm.values();
    }

    public SignatureAlgorithm[] getSignatureAlgorithmsWithoutNone() {
        return new SignatureAlgorithm[]{SignatureAlgorithm.HS256, SignatureAlgorithm.HS384, SignatureAlgorithm.HS512, SignatureAlgorithm.RS256, SignatureAlgorithm.RS384, SignatureAlgorithm.RS512, SignatureAlgorithm.ES256, SignatureAlgorithm.ES384, SignatureAlgorithm.ES512, SignatureAlgorithm.PS256, SignatureAlgorithm.PS384, SignatureAlgorithm.PS512};
    }

    public KeyEncryptionAlgorithm[] getKeyEncryptionAlgorithms() {
        return KeyEncryptionAlgorithm.values();
    }

    public BlockEncryptionAlgorithm[] getBlockEncryptionAlgorithms() {
        return BlockEncryptionAlgorithm.values();
    }

    public AuthenticationMethod[] getAuthenticationMethods() {
        return AuthenticationMethod.values();
    }

    public OxAuthClient getClientByInum(String inum) {
        OxAuthClient result = null;
        try {
            result = (OxAuthClient)this.persistenceEntryManager.find(OxAuthClient.class, (Object)this.getDnForClient(inum));
        }
        catch (Exception ex) {
            this.logger.error("Failed to load client entry", (Throwable)ex);
        }
        return result;
    }
}

