/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.gluu.config.oxtrust.AppConfiguration;
import org.gluu.model.GluuAttribute;
import org.gluu.model.GluuAttributeUsageType;
import org.gluu.model.GluuUserRole;
import org.gluu.model.attribute.AttributeDataType;
import org.gluu.model.user.UserRole;
import org.gluu.oxtrust.model.GluuCustomAttribute;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.oxtrust.service.cdi.event.EventType;
import org.gluu.oxtrust.service.cdi.event.EventTypeQualifier;
import org.gluu.oxtrust.service.cdi.event.Events;
import org.gluu.search.filter.Filter;
import org.gluu.service.BaseCacheService;
import org.gluu.util.StringHelper;

@ApplicationScoped
public class AttributeService
extends org.gluu.service.AttributeService {
    private GluuUserRole[] attributeEditTypes = new GluuUserRole[]{GluuUserRole.ADMIN, GluuUserRole.USER};
    private static final long serialVersionUID = 8223624816948822765L;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private OrganizationService organizationService;
    @Inject
    @Any
    private Event<Events> event;
    public static final String CUSTOM_ATTRIBUTE_OBJECTCLASS_PREFIX = "ox-";

    public List<GluuAttribute> getAllPersonAttributes(GluuUserRole gluuUserRole) {
        String key = "personAttributeList_" + gluuUserRole.getValue();
        List<GluuAttribute> attributeList = (List<GluuAttribute>)this.cacheService.get(key);
        if (attributeList == null) {
            attributeList = this.getAllPersonAtributesImpl(gluuUserRole, this.getAllAttributes());
            this.cacheService.put(key, attributeList);
        }
        return attributeList;
    }

    private List<GluuAttribute> getAllPersonAtributesImpl(GluuUserRole gluuUserRole, Collection<GluuAttribute> attributes) {
        ArrayList<GluuAttribute> attributeList = new ArrayList<GluuAttribute>();
        Object[] objectClassTypes = this.appConfiguration.getPersonObjectClassTypes();
        this.log.debug("objectClassTypes={}", (Object)Arrays.toString(objectClassTypes));
        block0: for (GluuAttribute attribute : attributes) {
            if (StringHelper.equalsIgnoreCase((String)attribute.getOrigin(), (String)this.appConfiguration.getPersonCustomObjectClass()) && GluuUserRole.ADMIN == gluuUserRole) {
                attribute.setCustom(true);
                attributeList.add(attribute);
                continue;
            }
            for (Object objectClassType : objectClassTypes) {
                if (!attribute.getOrigin().equals(objectClassType) || !attribute.allowViewBy(gluuUserRole) && !attribute.allowEditBy(gluuUserRole)) continue;
                attributeList.add(attribute);
                continue block0;
            }
        }
        return attributeList;
    }

    public List<GluuAttribute> getAllActiveAttributes(GluuUserRole gluuUserRole) {
        String key = "personAttributeList_" + gluuUserRole.getValue();
        List<GluuAttribute> attributeList = (List<GluuAttribute>)this.cacheService.get(key);
        if (attributeList == null) {
            attributeList = this.getAllPersonAtributes(gluuUserRole, this.getAllAttributes());
            this.cacheService.put(key, attributeList);
        }
        return attributeList;
    }

    public boolean attributeWithSameNameDontExist(String name) {
        Filter nameFilter = Filter.createEqualityFilter((String)"name", (Object)name);
        List result = this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), GluuAttribute.class, nameFilter, null);
        return result == null || result.isEmpty();
    }

    private List<GluuAttribute> getAllPersonAtributes(GluuUserRole gluuUserRole, Collection<GluuAttribute> attributes) {
        ArrayList<GluuAttribute> attributeList = new ArrayList<GluuAttribute>();
        Object[] objectClassTypes = this.appConfiguration.getPersonObjectClassTypes();
        this.log.debug("objectClassTypes={}", (Object)Arrays.toString(objectClassTypes));
        block0: for (GluuAttribute attribute : attributes) {
            if (StringHelper.equalsIgnoreCase((String)attribute.getOrigin(), (String)this.appConfiguration.getPersonCustomObjectClass()) && GluuUserRole.ADMIN == gluuUserRole) {
                attribute.setCustom(true);
                attributeList.add(attribute);
                continue;
            }
            for (Object objectClassType : objectClassTypes) {
                if (!attribute.getOrigin().equals(objectClassType)) continue;
                attributeList.add(attribute);
                continue block0;
            }
        }
        return attributeList;
    }

    public List<GluuAttribute> getAllContactAttributes(GluuUserRole gluuUserRole) {
        String key = "contactAttributeList_" + gluuUserRole.getValue();
        List<GluuAttribute> attributeList = (List<GluuAttribute>)this.cacheService.get(key);
        if (attributeList == null) {
            attributeList = this.getAllContactAtributesImpl(gluuUserRole, this.getAllAttributes());
            this.cacheService.put(key, attributeList);
        }
        return attributeList;
    }

    private List<GluuAttribute> getAllContactAtributesImpl(GluuUserRole gluuUserRole, Collection<GluuAttribute> attributes) {
        ArrayList<GluuAttribute> returnAttributeList = new ArrayList<GluuAttribute>();
        String[] objectClassTypes = this.appConfiguration.getContactObjectClassTypes();
        block0: for (GluuAttribute attribute : attributes) {
            if (StringHelper.equalsIgnoreCase((String)attribute.getOrigin(), (String)this.appConfiguration.getPersonCustomObjectClass()) && GluuUserRole.ADMIN == gluuUserRole) {
                attribute.setCustom(true);
                returnAttributeList.add(attribute);
                continue;
            }
            for (String objectClassType : objectClassTypes) {
                if (!attribute.getOrigin().equals(objectClassType) || !attribute.allowViewBy(gluuUserRole) && !attribute.allowEditBy(gluuUserRole)) continue;
                returnAttributeList.add(attribute);
                continue block0;
            }
        }
        return returnAttributeList;
    }

    public List<String> getAllAttributeOrigins() {
        List<String> attributeOriginList = (List<String>)this.cacheService.get("attributeOriginList");
        if (attributeOriginList == null) {
            attributeOriginList = this.getAllAttributeOrigins(this.getAllAttributes());
            this.cacheService.put("attributeOriginList", attributeOriginList);
        }
        return attributeOriginList;
    }

    public List<String> getAllAttributeOrigins(Collection<GluuAttribute> attributes) {
        ArrayList<String> attributeOriginList = new ArrayList<String>();
        for (GluuAttribute attribute : attributes) {
            String origin = attribute.getOrigin();
            if (attributeOriginList.contains(origin)) continue;
            attributeOriginList.add(attribute.getOrigin());
        }
        String customOrigin = this.getCustomOrigin();
        if (!attributeOriginList.contains(customOrigin)) {
            attributeOriginList.add(customOrigin);
        }
        return attributeOriginList;
    }

    public Map<String, String> getAllAttributeOriginDisplayNames(List<String> attributeOriginList, String[] objectClassTypes, String[] objectClassDisplayNames) {
        HashMap<String, String> attributeOriginDisplayNameMap = new HashMap<String, String>();
        for (String origin : attributeOriginList) {
            attributeOriginDisplayNameMap.put(origin, origin);
        }
        if (objectClassTypes.length == objectClassDisplayNames.length) {
            for (int i = 0; i < objectClassTypes.length; ++i) {
                String objectClass = objectClassTypes[i];
                if (!attributeOriginDisplayNameMap.containsKey(objectClass)) continue;
                attributeOriginDisplayNameMap.put(objectClass, objectClassDisplayNames[i]);
            }
        }
        return attributeOriginDisplayNameMap;
    }

    public List<GluuAttribute> getCustomAttributes() {
        ArrayList<GluuAttribute> attributeList = (ArrayList<GluuAttribute>)this.cacheService.get("customAttributeList");
        if (attributeList == null) {
            attributeList = new ArrayList<GluuAttribute>();
            for (GluuAttribute attribute : this.getAllAttributes()) {
                if (!attribute.isCustom()) continue;
                attributeList.add(attribute);
            }
            this.cacheService.put("customAttributeList", attributeList);
        }
        return attributeList;
    }

    public GluuAttribute getAttributeByInum(String inum) {
        return this.getAttributeByInum(inum, this.getAllAtributesImpl(this.getDnForAttribute(null)));
    }

    public GluuAttribute getAttributeByInum(String inum, List<GluuAttribute> attributes) {
        for (GluuAttribute attribute : attributes) {
            if (!attribute.getInum().equals(inum)) continue;
            return attribute;
        }
        return null;
    }

    public List<GluuAttribute> getSCIMRelatedAttributes() throws Exception {
        return this.getSCIMRelatedAttributesImpl(this.getAllAttributes());
    }

    public List<GluuAttribute> getSCIMRelatedAttributesImpl(List<GluuAttribute> attributes) throws Exception {
        ArrayList<GluuAttribute> result = new ArrayList<GluuAttribute>();
        for (GluuAttribute attribute : attributes) {
            boolean isEmpty = attribute.getOxSCIMCustomAttribute() == null;
            if (isEmpty || attribute.getOxSCIMCustomAttribute() == null || !attribute.getOxSCIMCustomAttribute().booleanValue()) continue;
            result.add(attribute);
        }
        return result;
    }

    public void addAttribute(GluuAttribute attribute) {
        this.persistenceEntryManager.persist((Object)attribute);
        this.event.select(new Annotation[]{new EventTypeQualifier(Events.EVENT_CLEAR_ATTRIBUTES)}).fire((Object)Events.EVENT_CLEAR_ATTRIBUTES);
    }

    public void removeAttribute(String inum) {
        GluuAttribute attribute = new GluuAttribute();
        attribute.setDn(this.getDnForAttribute(inum));
        this.removeAttribute(attribute);
    }

    public void removeAttribute(GluuAttribute attribute) {
        this.log.trace("Removing attribute {}", (Object)attribute.getDisplayName());
        this.persistenceEntryManager.remove((Object)attribute);
        this.event.select(new Annotation[]{new EventTypeQualifier(Events.EVENT_CLEAR_ATTRIBUTES)}).fire((Object)Events.EVENT_CLEAR_ATTRIBUTES);
    }

    public void updateAttribute(GluuAttribute attribute) {
        this.persistenceEntryManager.merge((Object)attribute);
        this.event.select(new Annotation[]{new EventTypeQualifier(Events.EVENT_CLEAR_ATTRIBUTES)}).fire((Object)Events.EVENT_CLEAR_ATTRIBUTES);
    }

    public void clearAttributesCache(@Observes @EventType(value=Events.EVENT_CLEAR_ATTRIBUTES) Events event) {
        this.log.debug("Removing attributes from cache");
        this.cacheService.clear();
    }

    public AttributeDataType[] getDataTypes() {
        return AttributeDataType.values();
    }

    public UserRole[] getAttributeUserRoles() {
        return new UserRole[]{UserRole.ADMIN, UserRole.USER};
    }

    public UserRole[] getViewTypes() {
        return new UserRole[]{UserRole.ADMIN, UserRole.USER};
    }

    public GluuAttributeUsageType[] getAttributeUsageTypes() {
        return new GluuAttributeUsageType[]{GluuAttributeUsageType.OPENID};
    }

    public boolean containsAttribute(GluuAttribute attribute) {
        return this.persistenceEntryManager.contains((Object)attribute);
    }

    public boolean containsAttribute(String dn) {
        return this.persistenceEntryManager.contains(dn, GluuAttribute.class);
    }

    public String generateInumForNewAttribute() {
        String newInum = null;
        String newDn = null;
        while (this.containsAttribute(newDn = this.getDnForAttribute(newInum = this.generateInumForNewAttributeImpl()))) {
        }
        return newInum;
    }

    public String toInumWithoutDelimiters(String inum) {
        return inum.replace(".", "").replace("!", "").replace("@", "");
    }

    public String generateRandomOid() {
        return Long.toString(System.currentTimeMillis());
    }

    private String generateInumForNewAttributeImpl() {
        return UUID.randomUUID().toString();
    }

    public String getDnForAttribute(String inum) {
        String organizationDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=attributes,%s", organizationDn);
        }
        return String.format("inum=%s,ou=attributes,%s", inum, organizationDn);
    }

    public String getCustomOrigin() {
        return this.appConfiguration.getPersonCustomObjectClass();
    }

    protected List<GluuAttribute> getAllAtributesImpl(String baseDn) {
        List attributeList = this.persistenceEntryManager.findEntries(baseDn, GluuAttribute.class, null);
        String customOrigin = this.getCustomOrigin();
        for (GluuAttribute attribute : attributeList) {
            attribute.setCustom(customOrigin.equals(attribute.getOrigin()));
        }
        return attributeList;
    }

    public void setAttributeMetadata(List<GluuCustomAttribute> customAttributes, List<GluuAttribute> attributes) {
        if (customAttributes == null || attributes == null) {
            return;
        }
        for (GluuCustomAttribute personAttribute : customAttributes) {
            GluuAttribute tmpAttribute = this.getAttributeByName(personAttribute.getName(), attributes);
            if (tmpAttribute == null) {
                this.log.warn("Failed to find attribute '{}' metadata", (Object)personAttribute.getName());
            }
            personAttribute.setMetadata(tmpAttribute);
        }
    }

    public List<GluuCustomAttribute> getCustomAttributesByAttributeDNs(List<String> attributeDNs, HashMap<String, GluuAttribute> attributesByDNs) {
        ArrayList<GluuCustomAttribute> customAttributes = new ArrayList<GluuCustomAttribute>();
        if (attributeDNs == null) {
            return customAttributes;
        }
        for (String releasedAttributeDn : attributeDNs) {
            GluuAttribute attribute = attributesByDNs.get(releasedAttributeDn);
            if (attribute == null) continue;
            GluuCustomAttribute customAttribute = new GluuCustomAttribute(attribute.getName(), (Object)releasedAttributeDn);
            customAttribute.setMetadata(attribute);
            customAttributes.add(customAttribute);
        }
        return customAttributes;
    }

    public HashMap<String, GluuAttribute> getAttributeMapByDNs(List<GluuAttribute> attributes) {
        HashMap<String, GluuAttribute> attributeDns = new HashMap<String, GluuAttribute>();
        for (GluuAttribute attribute : attributes) {
            attributeDns.put(attribute.getDn(), attribute);
        }
        return attributeDns;
    }

    public void sortCustomAttributes(List<GluuCustomAttribute> customAttributes, String sortByProperties) {
        this.persistenceEntryManager.sortListByProperties(GluuCustomAttribute.class, customAttributes, false, new String[]{sortByProperties});
    }

    public String getDnForGroup(String inum) throws Exception {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=groups,%s", orgDn);
        }
        return String.format("inum=%s,ou=groups,%s", inum, orgDn);
    }

    public List<GluuAttribute> getAllActivePersonAttributes(GluuUserRole admin) {
        List<GluuAttribute> activeAttributeList = (List<GluuAttribute>)this.cacheService.get("ActiveAttributeCache", "activeAttributeList");
        if (activeAttributeList == null) {
            activeAttributeList = this.getAllActiveAtributesImpl(admin);
            this.cacheService.put("attributeList", activeAttributeList);
        }
        return activeAttributeList;
    }

    private List<GluuAttribute> getAllActiveAtributesImpl(GluuUserRole gluuUserRole) {
        Filter filter = Filter.createEqualityFilter((String)"gluuStatus", (Object)"active");
        List attributeList = this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), GluuAttribute.class, filter);
        String customOrigin = this.getCustomOrigin();
        Object[] objectClassTypes = this.appConfiguration.getPersonObjectClassTypes();
        this.log.debug("objectClassTypes={}", (Object)Arrays.toString(objectClassTypes));
        ArrayList<GluuAttribute> returnAttributeList = new ArrayList<GluuAttribute>();
        block0: for (GluuAttribute attribute : attributeList) {
            if (StringHelper.equalsIgnoreCase((String)attribute.getOrigin(), (String)this.appConfiguration.getPersonCustomObjectClass()) && GluuUserRole.ADMIN == gluuUserRole) {
                attribute.setCustom(true);
                returnAttributeList.add(attribute);
                continue;
            }
            for (Object objectClassType : objectClassTypes) {
                if (!attribute.getOrigin().equals(objectClassType)) continue;
                attribute.setCustom(customOrigin.equals(attribute.getOrigin()));
                returnAttributeList.add(attribute);
                continue block0;
            }
        }
        return returnAttributeList;
    }

    public List<GluuAttribute> searchAttributes(String pattern, int sizeLimit) throws Exception {
        String[] targetArray = new String[]{pattern};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter nameFilter = Filter.createSubstringFilter((String)"gluuAttributeName", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, nameFilter});
        List result = this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), GluuAttribute.class, searchFilter, sizeLimit);
        String customOrigin = this.getCustomOrigin();
        for (GluuAttribute attribute : result) {
            attribute.setCustom(customOrigin.equals(attribute.getOrigin()));
        }
        return result;
    }

    public List<GluuAttribute> searchPersonAttributes(String pattern, int sizeLimit) throws Exception {
        String[] objectClassTypes = this.appConfiguration.getPersonObjectClassTypes();
        String[] targetArray = new String[]{pattern};
        ArrayList<Filter> originFilters = new ArrayList<Filter>();
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        for (String objectClassType : objectClassTypes) {
            Filter originFilter = Filter.createEqualityFilter((String)"gluuAttributeOrigin", (Object)objectClassType);
            originFilters.add(originFilter);
        }
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter});
        Filter originFilter = Filter.createORFilter((Filter[])originFilters.toArray(new Filter[0]));
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{searchFilter, originFilter});
        return this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), GluuAttribute.class, filter, sizeLimit);
    }

    public GluuAttribute getAttributeByDn(String Dn) throws Exception {
        return (GluuAttribute)this.persistenceEntryManager.find(GluuAttribute.class, (Object)Dn);
    }

    public GluuUserRole[] getAttributeEditTypes() {
        return this.attributeEditTypes;
    }

    public void setAttributeEditTypes(GluuUserRole[] attributeEditTypes) {
        this.attributeEditTypes = attributeEditTypes;
    }

    protected BaseCacheService getCacheService() {
        return this.cacheService;
    }
}

