/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.gluu.config.oxtrust.AppConfiguration;
import org.gluu.model.SmtpConfiguration;
import org.gluu.oxtrust.model.GluuConfiguration;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.persist.PersistenceEntryManagerFactory;
import org.gluu.persist.model.PersistenceConfiguration;
import org.gluu.persist.service.PersistanceFactoryService;
import org.gluu.service.cache.CacheConfiguration;
import org.gluu.service.cache.InMemoryConfiguration;
import org.gluu.service.config.ConfigurationFactory;
import org.gluu.service.document.store.conf.DocumentStoreConfiguration;
import org.gluu.service.document.store.conf.LocalDocumentStoreConfiguration;
import org.slf4j.Logger;

@ApplicationScoped
public class ApplicationFactory {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationFactory<?> configurationFactory;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private PersistanceFactoryService persistanceFactoryService;
    @Inject
    private AppConfiguration appConfiguration;
    public static final String PERSISTENCE_ENTRY_MANAGER_FACTORY_NAME = "persistenceEntryManagerFactory";
    public static final String PERSISTENCE_ENTRY_MANAGER_NAME = "persistenceEntryManager";
    public static final String PERSISTENCE_METRIC_ENTRY_MANAGER_NAME = "persistenceMetricEntryManager";
    public static final String PERSISTENCE_CENTRAL_ENTRY_MANAGER_NAME = "centralPersistenceEntryManager";
    public static final String PERSISTENCE_METRIC_CONFIG_GROUP_NAME = "metric";

    @Produces
    @ApplicationScoped
    public CacheConfiguration getCacheConfiguration() {
        CacheConfiguration cacheConfiguration = this.configurationService.getConfiguration().getCacheConfiguration();
        if (cacheConfiguration == null || cacheConfiguration.getCacheProviderType() == null) {
            this.log.error("Failed to read cache configuration from DB. Please check configuration oxCacheConfiguration attribute that must contain cache configuration JSON represented by CacheConfiguration.class. Appliance DN: " + this.configurationService.getConfiguration().getDn());
            this.log.info("Creating fallback IN-MEMORY cache configuration ... ");
            cacheConfiguration = new CacheConfiguration();
            cacheConfiguration.setInMemoryConfiguration(new InMemoryConfiguration());
            this.log.info("IN-MEMORY cache configuration is created.");
        } else if (cacheConfiguration.getNativePersistenceConfiguration() != null) {
            cacheConfiguration.getNativePersistenceConfiguration().setBaseDn(this.appConfiguration.getBaseDN());
        }
        this.log.info("Cache configuration: " + cacheConfiguration);
        return cacheConfiguration;
    }

    @Produces
    @ApplicationScoped
    public DocumentStoreConfiguration getDocumentStoreConfiguration() {
        DocumentStoreConfiguration documentStoreConfiguration = this.configurationService.getConfiguration().getDocumentStoreConfiguration();
        if (documentStoreConfiguration == null || documentStoreConfiguration.getDocumentStoreType() == null) {
            this.log.error("Failed to read document store configuration from DB. Please check configuration oxDocumentStoreConfiguration attribute that must contain document store configuration JSON represented by DocumentStoreConfiguration.class. Appliance DN: " + this.configurationService.getConfiguration().getDn());
            this.log.info("Creating fallback LOCAL document store configuration ... ");
            documentStoreConfiguration = new DocumentStoreConfiguration();
            documentStoreConfiguration.setLocalConfiguration(new LocalDocumentStoreConfiguration());
            this.log.info("LOCAL document store configuration is created.");
        }
        this.log.info("Document store configuration: " + documentStoreConfiguration);
        return documentStoreConfiguration;
    }

    @Produces
    @RequestScoped
    public SmtpConfiguration getSmtpConfiguration() {
        GluuConfiguration configuration = this.configurationService.getConfiguration();
        SmtpConfiguration smtpConfiguration = configuration.getSmtpConfiguration();
        if (smtpConfiguration == null) {
            return new SmtpConfiguration();
        }
        this.configurationService.decryptSmtpPassword(smtpConfiguration);
        return smtpConfiguration;
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory() {
        PersistenceConfiguration persistenceConfiguration = this.configurationFactory.getPersistenceConfiguration();
        return this.persistanceFactoryService.getPersistenceEntryManagerFactory(persistenceConfiguration);
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(PersistenceConfiguration persistenceConfiguration) {
        return this.persistanceFactoryService.getPersistenceEntryManagerFactory(persistenceConfiguration);
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(Class<? extends PersistenceEntryManagerFactory> persistenceEntryManagerFactoryClass) {
        return this.persistanceFactoryService.getPersistenceEntryManagerFactory(persistenceEntryManagerFactoryClass);
    }
}

