/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.auth.uma;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Response;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.gluu.config.oxtrust.AppConfiguration;
import org.gluu.exception.OxIntializationException;
import org.gluu.oxauth.client.uma.UmaClientFactory;
import org.gluu.oxauth.client.uma.UmaMetadataService;
import org.gluu.oxauth.client.uma.UmaRptIntrospectionService;
import org.gluu.oxauth.model.uma.PermissionTicket;
import org.gluu.oxauth.model.uma.RptIntrospectionResponse;
import org.gluu.oxauth.model.uma.UmaMetadata;
import org.gluu.oxauth.model.uma.UmaPermission;
import org.gluu.oxauth.model.uma.UmaPermissionList;
import org.gluu.oxauth.model.uma.wrapper.Token;
import org.gluu.service.cdi.event.ApplicationInitialized;
import org.gluu.service.cdi.event.ApplicationInitializedEvent;
import org.gluu.util.Pair;
import org.gluu.util.StringHelper;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="umaPermissionService")
public class UmaPermissionService
implements Serializable {
    private static final long serialVersionUID = -3347131971095468866L;
    @Inject
    private Logger log;
    @Inject
    private UmaMetadata umaMetadata;
    @Inject
    protected AppConfiguration appConfiguration;
    private org.gluu.oxauth.client.uma.UmaPermissionService permissionService;
    private UmaRptIntrospectionService rptStatusService;
    private final Pair<Boolean, Response> authenticationFailure = new Pair((Object)false, null);
    private final Pair<Boolean, Response> authenticationSuccess = new Pair((Object)true, null);
    private ClientHttpEngine clientHttpEngine;
    private ConnectionKeepAliveStrategy connectionKeepAliveStrategy = new ConnectionKeepAliveStrategy(){

        public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
            BasicHeaderElementIterator headerElementIterator = new BasicHeaderElementIterator(httpResponse.headerIterator("Keep-Alive"));
            while (headerElementIterator.hasNext()) {
                HeaderElement headerElement = headerElementIterator.nextElement();
                if (headerElement.getValue() == null || !headerElement.getName().equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(headerElement.getValue()) * 1000L;
            }
            return UmaPermissionService.this.appConfiguration.getRptConnectionPoolCustomKeepAliveTimeout() * 1000;
        }
    };

    public void init(@Observes @ApplicationInitialized(value=ApplicationScoped.class) ApplicationInitializedEvent init) {
        try {
            if (this.umaMetadata != null) {
                if (this.appConfiguration.isRptConnectionPoolUseConnectionPooling()) {
                    this.log.debug("##### Initializing custom ClientExecutor...");
                    PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
                    connectionManager.setMaxTotal(this.appConfiguration.getRptConnectionPoolMaxTotal());
                    connectionManager.setDefaultMaxPerRoute(this.appConfiguration.getRptConnectionPoolDefaultMaxPerRoute());
                    connectionManager.setValidateAfterInactivity(this.appConfiguration.getRptConnectionPoolValidateAfterInactivity() * 1000);
                    CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setKeepAliveStrategy(this.connectionKeepAliveStrategy).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
                    ApacheHttpClient43Engine engine = new ApacheHttpClient43Engine((HttpClient)client);
                    engine.setFollowRedirects(true);
                    this.clientHttpEngine = engine;
                    this.log.info("##### Initializing custom ClientExecutor DONE");
                    this.permissionService = UmaClientFactory.instance().createPermissionService(this.umaMetadata, this.clientHttpEngine);
                    this.rptStatusService = UmaClientFactory.instance().createRptStatusService(this.umaMetadata, this.clientHttpEngine);
                } else {
                    this.permissionService = UmaClientFactory.instance().createPermissionService(this.umaMetadata);
                    this.rptStatusService = UmaClientFactory.instance().createRptStatusService(this.umaMetadata);
                }
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to initialize UmaPermissionService", (Throwable)ex);
        }
    }

    @Produces
    @ApplicationScoped
    @Named(value="umaMetadataConfiguration")
    public UmaMetadata initUmaMetadataConfiguration() throws OxIntializationException {
        String umaConfigurationEndpoint = this.getUmaConfigurationEndpoint();
        if (StringHelper.isEmpty((String)umaConfigurationEndpoint)) {
            return null;
        }
        this.log.info("##### Getting UMA metadata ...");
        UmaMetadataService metaDataConfigurationService = this.clientHttpEngine == null ? UmaClientFactory.instance().createMetadataService(umaConfigurationEndpoint) : UmaClientFactory.instance().createMetadataService(umaConfigurationEndpoint, this.clientHttpEngine);
        UmaMetadata metadataConfiguration = null;
        int max_attempts = 10;
        for (int attempt = 1; attempt <= max_attempts; ++attempt) {
            try {
                metadataConfiguration = metaDataConfigurationService.getMetadata();
                continue;
            }
            catch (ServiceUnavailableException ex) {
                if (attempt == max_attempts || ex.getResponse().getStatus() != Response.Status.SERVICE_UNAVAILABLE.getStatusCode()) {
                    throw ex;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex2) {
                    throw ex;
                }
                this.log.info("##### Attempting to load UMA metadata ... {}", (Object)attempt);
            }
        }
        this.log.info("##### Getting UMA metadata ... DONE");
        if (metadataConfiguration == null) {
            throw new OxIntializationException("UMA meta data configuration is invalid!");
        }
        return metadataConfiguration;
    }

    public String getUmaConfigurationEndpoint() {
        String umaIssuer = this.appConfiguration.getUmaIssuer();
        if (StringHelper.isEmpty((String)umaIssuer)) {
            this.log.trace("oxAuth UMA issuer isn't specified");
            return null;
        }
        String umaConfigurationEndpoint = umaIssuer;
        if (!umaConfigurationEndpoint.endsWith("uma2-configuration")) {
            umaConfigurationEndpoint = umaConfigurationEndpoint + "/.well-known/uma2-configuration";
        }
        return umaConfigurationEndpoint;
    }

    public Pair<Boolean, Response> validateRptToken(Token patToken, String authorization, String umaResourceId, String scopeId) {
        return this.validateRptToken(patToken, authorization, umaResourceId, Arrays.asList(scopeId));
    }

    public Pair<Boolean, Response> validateRptToken(Token patToken, String authorization, String resourceId, List<String> scopeIds) {
        Response registerPermissionsResponse;
        this.log.trace("Validating RPT, resourceId: {}, scopeIds: {}, authorization: {}", new Object[]{resourceId, scopeIds, authorization});
        if (StringHelper.isNotEmpty((String)authorization) && authorization.startsWith("Bearer ")) {
            String rptToken = authorization.substring(7);
            RptIntrospectionResponse rptStatusResponse = this.getStatusResponse(patToken, rptToken);
            this.log.trace("RPT status response: {} ", (Object)rptStatusResponse);
            if (rptStatusResponse == null || !rptStatusResponse.getActive()) {
                this.log.warn("Status response for RPT token: '{}' is invalid, will do a retry", (Object)rptToken);
            } else {
                boolean rptHasPermissions = this.isRptHasPermissions(rptStatusResponse);
                if (rptHasPermissions) {
                    LinkedList returnScopeIds = new LinkedList();
                    for (UmaPermission umaPermission : rptStatusResponse.getPermissions()) {
                        if (umaPermission.getScopes() == null) continue;
                        returnScopeIds.addAll(umaPermission.getScopes());
                    }
                    if (returnScopeIds.containsAll(scopeIds)) {
                        return this.authenticationSuccess;
                    }
                    this.log.error("Status response for RPT token: '{}' not contains right permissions", (Object)rptToken);
                }
            }
        }
        if ((registerPermissionsResponse = this.prepareRegisterPermissionsResponse(patToken, resourceId, scopeIds)) == null) {
            return this.authenticationFailure;
        }
        return new Pair((Object)true, (Object)registerPermissionsResponse);
    }

    private boolean isRptHasPermissions(RptIntrospectionResponse umaRptStatusResponse) {
        return umaRptStatusResponse.getPermissions() != null && !umaRptStatusResponse.getPermissions().isEmpty();
    }

    private RptIntrospectionResponse getStatusResponse(Token patToken, String rptToken) {
        String authorization = "Bearer " + patToken.getAccessToken();
        if (this.rptStatusService == null) {
            this.init(null);
        }
        RptIntrospectionResponse rptStatusResponse = null;
        try {
            rptStatusResponse = this.rptStatusService.requestRptStatus(authorization, rptToken, "");
        }
        catch (Exception ex) {
            this.log.error("Failed to determine RPT status", (Throwable)ex);
            ex.printStackTrace();
        }
        if (rptStatusResponse == null || !rptStatusResponse.getActive()) {
            return null;
        }
        return rptStatusResponse;
    }

    public String registerResourcePermission(Token patToken, String resourceId, List<String> scopes) {
        if (this.permissionService == null) {
            this.init(null);
        }
        UmaPermission permission = new UmaPermission();
        permission.setResourceId(resourceId);
        permission.setScopes(scopes);
        PermissionTicket ticket = this.permissionService.registerPermission("Bearer " + patToken.getAccessToken(), UmaPermissionList.instance((UmaPermission[])new UmaPermission[]{permission}));
        if (ticket == null) {
            return null;
        }
        return ticket.getTicket();
    }

    private Response prepareRegisterPermissionsResponse(Token patToken, String resourceId, List<String> scopes) {
        String ticket = this.registerResourcePermission(patToken, resourceId, scopes);
        if (StringHelper.isEmpty((String)ticket)) {
            return null;
        }
        this.log.debug("Construct response: HTTP 401 (Unauthorized), ticket: '{}'", (Object)ticket);
        Response response = null;
        try {
            String authHeaderValue = String.format("UMA realm=\"Authorization required\", host_id=%s, as_uri=%s, ticket=%s", this.getHost(this.appConfiguration.getIdpUrl()), this.getUmaConfigurationEndpoint(), ticket);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)authHeaderValue).build();
        }
        catch (MalformedURLException ex) {
            this.log.error("Failed to determine host by URI", (Throwable)ex);
        }
        return response;
    }

    private String getHost(String uri) throws MalformedURLException {
        URL url = new URL(uri);
        return url.getHost();
    }
}

