/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.auth.uma;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.client.uma.wrapper.UmaClient;
import org.gluu.oxauth.model.uma.UmaMetadata;
import org.gluu.oxauth.model.uma.wrapper.Token;
import org.gluu.oxtrust.auth.IProtectionService;
import org.gluu.oxtrust.auth.uma.UmaPermissionService;
import org.gluu.oxtrust.exception.UmaProtectionException;
import org.gluu.oxtrust.service.EncryptionService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.gluu.util.Pair;
import org.gluu.util.StringHelper;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;

public abstract class BaseUmaProtectionService
implements IProtectionService,
Serializable {
    private static final long serialVersionUID = -1147131971095468865L;
    @Inject
    private Logger log;
    @Inject
    private EncryptionService encryptionService;
    @Inject
    private UmaMetadata umaMetadata;
    @Inject
    protected UmaPermissionService umaPermissionService;
    private Token umaPat;
    private long umaPatAccessTokenExpiration = 0L;
    private final ReentrantLock lock = new ReentrantLock();

    public Token getPatToken() throws UmaProtectionException {
        if (this.isValidPatToken(this.umaPat, this.umaPatAccessTokenExpiration)) {
            return this.umaPat;
        }
        this.lock.lock();
        try {
            if (this.isValidPatToken(this.umaPat, this.umaPatAccessTokenExpiration)) {
                Token token = this.umaPat;
                return token;
            }
            this.retrievePatToken();
        }
        finally {
            this.lock.unlock();
        }
        return this.umaPat;
    }

    protected boolean isEnabledUmaAuthentication() {
        return this.umaMetadata != null && this.isExistPatToken();
    }

    public boolean isExistPatToken() {
        try {
            return this.getPatToken() != null;
        }
        catch (UmaProtectionException ex) {
            this.log.error("Failed to check UMA PAT token status", (Throwable)ex);
            return false;
        }
    }

    public String getIssuer() {
        if (this.umaMetadata == null) {
            return "";
        }
        return this.umaMetadata.getIssuer();
    }

    private void retrievePatToken() throws UmaProtectionException {
        this.umaPat = null;
        if (this.umaMetadata == null) {
            return;
        }
        String umaClientKeyStoreFile = this.getClientKeyStoreFile();
        String umaClientKeyStorePassword = this.getClientKeyStorePassword();
        if (StringHelper.isEmpty((String)umaClientKeyStoreFile) || StringHelper.isEmpty((String)umaClientKeyStorePassword)) {
            throw new UmaProtectionException("UMA JKS keystore path or password is empty");
        }
        if (umaClientKeyStorePassword != null) {
            try {
                umaClientKeyStorePassword = this.encryptionService.decrypt(umaClientKeyStorePassword);
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt UmaClientKeyStorePassword password", (Throwable)ex);
            }
        }
        try {
            this.umaPat = UmaClient.requestPat((String)this.umaMetadata.getTokenEndpoint(), (String)umaClientKeyStoreFile, (String)umaClientKeyStorePassword, (String)this.getClientId(), (String)this.getClientKeyId());
            this.umaPatAccessTokenExpiration = this.umaPat == null ? 0L : this.computeAccessTokenExpirationTime(this.umaPat.getExpiresIn());
        }
        catch (Exception ex) {
            throw new UmaProtectionException("Failed to obtain valid UMA PAT token", ex);
        }
        if (this.umaPat == null || this.umaPat.getAccessToken() == null) {
            throw new UmaProtectionException("Failed to obtain valid UMA PAT token");
        }
    }

    protected long computeAccessTokenExpirationTime(Integer expiresIn) {
        Calendar calendar = Calendar.getInstance();
        if (expiresIn != null) {
            calendar.add(13, expiresIn);
            calendar.add(13, -10);
        }
        return calendar.getTimeInMillis();
    }

    private boolean isValidPatToken(Token validatePatToken, long validatePatTokenExpiration) {
        long now = System.currentTimeMillis();
        return validatePatToken != null && validatePatToken.getAccessToken() != null && validatePatTokenExpiration > now;
    }

    Response processUmaAuthorization(String authorization, ResourceInfo resourceInfo) throws Exception {
        List<String> scopes = this.getRequestedScopes(resourceInfo);
        Token patToken = null;
        try {
            patToken = this.getPatToken();
        }
        catch (UmaProtectionException ex) {
            return IProtectionService.simpleResponse(Response.Status.INTERNAL_SERVER_ERROR, "Failed to obtain PAT token");
        }
        Pair<Boolean, Response> rptTokenValidationResult = !scopes.isEmpty() ? this.umaPermissionService.validateRptToken(patToken, authorization, this.getUmaResourceId(), scopes) : this.umaPermissionService.validateRptToken(patToken, authorization, this.getUmaResourceId(), this.getUmaScope());
        if (((Boolean)rptTokenValidationResult.getFirst()).booleanValue()) {
            if (rptTokenValidationResult.getSecond() != null) {
                return (Response)rptTokenValidationResult.getSecond();
            }
        } else {
            return IProtectionService.simpleResponse(Response.Status.UNAUTHORIZED, "Invalid GAT/RPT token");
        }
        return null;
    }

    public List<String> getRequestedScopes(ResourceInfo resourceInfo) {
        Class resourceClass = resourceInfo.getResourceClass();
        ProtectedApi typeAnnotation = resourceClass.getAnnotation(ProtectedApi.class);
        ArrayList<String> scopes = new ArrayList<String>();
        if (typeAnnotation == null) {
            this.addMethodScopes(resourceInfo, scopes);
        } else {
            scopes.addAll(Stream.of(typeAnnotation.scopes()).collect(Collectors.toList()));
            this.addMethodScopes(resourceInfo, scopes);
        }
        return scopes;
    }

    private void addMethodScopes(ResourceInfo resourceInfo, List<String> scopes) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        ProtectedApi methodAnnotation = resourceMethod.getAnnotation(ProtectedApi.class);
        if (methodAnnotation != null) {
            scopes.addAll(Stream.of(methodAnnotation.scopes()).collect(Collectors.toList()));
        }
    }

    protected abstract String getClientId();

    protected abstract String getClientKeyStorePassword();

    protected abstract String getClientKeyStoreFile();

    protected abstract String getClientKeyId();

    public abstract String getUmaResourceId();

    public abstract String getUmaScope();

    @Override
    public Response processAuthorization(HttpHeaders headers, ResourceInfo resourceInfo) {
        Response authorizationResponse;
        String authorization = headers.getHeaderString("Authorization");
        this.log.info("Authorization header {} found", (Object)(StringUtils.isEmpty((String)authorization) ? "not" : ""));
        try {
            authorizationResponse = this.isEnabledUmaAuthentication() ? this.processUmaAuthorization(authorization, resourceInfo) : IProtectionService.simpleResponse(Response.Status.INTERNAL_SERVER_ERROR, "Failed to setup UMA authentication");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            authorizationResponse = IProtectionService.simpleResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return authorizationResponse;
    }
}

