/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.util;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.List;
import org.gluu.model.SimpleProperty;
import org.gluu.model.ldap.GluuLdapConfiguration;

public class LdapConnectionData {
    private String bindDN;
    private String bindPassword;
    private List<String> servers;
    private boolean useSSL;

    public LdapConnectionData() {
    }

    public LdapConnectionData(String bindDN, String bindPassword, List<String> servers, boolean useSSL) {
        this.bindDN = bindDN;
        this.bindPassword = bindPassword;
        this.servers = servers;
        this.useSSL = useSSL;
    }

    public static LdapConnectionData from(GluuLdapConfiguration ldapConfig) {
        return new LdapConnectionData(ldapConfig.getBindDN(), ldapConfig.getBindPassword(), (List<String>)FluentIterable.from((Iterable)ldapConfig.getServers()).transform((Function)new Function<SimpleProperty, String>(){

            public String apply(SimpleProperty property) {
                return property.getValue();
            }
        }).toList(), ldapConfig.isUseSSL());
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public void setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword;
    }

    public List<String> getServers() {
        return this.servers;
    }

    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }
}

