/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.util;

import java.util.List;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxtrust.util.LdapConnectionData;
import org.gluu.persist.ldap.operation.impl.LdapConnectionProvider;
import org.gluu.service.config.ConfigurationFactory;
import org.gluu.util.properties.FileConfiguration;
import org.gluu.util.security.PropertiesDecrypter;

@ApplicationScoped
public class ConnectionStatus {
    @Inject
    private ConfigurationFactory<?> configurationFactory;

    public boolean isUp(LdapConnectionData ldapConnectionData) {
        FileConfiguration configuration = this.loadFileConfiguration();
        Properties properties = configuration.getProperties();
        properties.setProperty("bindDN", ldapConnectionData.getBindDN());
        properties.setProperty("bindPassword", ldapConnectionData.getBindPassword());
        properties.setProperty("servers", this.buildServersString(ldapConnectionData.getServers()));
        properties.setProperty("useSSL", Boolean.toString(ldapConnectionData.isUseSSL()));
        LdapConnectionProvider connectionProvider = new LdapConnectionProvider(PropertiesDecrypter.decryptProperties((Properties)properties, (String)this.configurationFactory.getCryptoConfigurationSalt()));
        connectionProvider.create();
        if (connectionProvider.getConnectionPool() != null) {
            boolean isConnected = connectionProvider.isConnected();
            connectionProvider.closeConnectionPool();
            return isConnected;
        }
        return false;
    }

    private FileConfiguration loadFileConfiguration() {
        FileConfiguration configuration = new FileConfiguration(ConfigurationFactory.APP_PROPERTIES_FILE);
        if (!configuration.isLoaded()) {
            configuration = new FileConfiguration("gluu-ldap.properties");
        }
        return configuration;
    }

    private String buildServersString(List<String> servers) {
        if (servers == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String server : servers) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(server);
        }
        return sb.toString();
    }
}

