/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service.radius;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.MappingException;
import org.gluu.radius.model.ServerConfiguration;
import org.gluu.service.config.ConfigurationFactory;
import org.gluu.util.StringHelper;
import org.gluu.util.properties.FileConfiguration;
import org.slf4j.Logger;

@ApplicationScoped
public class GluuRadiusConfigService
implements Serializable {
    private static final long serialVersionUID = 3720989420960664644L;
    private static final String configurationEntryDN = "oxradius_ConfigurationEntryDN";
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private ConfigurationFactory<?> configurationFactory;
    @Inject
    private Logger log;

    public ServerConfiguration getServerConfiguration() {
        if (!this.containsRadiusServerConfiguration()) {
            return null;
        }
        try {
            return (ServerConfiguration)this.persistenceEntryManager.find(ServerConfiguration.class, (Object)this.getServerConfigurationDn());
        }
        catch (MappingException e) {
            this.log.error("Failed to load radius server configuration", (Throwable)e);
            return null;
        }
    }

    public void updateServerConfiguration(ServerConfiguration serverConfiguration) {
        if (serverConfiguration == null || !this.containsRadiusServerConfiguration()) {
            return;
        }
        serverConfiguration.setDn(this.getServerConfigurationDn());
        this.persistenceEntryManager.merge((Object)serverConfiguration);
    }

    private boolean containsRadiusServerConfiguration() {
        String configurationDn = this.getServerConfigurationDn();
        if (StringHelper.isEmpty((String)configurationDn)) {
            return false;
        }
        return this.persistenceEntryManager.contains(configurationDn, ServerConfiguration.class);
    }

    private String getServerConfigurationDn() {
        FileConfiguration fileConfiguration = this.configurationFactory.getBaseConfiguration();
        return fileConfiguration.getString(configurationEntryDN);
    }
}

