/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service.filter;

import java.io.IOException;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.gluu.oxtrust.auth.GluuRestService;
import org.gluu.oxtrust.auth.IProtectionService;
import org.gluu.oxtrust.auth.ProtectionServiceSelector;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.slf4j.Logger;

@Provider
@ProtectedApi
@Priority(value=1000)
@RequestScoped
public class AuthorizationProcessingFilter
implements ContainerRequestFilter {
    @Inject
    private Logger log;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    private ProtectionServiceSelector beanSelector;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Response authorizationResponse = null;
        String path = requestContext.getUriInfo().getPath();
        this.log.debug("REST call to '{}' intercepted", (Object)path);
        GluuRestService api = this.beanSelector.select(path);
        if (api == null) {
            this.log.warn("No REST service bean associated to this path (resource will be accessed anonymously)");
        } else if (!api.isEnabled()) {
            this.log.warn("Please activate {} API", (Object)api.getName());
            authorizationResponse = this.disabledApiResponse(api.getName());
        } else {
            IProtectionService protectionService = api.getProtectionService();
            if (protectionService == null) {
                this.log.warn("No concrete protection mechanism associated to this API. Denying access");
                authorizationResponse = this.unprotectedApiResponse(api.getName());
            } else {
                this.log.debug("Path is protected, proceeding with authorization processing...");
                authorizationResponse = protectionService.processAuthorization(this.httpHeaders, this.resourceInfo);
                if (authorizationResponse == null) {
                    this.log.debug("Authorization passed");
                }
            }
        }
        if (authorizationResponse != null) {
            requestContext.abortWith(authorizationResponse);
        }
    }

    private Response unprotectedApiResponse(String name) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(name + " API not protected")).build();
    }

    private Response disabledApiResponse(String name) {
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)(name + " API is disabled")).build();
    }
}

