/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.gluu.model.GluuAttribute;
import org.gluu.model.GluuStatus;
import org.gluu.model.TrustContact;
import org.gluu.oxtrust.model.GluuMetadataSourceType;
import org.gluu.oxtrust.model.GluuSAMLTrustRelationship;
import org.gluu.oxtrust.service.AttributeService;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.gluu.service.XmlService;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@ApplicationScoped
public class TrustService
implements Serializable {
    private static final long serialVersionUID = -8128546040230316737L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private AttributeService attributeService;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private XmlService xmlService;
    private ObjectMapper objectMapper;
    public static final String GENERATED_SSL_ARTIFACTS_DIR = "ssl";

    @PostConstruct
    public void init() {
        this.objectMapper = new ObjectMapper();
    }

    public void addTrustRelationship(GluuSAMLTrustRelationship trustRelationship) {
        this.log.debug("Adding TR: {}", (Object)trustRelationship.getInum());
        String dn = trustRelationship.getDn();
        if (!this.containsTrustRelationship(dn)) {
            this.log.debug("Adding TR: {}", (Object)dn);
            this.persistenceEntryManager.persist((Object)trustRelationship);
        } else {
            this.persistenceEntryManager.merge((Object)trustRelationship);
        }
    }

    public void updateTrustRelationship(GluuSAMLTrustRelationship trustRelationship) {
        String dn = trustRelationship.getDn();
        boolean containsTrustRelationship = this.trustExist(dn);
        if (containsTrustRelationship) {
            this.log.info("Updating TR: {}", (Object)dn);
            this.persistenceEntryManager.merge((Object)trustRelationship);
        } else {
            this.log.info("Adding TR: {}", (Object)dn);
            this.persistenceEntryManager.persist((Object)trustRelationship);
        }
    }

    public void removeTrustRelationship(GluuSAMLTrustRelationship trustRelationship) {
        this.log.info("Removing TR: {}", (Object)trustRelationship.getInum());
        String dn = trustRelationship.getDn();
        if (this.containsTrustRelationship(dn)) {
            this.log.debug("Removing TR: {}", (Object)dn);
            this.persistenceEntryManager.remove((Object)trustRelationship);
        }
    }

    public GluuSAMLTrustRelationship getRelationshipByInum(String inum) {
        try {
            return (GluuSAMLTrustRelationship)this.persistenceEntryManager.find(GluuSAMLTrustRelationship.class, (Object)this.getDnForTrustRelationShip(inum));
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            return null;
        }
    }

    public GluuSAMLTrustRelationship getRelationshipByDn(String dn) {
        if (StringHelper.isNotEmpty((String)dn)) {
            try {
                return (GluuSAMLTrustRelationship)this.persistenceEntryManager.find(GluuSAMLTrustRelationship.class, (Object)dn);
            }
            catch (Exception e) {
                this.log.info(e.getMessage());
            }
        }
        return null;
    }

    public List<GluuSAMLTrustRelationship> getAllTrustRelationships() {
        return this.persistenceEntryManager.findEntries(this.getDnForTrustRelationShip(null), GluuSAMLTrustRelationship.class, null);
    }

    public List<GluuSAMLTrustRelationship> getAllActiveTrustRelationships() {
        GluuSAMLTrustRelationship trustRelationship = new GluuSAMLTrustRelationship();
        trustRelationship.setBaseDn(this.getDnForTrustRelationShip(null));
        trustRelationship.setStatus(GluuStatus.ACTIVE);
        return this.persistenceEntryManager.findEntries((Object)trustRelationship);
    }

    public List<GluuSAMLTrustRelationship> getAllFederations() {
        ArrayList<GluuSAMLTrustRelationship> result = new ArrayList<GluuSAMLTrustRelationship>();
        for (GluuSAMLTrustRelationship trust : this.getAllActiveTrustRelationships()) {
            if (!trust.isFederation()) continue;
            result.add(trust);
        }
        return result;
    }

    public List<GluuSAMLTrustRelationship> getAllOtherFederations(String inum) {
        List<GluuSAMLTrustRelationship> result = this.getAllFederations();
        result.remove(this.getRelationshipByInum(inum));
        return result;
    }

    public boolean containsTrustRelationship(String dn) {
        return this.persistenceEntryManager.contains(dn, GluuSAMLTrustRelationship.class);
    }

    public boolean trustExist(String dn) {
        GluuSAMLTrustRelationship trust = null;
        try {
            trust = (GluuSAMLTrustRelationship)this.persistenceEntryManager.find(GluuSAMLTrustRelationship.class, (Object)dn);
        }
        catch (Exception e) {
            trust = null;
        }
        return trust != null;
    }

    public String generateInumForNewTrustRelationship() {
        String newDn = null;
        String newInum = null;
        while (this.containsTrustRelationship(newDn = this.getDnForTrustRelationShip(newInum = this.generateInumForNewTrustRelationshipImpl()))) {
        }
        return newInum;
    }

    private String generateInumForNewTrustRelationshipImpl() {
        return UUID.randomUUID().toString();
    }

    public GluuMetadataSourceType[] getMetadataSourceTypes() {
        return GluuMetadataSourceType.values();
    }

    public String getDnForTrustRelationShip(String inum) {
        String organizationDN = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=trustRelationships,%s", organizationDN);
        }
        return String.format("inum=%s,ou=trustRelationships,%s", inum, organizationDN);
    }

    public List<TrustContact> getContacts(GluuSAMLTrustRelationship trustRelationship) {
        List gluuTrustContacts = trustRelationship.getGluuTrustContact();
        ArrayList<TrustContact> contacts = new ArrayList<TrustContact>();
        if (gluuTrustContacts != null) {
            for (String contact : gluuTrustContacts) {
                contacts.add(this.getTrustContactFromString(contact));
            }
        }
        return contacts;
    }

    public void saveContacts(GluuSAMLTrustRelationship trustRelationship, List<TrustContact> contacts) {
        if (contacts != null && !contacts.isEmpty()) {
            ArrayList<String> gluuTrustContacts = new ArrayList<String>();
            for (TrustContact contact : contacts) {
                gluuTrustContacts.add(this.getStringFromTrustContact(contact));
            }
            trustRelationship.setGluuTrustContact(gluuTrustContacts);
        }
    }

    public List<GluuSAMLTrustRelationship> getDeconstructedTrustRelationships(GluuSAMLTrustRelationship trustRelationship) {
        ArrayList<GluuSAMLTrustRelationship> result = new ArrayList<GluuSAMLTrustRelationship>();
        for (GluuSAMLTrustRelationship trust : this.getAllTrustRelationships()) {
            if (!trustRelationship.equals((Object)this.getTrustContainerFederation(trust))) continue;
            result.add(trust);
        }
        return result;
    }

    public List<GluuSAMLTrustRelationship> getChildTrusts(GluuSAMLTrustRelationship trustRelationship) {
        List<GluuSAMLTrustRelationship> all = this.getAllTrustRelationships();
        if (all != null && !all.isEmpty()) {
            return all.stream().filter(e -> !e.isFederation()).filter(e -> e.getGluuContainerFederation().equalsIgnoreCase(trustRelationship.getDn())).collect(Collectors.toList());
        }
        return new ArrayList<GluuSAMLTrustRelationship>();
    }

    public GluuSAMLTrustRelationship getTrustByUnpunctuatedInum(String unpunctuated) {
        for (GluuSAMLTrustRelationship trust : this.getAllTrustRelationships()) {
            if (!StringHelper.removePunctuation((String)trust.getInum()).equals(unpunctuated)) continue;
            return trust;
        }
        return null;
    }

    public GluuSAMLTrustRelationship getTrustContainerFederation(GluuSAMLTrustRelationship trustRelationship) {
        GluuSAMLTrustRelationship relationshipByDn = this.getRelationshipByDn(trustRelationship.getDn());
        return relationshipByDn;
    }

    public GluuSAMLTrustRelationship getTrustContainerFederation(String dn) {
        GluuSAMLTrustRelationship relationshipByDn = this.getRelationshipByDn(dn);
        return relationshipByDn;
    }

    public List<GluuSAMLTrustRelationship> searchSAMLTrustRelationships(String pattern, int sizeLimit) {
        String[] targetArray = new String[]{pattern};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, inumFilter});
        return this.persistenceEntryManager.findEntries(this.getDnForTrustRelationShip(null), GluuSAMLTrustRelationship.class, searchFilter, sizeLimit);
    }

    public List<GluuSAMLTrustRelationship> getAllSAMLTrustRelationships(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForTrustRelationShip(null), GluuSAMLTrustRelationship.class, null, sizeLimit);
    }

    public boolean removeAttribute(GluuAttribute attribute) {
        this.log.trace("Removing attribute from trustRelationships");
        List<GluuSAMLTrustRelationship> trustRelationships = this.getAllTrustRelationships();
        this.log.trace(String.format("Iterating '%d' trustRelationships", trustRelationships.size()));
        block0: for (GluuSAMLTrustRelationship trustRelationship : trustRelationships) {
            this.log.trace("Analyzing '%s'.", (Object)trustRelationship.getDisplayName());
            List customAttrs = trustRelationship.getReleasedAttributes();
            if (customAttrs == null) continue;
            for (String attrDN : customAttrs) {
                this.log.trace("'%s' has custom attribute '%s'", (Object)trustRelationship.getDisplayName(), (Object)attrDN);
                if (!attrDN.equals(attribute.getDn())) continue;
                this.log.trace("'%s' matches '%s'.  deleting it.", (Object)attrDN, (Object)attribute.getDn());
                ArrayList updatedAttrs = new ArrayList();
                updatedAttrs.addAll(customAttrs);
                updatedAttrs.remove(attrDN);
                if (updatedAttrs.size() == 0) {
                    trustRelationship.setReleasedAttributes(null);
                } else {
                    trustRelationship.setReleasedAttributes(updatedAttrs);
                }
                this.updateTrustRelationship(trustRelationship);
                continue block0;
            }
        }
        this.attributeService.removeAttribute(attribute);
        return true;
    }

    public TrustContact getTrustContactFromString(String data) {
        JsonNode rootNode;
        if (data == null) {
            return null;
        }
        if (data.startsWith("<")) {
            try {
                Document doc = this.xmlService.getXmlDocument(data, true);
                String name = this.xmlService.getNodeValue(doc, "/trustContact/name", null);
                String mail = this.xmlService.getNodeValue(doc, "/trustContact/mail", null);
                String phone = this.xmlService.getNodeValue(doc, "/trustContact/phone", null);
                String title = this.xmlService.getNodeValue(doc, "/trustContact/title", null);
                TrustContact trustContact = new TrustContact();
                trustContact.setName(name);
                trustContact.setPhone(mail);
                trustContact.setMail(phone);
                trustContact.setTitle(title);
                return trustContact;
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
                this.log.error("Failed to create TrustContact from XML {}", (Object)ex, (Object)data);
                return null;
            }
        }
        try {
            rootNode = this.objectMapper.readTree(data);
        }
        catch (IOException ex) {
            this.log.error("Failed to create TrustContact from JSON {}", (Object)ex, (Object)data);
            return null;
        }
        TrustContact trustContact = new TrustContact();
        if (rootNode.hasNonNull("name")) {
            trustContact.setName(rootNode.get("name").asText());
        }
        if (rootNode.hasNonNull("phone")) {
            trustContact.setPhone(rootNode.get("phone").asText());
        }
        if (rootNode.hasNonNull("mail")) {
            trustContact.setMail(rootNode.get("mail").asText());
        }
        if (rootNode.hasNonNull("title")) {
            trustContact.setTitle(rootNode.get("title").asText());
        }
        return trustContact;
    }

    public String getStringFromTrustContact(TrustContact contact) {
        if (contact == null) {
            return null;
        }
        ObjectNode rootNode = this.objectMapper.createObjectNode();
        if (StringHelper.isNotEmpty((String)contact.getName())) {
            rootNode.put("name", contact.getName());
        }
        if (StringHelper.isNotEmpty((String)contact.getPhone())) {
            rootNode.put("phone", contact.getPhone());
        }
        if (StringHelper.isNotEmpty((String)contact.getMail())) {
            rootNode.put("mail", contact.getMail());
        }
        if (StringHelper.isNotEmpty((String)contact.getTitle())) {
            rootNode.put("title", contact.getTitle());
        }
        return rootNode.toString();
    }
}

