/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.gluu.oxtrust.model.GluuSAMLTrustRelationship;
import org.gluu.oxtrust.service.SamlAcrService;
import org.gluu.oxtrust.service.Shibboleth3ConfService;
import org.gluu.oxtrust.service.TrustService;
import org.gluu.oxtrust.util.CASProtocolConfiguration;

@ApplicationScoped
public class ShibbolethService {
    private static final String IDP_SESSION_STORAGESERVICE = "idp.session.StorageService";
    private static final String IDP_CAS_STORAGESERVICE = "idp.cas.StorageService";
    private static final String CLIENT_SESSION_STORAGESERVICE = "shibboleth.ClientSessionStorageService";
    @Inject
    private Shibboleth3ConfService shibboleth3ConfService;
    @Inject
    private TrustService trustService;
    @Inject
    private SamlAcrService samlAcrService;

    public void update(CASProtocolConfiguration casProtocolConfiguration) {
        try {
            if (casProtocolConfiguration.isShibbolethEnabled()) {
                this.enable(casProtocolConfiguration);
            } else {
                this.disable(casProtocolConfiguration);
            }
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void enable(CASProtocolConfiguration casProtocolConfiguration) throws ConfigurationException {
        PropertiesConfigurationLayout layoutConfiguration = this.idpPropertiesLayout();
        layoutConfiguration.getConfiguration().setProperty(IDP_SESSION_STORAGESERVICE, (Object)casProtocolConfiguration.getConfiguration().getSessionStorageType());
        layoutConfiguration.getConfiguration().setProperty(IDP_CAS_STORAGESERVICE, (Object)casProtocolConfiguration.getConfiguration().getSessionStorageType());
        layoutConfiguration.getConfiguration().save();
        this.updateShibboleth3Configuration();
    }

    private void disable(CASProtocolConfiguration casProtocolConfiguration) throws ConfigurationException {
        PropertiesConfigurationLayout layoutConfiguration = this.idpPropertiesLayout();
        layoutConfiguration.getConfiguration().setProperty(IDP_SESSION_STORAGESERVICE, (Object)CLIENT_SESSION_STORAGESERVICE);
        layoutConfiguration.getConfiguration().setProperty(IDP_CAS_STORAGESERVICE, (Object)casProtocolConfiguration.getConfiguration().getSessionStorageType());
        layoutConfiguration.getConfiguration().save();
        this.updateShibboleth3Configuration();
    }

    private PropertiesConfigurationLayout idpPropertiesLayout() throws ConfigurationException {
        String idpConfFolder = this.shibboleth3ConfService.getIdpConfDir();
        PropertiesConfiguration idpPropertiesConfiguration = new PropertiesConfiguration(idpConfFolder + "idp.properties");
        return new PropertiesConfigurationLayout(idpPropertiesConfiguration);
    }

    private void updateShibboleth3Configuration() {
        List<GluuSAMLTrustRelationship> trustRelationships = this.trustService.getAllActiveTrustRelationships();
        this.shibboleth3ConfService.generateConfigurationFiles(trustRelationships);
        this.shibboleth3ConfService.generateConfigurationFiles(this.samlAcrService.getAll());
    }
}

