/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.gluu.config.oxtrust.AppConfiguration;
import org.gluu.config.oxtrust.AttributeResolverConfiguration;
import org.gluu.config.oxtrust.NameIdConfig;
import org.gluu.config.oxtrust.ShibbolethCASProtocolConfiguration;
import org.gluu.model.GluuAttribute;
import org.gluu.model.GluuStatus;
import org.gluu.model.GluuUserRole;
import org.gluu.model.SchemaEntry;
import org.gluu.oxtrust.model.GluuMetadataSourceType;
import org.gluu.oxtrust.model.GluuSAMLFederationProposal;
import org.gluu.oxtrust.model.GluuSAMLTrustRelationship;
import org.gluu.oxtrust.model.MetadataFilter;
import org.gluu.oxtrust.model.SamlAcr;
import org.gluu.oxtrust.service.AttributeService;
import org.gluu.oxtrust.service.CASService;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.oxtrust.service.EncryptionService;
import org.gluu.oxtrust.service.FilterService;
import org.gluu.oxtrust.service.PersonService;
import org.gluu.oxtrust.service.ProfileConfigurationService;
import org.gluu.oxtrust.service.TemplateService;
import org.gluu.oxtrust.service.TrustService;
import org.gluu.oxtrust.util.EasyCASSLProtocolSocketFactory;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.saml.metadata.SAMLMetadataParser;
import org.gluu.service.SchemaService;
import org.gluu.service.XmlService;
import org.gluu.service.config.ConfigurationFactory;
import org.gluu.service.document.store.conf.DocumentStoreType;
import org.gluu.service.document.store.service.DocumentStoreService;
import org.gluu.service.document.store.service.LocalDocumentStoreService;
import org.gluu.util.INumGenerator;
import org.gluu.util.StringHelper;
import org.gluu.util.Util;
import org.gluu.util.exception.InvalidConfigurationException;
import org.gluu.util.io.HTTPFileDownloader;
import org.gluu.util.security.StringEncrypter;
import org.gluu.xml.GluuErrorHandler;
import org.gluu.xml.XMLValidator;
import org.opensaml.saml.common.xml.SAMLSchemaBuilder;
import org.opensaml.xml.parse.XMLParserException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@ApplicationScoped
public class Shibboleth3ConfService
implements Serializable {
    private static final long serialVersionUID = 6752452480800274694L;
    private static final String SHIB3_IDP_CONF_FOLDER = "conf";
    private static final String SHIB3_IDP_AUNTHN_FOLDER = "authn";
    public static final String SHIB3_IDP_METADATA_FOLDER = "metadata";
    private static final String SHIB_IDP_ATTRIBUTES_FOLDER = "attributes";
    private static final String SHIB3_IDP_METADATA_PROVIDERS_FILE = "metadata-providers.xml";
    private static final String SHIB3_IDP_ATTRIBUTE_FILTER_FILE = "attribute-filter.xml";
    private static final String SHIB3_IDP_ATTRIBUTE_RESOLVER_FILE = "attribute-resolver.xml";
    private static final String SHIB3_IDP_RELYING_PARTY_FILE = "relying-party.xml";
    private static final String SHIB3_IDP_CAS_PROTOCOL_FILE = "cas-protocol.xml";
    public static final String SHIB3_IDP_IDP_METADATA_FILE = "idp-metadata.xml";
    public static final String SHIB3_IDP_SP_METADATA_FILE = "sp-metadata.xml";
    private static final String SHIB_IDP_GLUU_ATTRIBUTE_RULES_FILE = "gluu-attribute-rules.xml";
    public static final String SHIB3_SP_ATTRIBUTE_MAP_FILE = "attribute-map.xml";
    public static final String SHIB3_SP_SHIBBOLETH2_FILE = "shibboleth2.xml";
    private static final String SHIB3_SP_READ_ME = "/WEB-INF/resources/doc/README_SP.pdf";
    private static final String SHIB3_SP_READ_ME_WINDOWS = "/WEB-INF/resources/doc/README_SP_windows.pdf";
    private static final String SHIB3_SAML_NAMEID_FILE = "saml-nameid.xml";
    private static final String SHIB3_SAML_NAMEID_PROPS_FILE = "saml-nameid.properties";
    private static final String SHIB3_SP_METADATA_FILE_PATTERN = "%s-sp-metadata.xml";
    public static final String PUBLIC_CERTIFICATE_START_LINE = "-----BEGIN CERTIFICATE-----";
    public static final String PUBLIC_CERTIFICATE_END_LINE = "-----END CERTIFICATE-----";
    public static final String SHIB3_IDP_PROPERTIES_FILE = "idp.properties";
    private static final String SHIB3_IDP_LOGIN_CONFIG_FILE = "login.config";
    private static final String SHIB3_METADATA_FILE_PATTERN = "%s-metadata.xml";
    public static final String SHIB3_IDP_TEMPMETADATA_FOLDER = "temp_metadata";
    public static final String SHIB3_IDP_SP_KEY_FILE = "spkey.key";
    public static final String SHIB3_IDP_SP_CERT_FILE = "spcert.crt";
    public static final String GLUU_SAML_OXAUTH_SUPPORTED_PRINCIPALS_FILE = "oxauth-supported-principals.xml";
    Charset UTF_8 = Charset.forName("utf-8");
    @Inject
    private AttributeService attributeService;
    @Inject
    private TemplateService templateService;
    @Inject
    private Logger log;
    @Inject
    private FilterService filterService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory<?> configurationFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private EncryptionService encryptionService;
    @Inject
    private XmlService xmlService;
    @Inject
    private ProfileConfigurationService profileConfigurationService;
    @Inject
    private CASService casService;
    @Inject
    private SchemaService shemaService;
    @Inject
    private TrustService trustService;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private PersonService personService;
    @Inject
    private SAMLMetadataParser samlMetadataParser;
    @Inject
    private DocumentStoreService documentStoreService;
    @Inject
    private LocalDocumentStoreService localDocumentStoreService;
    private Schema samlSchema;

    @PostConstruct
    public void create() {
        SAMLSchemaBuilder samlSchemaBuilder = new SAMLSchemaBuilder(SAMLSchemaBuilder.SAML1Version.SAML_11);
        try {
            this.samlSchema = samlSchemaBuilder.getSAMLSchema();
        }
        catch (SAXException ex) {
            this.log.error("Failed to load SAML schema", (Throwable)ex);
        }
    }

    public boolean generateConfigurationFiles(SamlAcr[] acrs) {
        this.log.info(">>>>>>>>>> IN generateConfigurationFiles(SamlAcr[] acrs)...");
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            throw new InvalidConfigurationException("Failed to update configuration due to undefined IDP root folder");
        }
        String idpConfAuthnFolder = this.getIdpConfAuthnDir();
        ArrayList<String> acrs2 = new ArrayList<String>();
        for (SamlAcr acr : acrs) {
            acrs2.add(acr.getClassRef());
        }
        VelocityContext context = new VelocityContext();
        context.put("acrs", acrs2);
        String oxAuthSupportedPrincipals = this.generateConfFile(GLUU_SAML_OXAUTH_SUPPORTED_PRINCIPALS_FILE, context);
        boolean result = this.writeConfFile(idpConfAuthnFolder + GLUU_SAML_OXAUTH_SUPPORTED_PRINCIPALS_FILE, oxAuthSupportedPrincipals);
        this.log.info(">>>>>>>>>> LEAVING generateConfigurationFiles(SamlAcr[] acrs)...");
        return result;
    }

    public boolean generateGluuAttributeRulesFile() {
        List attributes = this.attributeService.getAllAttributes();
        return this.generateGluuAttributeRulesFile(attributes);
    }

    public boolean generateGluuAttributeRulesFile(List<GluuAttribute> attributes) {
        boolean ret = false;
        this.log.info(">>>>>>>>>> IN Shibboleth3ConfService.generateGluuAttributeRulesFile() ...");
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            throw new InvalidConfigurationException("Failed to update configuration due to undefined IDP root folder");
        }
        VelocityContext context = new VelocityContext();
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (GluuAttribute attribute : attributes) {
            attributeNames.add(attribute.getName());
        }
        SchemaEntry schemaEntry = this.shemaService.getSchema();
        List attributeTypes = this.shemaService.getAttributeTypeDefinitions(schemaEntry, attributeNames);
        HashMap<String, String> attributeSaml1Strings = new HashMap<String, String>();
        HashMap<String, String> attributeSaml2Strings = new HashMap<String, String>();
        for (GluuAttribute metadata : attributes) {
            String attributeName = metadata.getName();
            String saml1String = metadata.getSaml1Uri();
            if (StringHelper.isEmpty((String)saml1String)) {
                boolean standard = metadata.isCustom() || StringHelper.isEmpty((String)metadata.getUrn()) || !StringHelper.isEmpty((String)metadata.getUrn()) && metadata.getUrn().startsWith("urn:gluu:dir:attribute-def:");
                saml1String = String.format("urn:%s:dir:attribute-def:%s", standard ? "gluu" : "mace", attributeName);
            }
            attributeSaml1Strings.put(attributeName, saml1String);
            String saml2String = metadata.getSaml2Uri();
            if (StringHelper.isEmpty((String)saml2String)) {
                AttributeTypeDefinition attributeTypeDefinition = this.shemaService.getAttributeTypeDefinition(attributeTypes, attributeName);
                if (attributeTypeDefinition == null) {
                    this.log.error("Failed to get OID for attribute name {}", (Object)attributeName);
                    return false;
                }
                saml2String = String.format("urn:oid:%s", attributeTypeDefinition.getOID());
            }
            attributeSaml2Strings.put(attributeName, saml2String);
        }
        context.put(SHIB_IDP_ATTRIBUTES_FOLDER, attributes);
        context.put("attributeSaml1Strings", attributeSaml1Strings);
        context.put("attributeSaml2Strings", attributeSaml2Strings);
        String gluuAttributesRules = this.generateConfFile(SHIB_IDP_GLUU_ATTRIBUTE_RULES_FILE, context);
        this.log.info("Gluu attributes rules file path is {}", (Object)this.getGluuAttributesRulesFilePath());
        ret = this.writeConfFile(this.getGluuAttributesRulesFilePath(), gluuAttributesRules);
        this.log.info(">>>>>>>>>>> LEAVING Shibboleth3ConfService.generateGluuAttributeRulesFile() ...");
        return ret;
    }

    public boolean generateConfigurationFiles(List<GluuSAMLTrustRelationship> trustRelationships) {
        boolean result;
        this.log.info(">>>>>>>>>> IN Shibboleth3ConfService.generateConfigurationFiles()...");
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            throw new InvalidConfigurationException("Failed to update configuration due to undefined IDP root folder");
        }
        String idpConfFolder = this.getIdpConfDir();
        String idpMetadataFolder = this.getIdpMetadataDir();
        this.initAttributes(trustRelationships);
        HashMap<String, Object> trustParams = this.initTrustParamMap(trustRelationships);
        HashMap<String, Object> attrParams = this.initAttributeParamMap(trustRelationships);
        HashMap<String, Object> casParams = this.initCASParamMap();
        HashMap<String, Object> attrResolverParams = this.initAttributeResolverParamMap();
        for (String key : attrParams.keySet()) {
            attrResolverParams.remove(key);
        }
        boolean bl = result = trustParams != null && attrParams != null && casParams != null && attrResolverParams != null;
        if (!result) {
            this.log.error(">>>>>>>>>> Shibboleth3ConfService.generateConfigurationFiles() - params preparation failed, break files generation");
            return result;
        }
        VelocityContext context = this.prepareVelocityContext(trustParams, attrParams, casParams, attrResolverParams, idpMetadataFolder);
        String metadataProviders = this.generateConfFile(SHIB3_IDP_METADATA_PROVIDERS_FILE, context);
        String attributeResolver = this.generateConfFile(SHIB3_IDP_ATTRIBUTE_RESOLVER_FILE, context);
        String attributeFilter = this.generateConfFile(SHIB3_IDP_ATTRIBUTE_FILTER_FILE, context);
        String relyingParty = this.generateConfFile(SHIB3_IDP_RELYING_PARTY_FILE, context);
        String casProtocol = this.generateConfFile(SHIB3_IDP_CAS_PROTOCOL_FILE, context);
        String shibConfig = this.generateConfFile(SHIB3_SP_SHIBBOLETH2_FILE, context);
        String samlnamedConfig = this.generateConfFile(SHIB3_SAML_NAMEID_FILE, context);
        String samlnamedPropsConfig = this.generateConfFile(SHIB3_SAML_NAMEID_PROPS_FILE, context);
        result = metadataProviders != null && attributeFilter != null && attributeResolver != null && relyingParty != null && casProtocol != null && shibConfig != null;
        result &= this.writeConfFile(idpConfFolder + SHIB3_IDP_METADATA_PROVIDERS_FILE, metadataProviders);
        result &= this.writeConfFile(idpConfFolder + SHIB3_IDP_ATTRIBUTE_RESOLVER_FILE, attributeResolver);
        result &= this.writeConfFile(idpConfFolder + SHIB3_IDP_ATTRIBUTE_FILTER_FILE, attributeFilter);
        result &= this.writeConfFile(idpConfFolder + SHIB3_IDP_RELYING_PARTY_FILE, relyingParty);
        result &= this.writeConfFile(idpConfFolder + SHIB3_IDP_CAS_PROTOCOL_FILE, casProtocol);
        result &= this.writeConfFile(this.getSpShibboleth3FilePath(), shibConfig);
        result &= this.writeConfFile(idpConfFolder + SHIB3_SAML_NAMEID_FILE, samlnamedConfig);
        this.log.info(">>>>>>>>>> LEAVING Shibboleth3ConfService.generateConfigurationFiles()...");
        return result &= this.writeConfFile(idpConfFolder + SHIB3_SAML_NAMEID_PROPS_FILE, samlnamedPropsConfig);
    }

    private void initAttributes(List<GluuSAMLTrustRelationship> trustRelationships) {
        List<GluuAttribute> attributes = this.attributeService.getAllPersonAttributes(GluuUserRole.ADMIN);
        HashMap<String, GluuAttribute> attributesByDNs = this.attributeService.getAttributeMapByDNs(attributes);
        GluuAttribute uid = this.attributeService.getAttributeByName("uid");
        for (GluuSAMLTrustRelationship trustRelationship : trustRelationships) {
            List oldAttributes = trustRelationship.getReleasedAttributes();
            ArrayList<String> releasedAttributes = new ArrayList<String>();
            if (oldAttributes != null) {
                releasedAttributes.addAll(oldAttributes);
            }
            if (uid != null && releasedAttributes.remove(uid.getDn())) {
                releasedAttributes.add(0, uid.getDn());
            }
            trustRelationship.setReleasedCustomAttributes(this.attributeService.getCustomAttributesByAttributeDNs(releasedAttributes, attributesByDNs));
            this.attributeService.setAttributeMetadata(trustRelationship.getReleasedCustomAttributes(), attributes);
        }
    }

    private HashMap<String, Object> initTrustParamMap(List<GluuSAMLTrustRelationship> trustRelationships) {
        this.log.trace("Starting trust parameters map initialization.");
        HashMap<String, Object> trustParams = new HashMap<String, Object>();
        ArrayList trustEngines = new ArrayList();
        HashMap<String, String> trustIds = new HashMap<String, String>();
        ArrayList<GluuSAMLTrustRelationship> deconstructed = new ArrayList<GluuSAMLTrustRelationship>();
        HashMap<String, String> deconstructedIds = new HashMap<String, String>();
        HashMap deconstructedMap = new HashMap();
        HashMap<String, List> trustEntityIds = new HashMap<String, List>();
        int id = 1;
        for (GluuSAMLTrustRelationship trustRelationship : trustRelationships) {
            boolean isPartOfFederation;
            boolean bl = isPartOfFederation = !trustRelationship.getSpMetaDataSourceType().equals((Object)GluuMetadataSourceType.URI) && !trustRelationship.getSpMetaDataSourceType().equals((Object)GluuMetadataSourceType.FILE);
            if (!isPartOfFederation) {
                trustIds.put(trustRelationship.getInum(), String.valueOf(id++));
                String idpMetadataFolder = this.getIdpMetadataDir();
                String metadataFile = idpMetadataFolder + trustRelationship.getSpMetaDataFN();
                List entityIds = this.samlMetadataParser.getEntityIdFromMetadataFile(metadataFile);
                if (entityIds == null) {
                    trustRelationship.setStatus(GluuStatus.INACTIVE);
                    this.trustService.updateTrustRelationship(trustRelationship);
                    continue;
                }
                trustEntityIds.put(trustRelationship.getInum(), entityIds);
                this.initProfileConfiguration(trustRelationship);
                if (trustRelationship.getMetadataFilters().get("signatureValidation") != null) {
                    HashMap<String, String> trustEngine = new HashMap<String, String>();
                    trustEngine.put("id", "Trust" + StringHelper.removePunctuation((String)trustRelationship.getInum()));
                    trustEngine.put("certPath", this.getIdpMetadataDir() + "credentials" + File.separator + ((MetadataFilter)trustRelationship.getMetadataFilters().get("signatureValidation")).getFilterCertFileName());
                    trustEngines.add(trustEngine);
                }
                if (trustRelationship.getGluuSAMLMetaDataFilter() == null) continue;
                ArrayList<String> filtersList = new ArrayList<String>();
                String entityRoleWhiteList = null;
                for (String filterXML : trustRelationship.getGluuSAMLMetaDataFilter()) {
                    Document xmlDocument;
                    try {
                        xmlDocument = this.xmlService.getXmlDocument(filterXML.getBytes());
                    }
                    catch (Exception e) {
                        this.log.error("GluuSAMLMetaDataFilter contains invalid value.", (Throwable)e);
                        e.printStackTrace();
                        continue;
                    }
                    if (xmlDocument.getFirstChild().getAttributes().getNamedItem("xsi:type").getNodeValue().equals(FilterService.ENTITY_ROLE_WHITE_LIST_TYPE)) {
                        entityRoleWhiteList = filterXML;
                        continue;
                    }
                    filtersList.add(filterXML);
                }
                if (entityRoleWhiteList != null) {
                    filtersList.add(entityRoleWhiteList);
                }
                trustRelationship.setGluuSAMLMetaDataFilter(filtersList);
                continue;
            }
            this.initProfileConfiguration(trustRelationship);
            String federationInum = trustRelationship.getGluuContainerFederation();
            if (deconstructedMap.get(federationInum) == null) {
                deconstructedMap.put(federationInum, new ArrayList());
            }
            ((List)deconstructedMap.get(federationInum)).add(trustRelationship.getEntityId());
            deconstructed.add(trustRelationship);
            deconstructedIds.put(trustRelationship.getEntityId(), String.valueOf(id++));
        }
        for (String trustRelationshipInum : trustEntityIds.keySet()) {
            List federatedSites = (List)deconstructedMap.get(trustRelationshipInum);
            if (federatedSites == null) continue;
            ((List)trustEntityIds.get(trustRelationshipInum)).removeAll(federatedSites);
        }
        trustParams.put("idpCredentialsPath", this.getIdpMetadataDir() + "credentials" + File.separator);
        trustParams.put("deconstructed", deconstructed);
        trustParams.put("deconstructedIds", deconstructedIds);
        trustParams.put("trustEngines", trustEngines);
        trustParams.put("trusts", trustRelationships);
        trustParams.put("trustIds", trustIds);
        trustParams.put("trustEntityIds", trustEntityIds);
        return trustParams;
    }

    protected void initProfileConfiguration(GluuSAMLTrustRelationship trustRelationship) throws FactoryConfigurationError {
        try {
            this.filterService.parseFilters(trustRelationship);
            this.profileConfigurationService.parseProfileConfigurations(trustRelationship);
        }
        catch (Exception e) {
            this.log.error("Failed to parse stored metadataFilter configuration for trustRelationship " + trustRelationship.getDn(), (Throwable)e);
        }
    }

    private HashMap<String, Object> initAttributeParamMap(List<GluuSAMLTrustRelationship> trustRelationships) {
        HashMap attrParams = new HashMap();
        HashSet<GluuAttribute> attributes = new HashSet<GluuAttribute>();
        trustRelationships.stream().forEach(tr -> tr.getReleasedCustomAttributes().stream().forEach(ca -> attributes.add(ca.getMetadata())));
        return this.createAttributeMap(attributes);
    }

    private HashMap<String, Object> createAttributeMap(Set<GluuAttribute> attributes) {
        HashMap<String, Object> resolver = new HashMap<String, Object>();
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (GluuAttribute attribute : attributes) {
            attributeNames.add(attribute.getName());
        }
        SchemaEntry schemaEntry = this.shemaService.getSchema();
        List attributeTypes = this.shemaService.getAttributeTypeDefinitions(schemaEntry, attributeNames);
        HashMap<String, String> attributeSAML1Strings = new HashMap<String, String>();
        HashMap<String, String> attributeSAML2Strings = new HashMap<String, String>();
        for (GluuAttribute metadata : attributes) {
            String attributeName = metadata.getName();
            String saml1String = metadata.getSaml1Uri();
            if (StringHelper.isEmpty((String)saml1String)) {
                boolean standard = metadata.isCustom() || StringHelper.isEmpty((String)metadata.getUrn()) || !StringHelper.isEmpty((String)metadata.getUrn()) && metadata.getUrn().startsWith("urn:gluu:dir:attribute-def:");
                saml1String = String.format("urn:%s:dir:attribute-def:%s", standard ? "gluu" : "mace", attributeName);
            }
            attributeSAML1Strings.put(attributeName, saml1String);
            String saml2String = metadata.getSaml2Uri();
            if (StringHelper.isEmpty((String)saml2String)) {
                AttributeTypeDefinition attributeTypeDefinition = this.shemaService.getAttributeTypeDefinition(attributeTypes, attributeName);
                if (attributeTypeDefinition == null) {
                    this.log.error("Failed to get OID for attribute name {}", (Object)attributeName);
                    return null;
                }
                saml2String = String.format("urn:oid:%s", attributeTypeDefinition.getOID());
            }
            attributeSAML2Strings.put(attributeName, saml2String);
        }
        resolver.put(SHIB_IDP_ATTRIBUTES_FOLDER, attributes);
        resolver.put("attributeSAML1Strings", attributeSAML1Strings);
        resolver.put("attributeSAML2Strings", attributeSAML2Strings);
        return resolver;
    }

    private HashMap<String, Object> initCASParamMap() {
        HashMap<String, Object> casParams = new HashMap<String, Object>();
        try {
            ShibbolethCASProtocolConfiguration configuration = this.casService.loadCASConfiguration();
            if (configuration != null) {
                this.log.info("add ShibbolethCASProtocolConfiguration parameters");
                casParams.put("enabled", configuration.isEnabled());
                casParams.put("extended", configuration.isExtended());
                casParams.put("enableToProxyPatterns", configuration.isEnableToProxyPatterns());
                casParams.put("authorizedToProxyPattern", configuration.getAuthorizedToProxyPattern());
                casParams.put("unauthorizedToProxyPattern", configuration.getAuthorizedToProxyPattern());
            }
        }
        catch (Exception e) {
            this.log.error("initCASParamMap() exception", (Throwable)e);
        }
        return casParams;
    }

    public HashMap<String, Object> initAttributeResolverParamMap() {
        ArrayList<NameIdConfig> nameIdConfigs = new ArrayList<NameIdConfig>();
        HashSet<GluuAttribute> nameIdAttributes = new HashSet<GluuAttribute>();
        AttributeResolverConfiguration attributeResolverConfiguration = this.configurationFactory.getAttributeResolverConfiguration();
        if (attributeResolverConfiguration != null && attributeResolverConfiguration.getNameIdConfigs() != null) {
            for (NameIdConfig nameIdConfig : attributeResolverConfiguration.getNameIdConfigs()) {
                if (!StringHelper.isNotEmpty((String)nameIdConfig.getSourceAttribute()) || !nameIdConfig.isEnabled()) continue;
                String attributeName = nameIdConfig.getSourceAttribute();
                GluuAttribute attribute = this.attributeService.getAttributeByName(attributeName);
                nameIdConfigs.add(nameIdConfig);
                nameIdAttributes.add(attribute);
            }
        }
        HashMap<String, Object> attributeResolverParams = this.createAttributeMap(nameIdAttributes);
        attributeResolverParams.put("configs", nameIdConfigs);
        attributeResolverParams.put(SHIB_IDP_ATTRIBUTES_FOLDER, nameIdAttributes);
        String baseUserDn = this.personService.getDnForPerson(null);
        String persistenceType = this.persistenceEntryManager.getPersistenceType(baseUserDn);
        this.log.debug(">>>>>>>>>> Shibboleth3ConfService.initAttributeResolverParamMap() - Persistance type: '{}'", (Object)persistenceType);
        attributeResolverParams.put("persistenceType", persistenceType);
        return attributeResolverParams;
    }

    private VelocityContext prepareVelocityContext(HashMap<String, Object> trustParams, HashMap<String, Object> attrParams, HashMap<String, Object> casParams, HashMap<String, Object> attrResolverParams, String idpMetadataFolder) {
        VelocityContext context = new VelocityContext();
        context.put("StringHelper", StringHelper.class);
        context.put("salt", (Object)this.configurationFactory.getCryptoConfigurationSalt());
        context.put("trustParams", trustParams);
        context.put("attrParams", attrParams);
        context.put("casParams", casParams);
        context.put("resovlerParams", attrResolverParams);
        context.put("medataFolder", (Object)idpMetadataFolder);
        context.put("orgInum", (Object)StringHelper.removePunctuation((String)"gluu"));
        context.put("orgSupportEmail", (Object)this.appConfiguration.getOrgSupportEmail());
        String idpUrl = this.appConfiguration.getIdpUrl();
        context.put("idpUrl", (Object)idpUrl);
        String idpHost = idpUrl.replaceAll(":[0-9]*$", "");
        context.put("idpHost", (Object)idpHost);
        String spUrl = this.appConfiguration.getApplicationUrl();
        context.put("spUrl", (Object)spUrl);
        String spHost = spUrl.replaceAll(":[0-9]*$", "").replaceAll("^.*?//", "");
        context.put("spHost", (Object)spHost);
        String gluuSPInum = this.configurationService.getConfiguration().getGluuSPTR();
        GluuSAMLTrustRelationship gluuSP = this.trustService.getRelationshipByInum(gluuSPInum);
        if (gluuSP == null) {
            gluuSP = new GluuSAMLTrustRelationship();
        }
        String gluuSPEntityId = gluuSP.getEntityId();
        context.put("gluuSPEntityId", (Object)gluuSPEntityId);
        String regx = "\\s*(=>|,|\\s)\\s*";
        String[] ldapUrls = this.appConfiguration.getIdpLdapServer().split(regx);
        String ldapUrl = "";
        if (ldapUrls != null) {
            for (String ldapServer : ldapUrls) {
                if (ldapUrl.length() > 1) {
                    ldapUrl = ldapUrl + " ";
                }
                ldapUrl = ldapUrl + this.appConfiguration.getIdpLdapProtocol() + "://" + ldapServer;
            }
        } else {
            ldapUrl = this.appConfiguration.getIdpLdapProtocol() + "://" + this.appConfiguration.getIdpLdapServer();
        }
        context.put("ldapUrl", (Object)ldapUrl);
        context.put("bindDN", (Object)this.appConfiguration.getIdpBindDn());
        try {
            context.put("ldapPass", (Object)this.encryptionService.decrypt(this.appConfiguration.getIdpBindPassword()));
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error("Failed to decrypt bindPassword", (Throwable)e);
            e.printStackTrace();
        }
        context.put("securityKey", (Object)this.appConfiguration.getIdpSecurityKey());
        context.put("securityCert", (Object)this.appConfiguration.getIdpSecurityCert());
        try {
            context.put("securityKeyPassword", (Object)this.encryptionService.decrypt(this.appConfiguration.getIdpSecurityKeyPassword()));
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error("Failed to decrypt idp.securityKeyPassword", (Throwable)e);
            e.printStackTrace();
        }
        return context;
    }

    public String getIdpMetadataFilePath() {
        return this.getIdpMetadataDir() + SHIB3_IDP_IDP_METADATA_FILE;
    }

    public String getIdpConfAuthnDir() {
        return this.appConfiguration.getShibboleth3IdpRootDir() + File.separator + SHIB3_IDP_CONF_FOLDER + File.separator + SHIB3_IDP_AUNTHN_FOLDER + File.separator;
    }

    public String getIdpConfDir() {
        return this.appConfiguration.getShibboleth3IdpRootDir() + File.separator + SHIB3_IDP_CONF_FOLDER + File.separator;
    }

    public String getIdpMetadataDir() {
        return this.appConfiguration.getShibboleth3IdpRootDir() + File.separator + SHIB3_IDP_METADATA_FOLDER + File.separator;
    }

    public String getIdpMetadataTempDir() {
        return this.appConfiguration.getShibboleth3IdpRootDir() + File.separator + SHIB3_IDP_TEMPMETADATA_FOLDER + File.separator;
    }

    public String getIdpAttributesDir() {
        return this.appConfiguration.getShibboleth3IdpRootDir() + File.separator + SHIB3_IDP_CONF_FOLDER + File.separator + SHIB_IDP_ATTRIBUTES_FOLDER + File.separator;
    }

    public String getGluuAttributesRulesFilePath() {
        return this.getIdpAttributesDir() + SHIB_IDP_GLUU_ATTRIBUTE_RULES_FILE;
    }

    public String getSpMetadataFilePath(String spMetaDataFN) {
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            throw new InvalidConfigurationException("Failed to return SP meta-data file due to undefined IDP root folder");
        }
        String idpMetadataFolder = this.getIdpMetadataDir();
        return idpMetadataFolder + spMetaDataFN;
    }

    public String getSpNewMetadataFileName(GluuSAMLTrustRelationship trustRel) {
        return this.getSpNewMetadataFileName(trustRel.getInum());
    }

    public String getSpNewMetadataFileName(String inum) {
        String relationshipInum = StringHelper.removePunctuation((String)inum);
        return String.format(SHIB3_SP_METADATA_FILE_PATTERN, relationshipInum);
    }

    public String saveSpMetadataFile(String spMetadataFileName, byte[] data) {
        String string;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        try {
            string = this.saveSpMetadataFile(spMetadataFileName, bis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidConfigurationException((Throwable)e);
            }
        }
        bis.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveSpMetadataFile(String spMetadataFileName, InputStream stream) {
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            throw new InvalidConfigurationException("Failed to save SP meta-data file due to undefined IDP root folder");
        }
        String idpMetadataTempFolder = this.getIdpMetadataTempDir();
        String tempFileName = this.getTempMetadataFilename(idpMetadataTempFolder, spMetadataFileName);
        String spMetadataFile = idpMetadataTempFolder + tempFileName;
        try {
            boolean result = this.documentStoreService.saveDocumentStream(spMetadataFile, stream);
            if (result) {
                String string = tempFileName;
                return string;
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to write SP meta-data file '{}'", (Object)spMetadataFile, (Object)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTempMetadataFilename(String idpMetadataFolder, String fileName) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            String possibleTemp;
            do {
                possibleTemp = fileName + INumGenerator.generate((int)2);
            } while (this.documentStoreService.hasDocument(idpMetadataFolder + possibleTemp));
            return possibleTemp;
        }
    }

    public String saveSpMetadataFile(String spMetaDataURL, String spMetadataFileName) {
        if (StringHelper.isEmpty((String)spMetaDataURL)) {
            return null;
        }
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            throw new InvalidConfigurationException("Failed to save SP meta-data file due to undefined IDP root folder");
        }
        HTTPFileDownloader.setEasyhttps((Protocol)new Protocol("https", (ProtocolSocketFactory)new EasyCASSLProtocolSocketFactory(), 443));
        String spMetadataFileContent = HTTPFileDownloader.getResource((String)spMetaDataURL, (String)"application/xml, text/xml", null, null);
        if (StringHelper.isEmpty((String)spMetadataFileContent)) {
            return null;
        }
        String idpMetadataTempFolder = this.getIdpMetadataTempDir();
        String tempFileName = this.getTempMetadataFilename(idpMetadataTempFolder, spMetadataFileName);
        String spMetadataFile = idpMetadataTempFolder + tempFileName;
        try {
            boolean result = this.documentStoreService.saveDocument(spMetadataFile, spMetadataFileContent, this.UTF_8);
            if (result) {
                return tempFileName;
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to write SP meta-data file '{}'", (Object)spMetadataFile, (Object)ex);
        }
        return null;
    }

    public String generateSpAttributeMapFile(GluuSAMLTrustRelationship trustRelationship) {
        List<GluuSAMLTrustRelationship> trustRelationships = Arrays.asList(trustRelationship);
        this.initAttributes(trustRelationships);
        HashMap<String, Object> attrParams = this.initAttributeParamMap(trustRelationships);
        if (attrParams == null) {
            return null;
        }
        VelocityContext context = this.prepareVelocityContext(null, attrParams, null, null, null);
        String spAttributeMap = this.generateConfFile(SHIB3_SP_ATTRIBUTE_MAP_FILE, context);
        return spAttributeMap;
    }

    public boolean generateSpMetadataFile(GluuSAMLTrustRelationship trustRelationship, String certificate) {
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            throw new InvalidConfigurationException("Failed to generate SP meta-data file due to undefined IDP root folder");
        }
        String idpMetadataFolder = this.getIdpMetadataDir();
        String spMetadataFileContent = this.generateSpMetadataFileContent(trustRelationship, certificate);
        if (StringHelper.isEmpty((String)spMetadataFileContent)) {
            return false;
        }
        if (StringHelper.isEmpty((String)trustRelationship.getUrl())) {
            this.log.error("Trust relationship URL is empty");
            return false;
        }
        return this.writeConfFile(idpMetadataFolder + trustRelationship.getSpMetaDataFN(), spMetadataFileContent);
    }

    public String generateSpMetadataFileContent(GluuSAMLTrustRelationship trustRelationship, String certificate) {
        VelocityContext context = new VelocityContext();
        context.put("certificate", (Object)certificate);
        context.put("trustRelationship", (Object)trustRelationship);
        context.put("entityId", (Object)Util.encodeString((String)StringHelper.removePunctuation((String)trustRelationship.getInum())));
        context.put("spHost", (Object)trustRelationship.getUrl().replaceFirst("/$", ""));
        String spMetadataFileContent = this.generateConfFile(SHIB3_IDP_SP_METADATA_FILE, context);
        return spMetadataFileContent;
    }

    public void removeSpMetadataFile(String spMetadataFileName) {
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            throw new InvalidConfigurationException("Failed to remove SP meta-data file due to undefined IDP root folder");
        }
        String spMetadataFile = this.getIdpMetadataDir() + spMetadataFileName;
        try {
            this.documentStoreService.removeDocument(spMetadataFile);
        }
        catch (Exception ex) {
            this.log.error("Failed to remove {}", (Object)spMetadataFile, (Object)ex);
        }
    }

    public boolean isCorrectSpMetadataFile(String spMetadataFileName) {
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            throw new InvalidConfigurationException("Failed to check SP meta-data file due to undefined IDP root folder");
        }
        String metadataFile = this.getIdpMetadataDir() + spMetadataFileName;
        List entityId = this.samlMetadataParser.getSpEntityIdFromMetadataFile(metadataFile);
        return entityId != null && !entityId.isEmpty();
    }

    public String getSpAttributeMapFilePath() {
        return this.appConfiguration.getShibboleth3SpConfDir() + File.separator + SHIB3_SP_ATTRIBUTE_MAP_FILE;
    }

    public String getSpShibboleth3FilePath() {
        return this.appConfiguration.getShibboleth3SpConfDir() + File.separator + SHIB3_SP_SHIBBOLETH2_FILE;
    }

    public String getSpReadMeResourceName() {
        return SHIB3_SP_READ_ME;
    }

    public String getSpReadMeWindowsResourceName() {
        return SHIB3_SP_READ_ME_WINDOWS;
    }

    public String getPublicCertificate(byte[] cert) {
        String string;
        if (cert == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(cert);
        try {
            string = this.getPublicCertificate(bis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        bis.close();
        return string;
    }

    public String getPublicCertificate(InputStream is) {
        String line;
        List lines = null;
        try {
            lines = IOUtils.readLines((Reader)new InputStreamReader(is, "US-ASCII"));
        }
        catch (IOException ex) {
            this.log.error("Failed to read public key file", (Throwable)ex);
            ex.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        boolean keyPart = false;
        Iterator iterator = lines.iterator();
        while (iterator.hasNext() && !(line = (String)iterator.next()).startsWith(PUBLIC_CERTIFICATE_END_LINE)) {
            if (keyPart) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line);
            }
            if (!line.startsWith(PUBLIC_CERTIFICATE_START_LINE)) continue;
            keyPart = true;
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public boolean isFederationMetadata(String spMetaDataFN) {
        if (spMetaDataFN == null) {
            return false;
        }
        String spMetaDataFile = this.getSpMetadataFilePath(spMetaDataFN);
        Document xmlDocument = null;
        try (InputStream is = this.documentStoreService.readDocumentAsStream(spMetaDataFile);
             InputStreamReader isr = new InputStreamReader(is, "UTF-8");){
            try {
                xmlDocument = this.xmlService.getXmlDocument(new InputSource(isr));
            }
            catch (Exception ex) {
                this.log.error("Failed to parse metadata file '{}'", (Object)spMetaDataFile, (Object)ex);
                ex.printStackTrace();
            }
        }
        catch (IOException ex) {
            this.log.error("Failed to read metadata file '{}'", (Object)spMetaDataFile, (Object)ex);
            ex.printStackTrace();
        }
        if (xmlDocument == null) {
            return false;
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        String federationTag = null;
        try {
            federationTag = xPath.compile("count(//*[local-name() = 'EntitiesDescriptor'])").evaluate(xmlDocument);
        }
        catch (XPathExpressionException ex) {
            this.log.error("Failed to find IDP metadata file in relaying party file '{}'", (Object)spMetaDataFile, (Object)ex);
            ex.printStackTrace();
        }
        return Integer.parseInt(federationTag) > 0;
    }

    public boolean isFederationMetadataImprove(String spMetaDataFN) {
        boolean result = false;
        if (spMetaDataFN == null) {
            return result;
        }
        String spMetaDataFile = this.getSpMetadataFilePath(spMetaDataFN);
        try (InputStream is = this.documentStoreService.readDocumentAsStream(spMetaDataFile);){
            LineIterator it = IOUtils.lineIterator((InputStream)is, (Charset)this.UTF_8);
            while (it.hasNext()) {
                String line = it.nextLine();
                if (!line.contains("<EntitiesDescriptor")) continue;
                result = true;
                break;
            }
        }
        catch (IOException e) {
            this.log.error(" Error accessing metadata file", (Throwable)e);
        }
        return result;
    }

    public boolean generateIdpConfigurationFiles() {
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            throw new InvalidConfigurationException("Failed to update configuration due to undefined IDP root folder");
        }
        String idpConfFolder = this.getIdpConfDir();
        VelocityContext context = new VelocityContext();
        String regx = "\\s*(=>|,|\\s)\\s*";
        String[] ldapUrls = this.appConfiguration.getIdpLdapServer().split(regx);
        String ldapUrl = "";
        if (ldapUrls != null) {
            for (String ldapServer : ldapUrls) {
                if (ldapUrl.length() > 1) {
                    ldapUrl = ldapUrl + " ";
                }
                ldapUrl = ldapUrl + this.appConfiguration.getIdpLdapProtocol() + "://" + ldapServer;
            }
        } else {
            ldapUrl = this.appConfiguration.getIdpLdapProtocol() + "://" + this.appConfiguration.getIdpLdapServer();
        }
        String host = ldapUrl;
        String base = this.appConfiguration.getBaseDN();
        String serviceUser = this.appConfiguration.getIdpBindDn();
        String serviceCredential = "";
        try {
            serviceCredential = this.encryptionService.decrypt(this.appConfiguration.getIdpBindPassword());
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error("Failed to decrypt bindPassword", (Throwable)e);
            e.printStackTrace();
        }
        String userField = this.appConfiguration.getIdpUserFields();
        context.put("host", (Object)host);
        context.put("base", (Object)base);
        context.put("serviceUser", (Object)serviceUser);
        context.put("serviceCredential", (Object)serviceCredential);
        context.put("userField", (Object)userField);
        String loginConfig = this.generateConfFile(SHIB3_IDP_LOGIN_CONFIG_FILE, context);
        boolean result = loginConfig != null;
        return result &= this.writeConfFile(idpConfFolder + SHIB3_IDP_LOGIN_CONFIG_FILE, loginConfig);
    }

    public boolean isCorrectMetadataFile(GluuSAMLFederationProposal federationProposal) {
        String spMetaDataFN = federationProposal.getSpMetaDataFN();
        if (this.appConfiguration.getShibboleth3FederationRootDir() == null) {
            throw new InvalidConfigurationException("Failed to check meta-data file due to undefined federation root folder");
        }
        String metadataFile = this.getIdpMetadataDir() + spMetaDataFN;
        List entityId = this.samlMetadataParser.getEntityIdFromMetadataFile(metadataFile);
        return entityId != null && !entityId.isEmpty();
    }

    public boolean removeMetadataFile(String spMetaDataFN) {
        if (this.appConfiguration.getShibboleth3FederationRootDir() == null) {
            throw new InvalidConfigurationException("Failed to remove meta-data file due to undefined federation root folder");
        }
        String metadataFolder = this.getIdpMetadataDir();
        String spMetadataFile = metadataFolder + spMetaDataFN;
        try {
            return this.documentStoreService.removeDocument(spMetadataFile);
        }
        catch (Exception ex) {
            this.log.error("Failed to remove {}", (Object)spMetadataFile, (Object)ex);
            return false;
        }
    }

    public String getMetadataFilePath(String metadataFileName) {
        if (this.appConfiguration.getShibboleth3FederationRootDir() == null) {
            throw new InvalidConfigurationException("Failed to return meta-data file due to undefined federation root folder");
        }
        String metadataFolderName = this.getIdpMetadataDir();
        return metadataFolderName + metadataFileName;
    }

    public String getNewMetadataFileName(GluuSAMLFederationProposal federationProposal, List<GluuSAMLFederationProposal> allFederationProposals) {
        String relationshipInum = StringHelper.removePunctuation((String)federationProposal.getInum());
        return String.format(SHIB3_METADATA_FILE_PATTERN, relationshipInum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveMetadataFile(String metadataFileName, InputStream stream) {
        if (this.appConfiguration.getShibboleth3FederationRootDir() == null) {
            throw new InvalidConfigurationException("Failed to save meta-data file due to undefined federation root folder");
        }
        String spMetadataFile = this.getIdpMetadataDir() + metadataFileName;
        try {
            boolean bl = this.documentStoreService.saveDocumentStream(spMetadataFile, stream);
            return bl;
        }
        catch (Exception ex) {
            this.log.error("Failed to write meta-data file '{}'", (Object)spMetadataFile, (Object)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return false;
    }

    public boolean saveMetadataFile(String spMetaDataURL, String metadataFileName) {
        if (StringHelper.isEmpty((String)spMetaDataURL)) {
            return false;
        }
        if (this.appConfiguration.getShibboleth3FederationRootDir() == null) {
            throw new InvalidConfigurationException("Failed to save meta-data file due to undefined federation root folder");
        }
        HTTPFileDownloader.setEasyhttps((Protocol)new Protocol("https", (ProtocolSocketFactory)new EasyCASSLProtocolSocketFactory(), 443));
        String metadataFileContent = HTTPFileDownloader.getResource((String)spMetaDataURL, (String)"application/xml, text/xml", null, null);
        if (StringHelper.isEmpty((String)metadataFileContent)) {
            return false;
        }
        String spMetadataFile = this.getIdpMetadataDir() + metadataFileName;
        try {
            return this.documentStoreService.saveDocument(spMetadataFile, metadataFileContent, this.UTF_8);
        }
        catch (Exception ex) {
            this.log.error("Failed to write meta-data file '{}'", (Object)spMetadataFile, (Object)ex);
            return false;
        }
    }

    public boolean generateMetadataFiles() {
        this.log.info(">>>>>>>>>> IN Shibboleth3ConfService.generateMetadataFiles()...");
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            throw new InvalidConfigurationException("Failed to update configuration due to undefined IDP root folder");
        }
        String idpMetadataFolder = this.getIdpMetadataDir();
        VelocityContext context = new VelocityContext();
        String idpHost = this.appConfiguration.getIdpUrl();
        context.put("idpHost", (Object)idpHost);
        String domain = idpHost.replaceAll(":[0-9]*$", "").replaceAll("^.*?//", "");
        context.put("domain", (Object)domain);
        context.put("orgName", (Object)this.appConfiguration.getOrganizationName());
        context.put("orgShortName", (Object)this.appConfiguration.getOrganizationName());
        try {
            boolean hasSigningCert;
            String signingCert = this.appConfiguration.getIdp3SigningCert();
            if (DocumentStoreType.LOCAL != this.documentStoreService.getProviderType() && !(hasSigningCert = this.documentStoreService.hasDocument(signingCert))) {
                try (InputStream signingCertStream = this.localDocumentStoreService.readDocumentAsStream(signingCert);){
                    this.documentStoreService.saveDocumentStream(signingCert, signingCertStream);
                }
            }
            String idpSigningCertificate = this.documentStoreService.readDocument(signingCert, this.UTF_8).replaceAll("-{5}.*?-{5}", "");
            context.put("idpSigningCertificate", (Object)idpSigningCertificate);
        }
        catch (Exception e) {
            this.log.error("Unable to get IDP 3 signing certificate from " + this.appConfiguration.getIdp3SigningCert(), (Throwable)e);
            return false;
        }
        try {
            boolean hasSigningCert;
            String encryptionCert = this.appConfiguration.getIdp3EncryptionCert();
            if (DocumentStoreType.LOCAL != this.documentStoreService.getProviderType() && !(hasSigningCert = this.documentStoreService.hasDocument(encryptionCert))) {
                try (InputStream encryptionCertStream = this.localDocumentStoreService.readDocumentAsStream(encryptionCert);){
                    this.documentStoreService.saveDocumentStream(encryptionCert, encryptionCertStream);
                }
            }
            String idpEncryptionCertificate = this.documentStoreService.readDocument(encryptionCert, this.UTF_8).replaceAll("-{5}.*?-{5}", "");
            context.put("idpEncryptionCertificate", (Object)idpEncryptionCertificate);
        }
        catch (Exception e) {
            this.log.error("Unable to get IDP 3 encryption certificate from " + this.appConfiguration.getIdp3EncryptionCert(), (Throwable)e);
            return false;
        }
        String idpMetadata = this.generateConfFile(SHIB3_IDP_IDP_METADATA_FILE, context);
        boolean result = idpMetadata != null;
        this.log.info(">>>>>>>>>> LEAVING Shibboleth3ConfService.generateMetadataFiles()...");
        return result &= this.writeConfFile(idpMetadataFolder + SHIB3_IDP_IDP_METADATA_FILE, idpMetadata);
    }

    public GluuErrorHandler validateMetadata(String metadataPath) throws ParserConfigurationException, SAXException, IOException, XMLParserException {
        if (this.samlSchema == null) {
            ArrayList<String> validationLog = new ArrayList<String>();
            validationLog.add("Error of schema creating");
            validationLog.add("Failed to load SAML schema");
            return new GluuErrorHandler(false, true, validationLog);
        }
        try (InputStream stream = this.documentStoreService.readDocumentAsStream(metadataPath);){
            GluuErrorHandler gluuErrorHandler = XMLValidator.validateMetadata((InputStream)stream, (Schema)this.samlSchema);
            return gluuErrorHandler;
        }
    }

    public boolean existsResourceUri(String resourceUrlName) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(resourceUrlName).openConnection();
            con.setRequestMethod("HEAD");
            return con.getResponseCode() == 200;
        }
        catch (Exception e) {
            this.log.error("existsResourceUri: {}", (Object)resourceUrlName);
            return false;
        }
    }

    public boolean isIdpInstalled() {
        return this.appConfiguration.getShibbolethVersion() != null && !this.appConfiguration.getShibbolethVersion().isEmpty();
    }

    public boolean isFederation(GluuSAMLTrustRelationship trustRelationship) {
        return this.isFederationMetadataImprove(trustRelationship.getSpMetaDataFN());
    }

    public String generateConfFile(String template, VelocityContext context) {
        String generatedConf = this.templateService.generateConfFile(template, context);
        return generatedConf;
    }

    public boolean writeConfFile(String confFile, String confContent) {
        try {
            return this.documentStoreService.saveDocument(confFile, confContent, this.UTF_8);
        }
        catch (Exception ex) {
            this.log.error("Failed to write IDP configuration file '{}'", (Object)confFile, (Object)ex);
            return false;
        }
    }

    public void saveCert(GluuSAMLTrustRelationship trustRelationship, String certificate) throws IOException {
        String sslDirFN = this.appConfiguration.getShibboleth3IdpRootDir() + File.separator + "ssl" + File.separator;
        String certPath = sslDirFN + this.getSpNewMetadataFileName(trustRelationship).replaceFirst("\\.xml$", ".crt");
        String certData = "-----BEGIN CERTIFICATE-----\n" + certificate + PUBLIC_CERTIFICATE_END_LINE;
        if (certificate != null) {
            this.documentStoreService.saveDocument(certPath, certData, this.UTF_8);
        } else if (this.documentStoreService.hasDocument(certPath)) {
            this.documentStoreService.removeDocument(certPath);
        }
    }

    public void saveKey(GluuSAMLTrustRelationship trustRelationship, String key) throws IOException {
        String sslDirFN = this.appConfiguration.getShibboleth3IdpRootDir() + File.separator + "ssl" + File.separator;
        String keyPath = sslDirFN + this.getSpNewMetadataFileName(trustRelationship).replaceFirst("\\.xml$", ".key");
        if (key != null) {
            this.documentStoreService.saveDocument(keyPath, key, this.UTF_8);
        } else if (this.documentStoreService.hasDocument(keyPath)) {
            this.documentStoreService.removeDocument(keyPath);
        }
    }

    public boolean existsSpMetadataFilePath(String filePath) {
        return this.documentStoreService.hasDocument(filePath);
    }

    public void replaceSpMetadataCert(GluuSAMLTrustRelationship trustRelationship, String certRegEx, String certificate) throws IOException {
        String metadataFileName = trustRelationship.getSpMetaDataFN();
        String metadataFile = this.getSpMetadataFilePath(metadataFileName);
        String metadata = this.documentStoreService.readDocument(metadataFile, this.UTF_8);
        String updatedMetadata = metadata.replaceFirst(certRegEx, certificate);
        this.documentStoreService.saveDocument(metadataFile, updatedMetadata, this.UTF_8);
    }

    public String readSpMetadataFile(GluuSAMLTrustRelationship trustRelationship) throws IOException {
        String metadataFile;
        String filename = trustRelationship.getSpMetaDataFN();
        if (!StringUtils.isEmpty((CharSequence)filename) && this.documentStoreService.hasDocument(metadataFile = this.getSpMetadataFilePath(filename))) {
            return this.documentStoreService.readDocument(metadataFile, this.UTF_8);
        }
        return null;
    }

    public InputStream readAsStream(String filePath) throws IOException {
        if (StringHelper.isEmpty((String)filePath)) {
            return null;
        }
        return this.documentStoreService.readDocumentAsStream(filePath);
    }

    public String getSslDirFN() {
        String sslDirFN = this.appConfiguration.getShibboleth3IdpRootDir() + File.separator + "ssl" + File.separator;
        return sslDirFN;
    }

    public String getSpKeyFilePath(GluuSAMLTrustRelationship trustRelationship) {
        String sslDirFN = this.getSslDirFN();
        String spKeyFilePath = sslDirFN + this.getSpNewMetadataFileName(trustRelationship).replaceFirst("\\.xml$", ".key");
        return spKeyFilePath;
    }

    public String getSpCertFilePath(GluuSAMLTrustRelationship trustRelationship) {
        String sslDirFN = this.getSslDirFN();
        String spCertFilePath = sslDirFN + this.getSpNewMetadataFileName(trustRelationship).replaceFirst("\\.xml$", ".crt");
        return spCertFilePath;
    }

    public boolean renameMetadata(String metadataPath, String destinationMetadataPath) {
        try {
            return this.documentStoreService.renameDocument(metadataPath, destinationMetadataPath);
        }
        catch (Exception ex) {
            this.log.error("Failed to rename metadata '{}' to '{}'", new Object[]{metadataPath, destinationMetadataPath, ex});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveProfileConfigurationCert(String profileConfigurationCertFileName, InputStream stream) {
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            IOUtils.closeQuietly((InputStream)stream);
            throw new InvalidConfigurationException("Failed to save Profile Configuration file due to undefined IDP root folder");
        }
        String idpMetadataFolder = this.appConfiguration.getShibboleth3IdpRootDir() + File.separator + SHIB3_IDP_METADATA_FOLDER + File.separator + "credentials" + File.separator;
        String filterCertFile = idpMetadataFolder + profileConfigurationCertFileName;
        try {
            boolean result = this.documentStoreService.saveDocumentStream(filterCertFile, stream);
            if (result) {
                String string = filterCertFile;
                return string;
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to write  Profile Configuration  certificate file '{}'", (Object)filterCertFile, (Object)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveFilterCert(String filterCertFileName, InputStream stream) {
        if (this.appConfiguration.getShibboleth3IdpRootDir() == null) {
            IOUtils.closeQuietly((InputStream)stream);
            throw new InvalidConfigurationException("Failed to save filter certificate file due to undefined IDP root folder");
        }
        String idpMetadataFolder = this.appConfiguration.getShibboleth3IdpRootDir() + File.separator + SHIB3_IDP_METADATA_FOLDER + File.separator + "credentials" + File.separator;
        String filterCertFile = idpMetadataFolder + filterCertFileName;
        try {
            boolean result = this.documentStoreService.saveDocumentStream(filterCertFile, stream);
            if (result) {
                String string = filterCertFile;
                return string;
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to write  filter certificate file '{}'", (Object)filterCertFile, (Object)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return null;
    }
}

