/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxauth.model.common.ScopeType;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.gluu.util.StringHelper;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@ApplicationScoped
public class ScopeService
implements Serializable {
    private static final long serialVersionUID = 65734145678106186L;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private Logger logger;

    public void addScope(Scope scope) throws Exception {
        this.persistenceEntryManager.persist((Object)scope);
    }

    public void removeScope(Scope scope) throws Exception {
        this.persistenceEntryManager.remove((Object)scope);
    }

    public Scope getScopeByInum(String inum) throws Exception {
        Scope result = null;
        try {
            result = (Scope)this.persistenceEntryManager.find(Scope.class, (Object)this.getDnForScope(inum));
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
        }
        return result;
    }

    public String getDnForScope(String inum) throws Exception {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=scopes,%s", orgDn);
        }
        return String.format("inum=%s,ou=scopes,%s", inum, orgDn);
    }

    public void updateScope(Scope scope) throws Exception {
        this.persistenceEntryManager.merge((Object)scope);
    }

    public String generateInumForNewScope() throws Exception {
        Scope scope = new Scope();
        String newInum = null;
        String newDn = null;
        do {
            newInum = this.generateInumForNewScopeImpl();
            newDn = this.getDnForScope(newInum);
            scope.setDn(newDn);
        } while (this.persistenceEntryManager.contains(newDn, Scope.class));
        return newInum;
    }

    public List<Scope> searchScopes(String pattern, int sizeLimit) {
        Filter searchFilter = null;
        if (StringHelper.isNotEmpty((String)pattern)) {
            String[] targetArray = new String[]{pattern};
            Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
            Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
            searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter});
        }
        List<Object> result = new ArrayList<Scope>();
        try {
            result = this.persistenceEntryManager.findEntries(this.getDnForScope(null), Scope.class, searchFilter, sizeLimit);
            return this.filter(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    private String generateInumForNewScopeImpl() throws Exception {
        return UUID.randomUUID().toString();
    }

    public List<Scope> getAllScopesList(int size) {
        try {
            List scopes = this.persistenceEntryManager.findEntries(this.getDnForScope(null), Scope.class, null, size);
            return this.filter(scopes);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return new ArrayList<Scope>();
        }
    }

    public Scope getScopeByDn(String Dn) throws Exception {
        return (Scope)this.persistenceEntryManager.find(Scope.class, (Object)Dn);
    }

    public List<ScopeType> getScopeTypes() {
        ArrayList<ScopeType> scopeTypes = new ArrayList<ScopeType>(Arrays.asList(ScopeType.values()));
        scopeTypes.remove(ScopeType.UMA);
        return scopeTypes;
    }

    public Scope getScopeByDisplayName(String DisplayName) throws Exception {
        Scope scope = new Scope();
        scope.setDisplayName(DisplayName);
        List scopes = this.persistenceEntryManager.findEntries((Object)scope);
        if (scopes != null && scopes.size() > 0) {
            return (Scope)scopes.get(0);
        }
        return null;
    }

    private List<Scope> filter(List<Scope> scopes) {
        if (scopes != null) {
            return scopes.stream().filter((? super T e) -> !e.isUmaType()).collect(Collectors.toList());
        }
        return new ArrayList<Scope>();
    }
}

