/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.util.encoders.Base64;
import org.gluu.oxtrust.util.ServiceUtil;
import org.slf4j.Logger;

@ApplicationScoped
public class SSLService
implements Serializable {
    private static final long serialVersionUID = -874807269234589084L;
    @Inject
    private Logger log;
    private static final String SECURITY_PROVIDER_BOUNCY_CASTLE = "BC";
    private static final String X509_CERT_TYPE = "X.509";
    private static final String PKI_PATH_ENCODING = "PkiPath";
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";

    public X509Certificate getPEMCertificate(String fileName) {
        X509Certificate cert = null;
        try {
            cert = this.getPEMCertificate(new FileInputStream(fileName));
        }
        catch (FileNotFoundException e) {
            this.log.error("Certificate file does not exist : " + fileName);
        }
        return cert;
    }

    public X509Certificate getPEMCertificate(byte[] cert) {
        X509Certificate x509Certificate;
        ByteArrayInputStream bis = new ByteArrayInputStream(cert);
        try {
            x509Certificate = this.getPEMCertificate(bis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        bis.close();
        return x509Certificate;
    }

    public X509Certificate getPEMCertificate(InputStream certStream) {
        try {
            return SSLService.getPEMCertificateStatic(certStream);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate getPEMCertificateStatic(InputStream certStream) throws Exception {
        try (InputStreamReader reader = new InputStreamReader(certStream);
             PEMParser r = new PEMParser((Reader)reader);){
            Object certObject = r.readObject();
            if (certObject instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certObject;
                return x509Certificate;
            }
            if (!(certObject instanceof X509CertificateHolder)) throw new IOException("unknown certificate type");
            X509CertificateHolder certificateHolder = (X509CertificateHolder)certObject;
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(SECURITY_PROVIDER_BOUNCY_CASTLE).getCertificate(certificateHolder);
            return x509Certificate;
        }
        catch (Exception e) {
            throw new IOException("unknown certificate type");
        }
    }

    public static X509Certificate[] loadCertificates(InputStream is) throws Exception {
        byte[] certsBytes = ServiceUtil.readFully(is);
        return SSLService.loadCertificates(certsBytes);
    }

    public static X509Certificate[] loadCertificates(byte[] certsBytes) throws Exception {
        try {
            certsBytes = SSLService.fixCommonInputCertProblems(certsBytes);
            CertificateFactory cf = SSLService.getCertificateFactoryInstance();
            Collection<? extends Certificate> certs = cf.generateCertificates(new ByteArrayInputStream(certsBytes));
            ArrayList<X509Certificate> loadedCerts = new ArrayList<X509Certificate>();
            for (X509Certificate x509Certificate : certs) {
                if (x509Certificate == null) continue;
                loadedCerts.add(x509Certificate);
            }
            return loadedCerts.toArray(new X509Certificate[loadedCerts.size()]);
        }
        catch (CertificateException ex) {
            try {
                return SSLService.loadCertificatesAsPkiPathEncoded(new ByteArrayInputStream(certsBytes));
            }
            catch (CertificateException e) {
                X509Certificate[] certs = new X509Certificate[]{SSLService.getPEMCertificateStatic(new ByteArrayInputStream(certsBytes))};
                return certs;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] loadCertificatesAsPkiPathEncoded(InputStream is) throws Exception {
        try {
            CertificateFactory cf = SSLService.getCertificateFactoryInstance();
            CertPath certPath = cf.generateCertPath(is, PKI_PATH_ENCODING);
            List<? extends Certificate> certs = certPath.getCertificates();
            ArrayList<X509Certificate> loadedCerts = new ArrayList<X509Certificate>();
            for (X509Certificate x509Certificate : certs) {
                if (x509Certificate == null) continue;
                loadedCerts.add(x509Certificate);
            }
            X509Certificate[] x509CertificateArray = loadedCerts.toArray(new X509Certificate[loadedCerts.size()]);
            return x509CertificateArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private static byte[] fixCommonInputCertProblems(byte[] certs) throws IOException {
        byte[] decoded;
        String certsStr = new String(certs);
        if (certsStr.startsWith(BEGIN_CERTIFICATE)) {
            certsStr = certsStr.replaceAll(BEGIN_CERTIFICATE, "");
            certsStr = certsStr.replaceAll(END_CERTIFICATE, "");
        }
        if ((decoded = SSLService.attemptBase64Decode(certsStr)) != null) {
            return decoded;
        }
        return certs;
    }

    private static byte[] attemptBase64Decode(String toTest) {
        char[] base64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};
        toTest = toTest.replaceAll("\\s", "");
        StringBuffer sb = new StringBuffer();
        block0: for (int i = 0; i < toTest.length(); ++i) {
            char c = toTest.charAt(i);
            for (int j = 0; j < base64.length; ++j) {
                if (c == base64[j]) {
                    sb.append(c);
                    continue block0;
                }
                if (c == '\u0000') continue block0;
            }
            return null;
        }
        return Base64.decode((String)sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509CRL loadCRL(InputStream is) throws Exception {
        try {
            X509CRL crl;
            CertificateFactory cf = SSLService.getCertificateFactoryInstance();
            X509CRL x509CRL = crl = (X509CRL)cf.generateCRL(is);
            return x509CRL;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static X509Certificate[] convertCertificates(Certificate[] certsIn) throws Exception {
        if (certsIn == null) {
            return new X509Certificate[0];
        }
        X509Certificate[] certsOut = new X509Certificate[certsIn.length];
        for (int i = 0; i < certsIn.length; ++i) {
            certsOut[i] = SSLService.convertCertificate(certsIn[i]);
        }
        return certsOut;
    }

    public static X509Certificate convertCertificate(Certificate cert) throws Exception {
        CertificateFactory cf = SSLService.getCertificateFactoryInstance();
        ByteArrayInputStream bais = new ByteArrayInputStream(cert.getEncoded());
        return (X509Certificate)cf.generateCertificate(bais);
    }

    public static CertificateFactory getCertificateFactoryInstance() throws CertificateException, NoSuchProviderException {
        return CertificateFactory.getInstance(X509_CERT_TYPE, SECURITY_PROVIDER_BOUNCY_CASTLE);
    }
}

