/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.config.oxtrust.LdapOxPassportConfiguration;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.MappingException;
import org.gluu.service.config.ConfigurationFactory;
import org.gluu.util.StringHelper;
import org.gluu.util.properties.FileConfiguration;
import org.slf4j.Logger;

@ApplicationScoped
public class PassportService
implements Serializable {
    private static final long serialVersionUID = -4787990021407949332L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private ConfigurationFactory<?> configurationFactory;

    public boolean containsPassportConfiguration() {
        String configurationDn = this.getConfigurationDn();
        if (StringHelper.isEmpty((String)configurationDn)) {
            return false;
        }
        return this.persistenceEntryManager.contains(configurationDn, LdapOxPassportConfiguration.class);
    }

    public LdapOxPassportConfiguration loadConfigurationFromLdap() {
        boolean contains = this.containsPassportConfiguration();
        if (contains) {
            String configurationDn = this.getConfigurationDn();
            try {
                return (LdapOxPassportConfiguration)this.persistenceEntryManager.find(LdapOxPassportConfiguration.class, (Object)configurationDn);
            }
            catch (MappingException ex) {
                this.log.error("Failed to load passport configuration from LDAP", (Throwable)ex);
            }
        }
        return null;
    }

    private String getConfigurationDn() {
        FileConfiguration fc = this.configurationFactory.getBaseConfiguration();
        String configurationDn = fc.getString("oxpassport_ConfigurationEntryDN");
        return configurationDn;
    }

    public void updateLdapOxPassportConfiguration(LdapOxPassportConfiguration ldapOxPassportConfiguration) {
        ldapOxPassportConfiguration.setDn(this.getConfigurationDn());
        boolean contains = this.containsPassportConfiguration();
        if (contains) {
            this.persistenceEntryManager.merge((Object)ldapOxPassportConfiguration);
        } else {
            this.persistenceEntryManager.persist((Object)ldapOxPassportConfiguration);
        }
    }
}

