/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.IOException;
import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.config.oxtrust.AppConfiguration;
import org.gluu.oxauth.client.OpenIdConfigurationClient;
import org.gluu.oxauth.client.OpenIdConfigurationResponse;
import org.gluu.util.StringHelper;
import org.gluu.util.exception.ConfigurationException;
import org.gluu.util.init.Initializable;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="openIdService")
public class OpenIdService
extends Initializable
implements Serializable {
    private static final long serialVersionUID = 7875838160379126796L;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    private OpenIdConfigurationResponse openIdConfiguration;

    protected void initInternal() {
        try {
            this.loadOpenIdConfiguration();
        }
        catch (IOException ex) {
            throw new ConfigurationException("Failed to load oxAuth configuration");
        }
    }

    private void loadOpenIdConfiguration() throws IOException {
        String openIdProvider = this.appConfiguration.getOxAuthIssuer();
        if (StringHelper.isEmpty((String)openIdProvider)) {
            throw new ConfigurationException("OpenIdProvider Url is invalid");
        }
        OpenIdConfigurationClient openIdConfigurationClient = new OpenIdConfigurationClient(openIdProvider = openIdProvider + "/.well-known/openid-configuration");
        OpenIdConfigurationResponse response = openIdConfigurationClient.execOpenIdConfiguration();
        if (response == null || response.getStatus() != 200) {
            throw new ConfigurationException("Failed to load oxAuth configuration");
        }
        this.log.info("Successfully loaded oxAuth configuration");
        this.openIdConfiguration = response;
    }

    public OpenIdConfigurationResponse getOpenIdConfiguration() {
        this.init();
        return this.openIdConfiguration;
    }
}

