/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.model.ldap.GluuLdapConfiguration;
import org.gluu.oxtrust.model.GluuConfiguration;
import org.gluu.oxtrust.model.OxIDPAuthConf;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.oxtrust.service.EncryptionService;
import org.gluu.oxtrust.util.CollectionsUtil;
import org.gluu.oxtrust.util.LdapConfigurationException;
import org.gluu.oxtrust.util.LdapConfigurationLookup;
import org.gluu.oxtrust.util.LdapConfigurationNamePredicate;
import org.gluu.oxtrust.util.LdapConfigurationNotFoundException;
import org.gluu.util.security.StringEncrypter;

@ApplicationScoped
public class LdapConfigurationService {
    private static final String AUTH = "auth";
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private EncryptionService encryptionService;

    public List<GluuLdapConfiguration> findLdapConfigurations() {
        return FluentIterable.from(this.iDPAuthConfs()).transform(this.extractLdapConfiguration()).toList();
    }

    private Function<OxIDPAuthConf, GluuLdapConfiguration> extractLdapConfiguration() {
        return new Function<OxIDPAuthConf, GluuLdapConfiguration>(){

            public GluuLdapConfiguration apply(OxIDPAuthConf oxIDPAuthConf) {
                return oxIDPAuthConf.getConfig();
            }
        };
    }

    private List<OxIDPAuthConf> iDPAuthConfs() {
        ArrayList<OxIDPAuthConf> authIdpConfs = new ArrayList<OxIDPAuthConf>();
        List<OxIDPAuthConf> idpConfs = CollectionsUtil.trimToEmpty(this.configurationService.getConfiguration().getOxIDPAuthentication());
        for (OxIDPAuthConf idpConf : idpConfs) {
            if (!idpConf.getType().equalsIgnoreCase(AUTH)) continue;
            authIdpConfs.add(idpConf);
        }
        return authIdpConfs;
    }

    public GluuLdapConfiguration findActiveLdapConfiguration() {
        GluuLdapConfiguration result = (GluuLdapConfiguration)Iterables.getFirst(this.findLdapConfigurations(), null);
        if (result == null) {
            throw new LdapConfigurationNotFoundException();
        }
        return result;
    }

    public GluuLdapConfiguration findLdapConfigurationByName(String name) {
        return new LdapConfigurationLookup(this.findLdapConfigurations()).findByName(name);
    }

    public void save(List<GluuLdapConfiguration> ldapConfigurations) {
        GluuConfiguration configuration = this.configurationService.getConfiguration();
        configuration.setOxIDPAuthentication(this.oxIDPAuthConfs(ldapConfigurations));
        this.configurationService.updateConfiguration(configuration);
    }

    public void update(GluuLdapConfiguration ldapConfiguration) {
        List<GluuLdapConfiguration> ldapConfigurations = this.excludeFromConfigurations(new ArrayList<GluuLdapConfiguration>(this.findLdapConfigurations()), ldapConfiguration);
        ldapConfigurations.add(ldapConfiguration);
        this.save(ldapConfigurations);
    }

    public void save(GluuLdapConfiguration ldapConfiguration) {
        ArrayList<GluuLdapConfiguration> ldapConfigurations = new ArrayList<GluuLdapConfiguration>(this.findLdapConfigurations());
        ldapConfigurations.add(ldapConfiguration);
        this.save(ldapConfigurations);
    }

    private List<GluuLdapConfiguration> excludeFromConfigurations(List<GluuLdapConfiguration> ldapConfigurations, GluuLdapConfiguration ldapConfiguration) {
        boolean hadConfiguration = Iterables.removeIf(ldapConfigurations, (Predicate)new LdapConfigurationNamePredicate(ldapConfiguration));
        if (!hadConfiguration) {
            throw new LdapConfigurationNotFoundException(ldapConfiguration.getConfigId());
        }
        return ldapConfigurations;
    }

    private List<OxIDPAuthConf> oxIDPAuthConfs(List<GluuLdapConfiguration> ldapConfigurations) {
        LdapConfigurationLookup ldapConfigurationLookup = new LdapConfigurationLookup(this.findLdapConfigurations());
        ArrayList<OxIDPAuthConf> idpConf = new ArrayList<OxIDPAuthConf>();
        for (GluuLdapConfiguration ldapConfig : ldapConfigurations) {
            if (ldapConfigurationLookup.shouldEncryptPassword(ldapConfig)) {
                ldapConfig.setBindPassword(this.encrypt(ldapConfig.getBindPassword()));
            }
            if (ldapConfig.isUseAnonymousBind()) {
                ldapConfig.setBindDN(null);
            }
            OxIDPAuthConf ldapConfigIdpAuthConf = new OxIDPAuthConf();
            ldapConfig.updateStringsLists();
            ldapConfigIdpAuthConf.setType(AUTH);
            ldapConfigIdpAuthConf.setVersion(ldapConfigIdpAuthConf.getVersion() + 1);
            ldapConfigIdpAuthConf.setName(ldapConfig.getConfigId());
            ldapConfigIdpAuthConf.setEnabled(ldapConfig.isEnabled());
            ldapConfigIdpAuthConf.setConfig(ldapConfig);
            idpConf.add(ldapConfigIdpAuthConf);
        }
        return idpConf;
    }

    private String encrypt(String data) {
        try {
            return this.encryptionService.encrypt(data);
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new LdapConfigurationException(e);
        }
    }

    public void remove(String name) {
        GluuLdapConfiguration toRemove = this.findLdapConfigurationByName(name);
        ArrayList<GluuLdapConfiguration> allConfiguration = new ArrayList<GluuLdapConfiguration>(this.findLdapConfigurations());
        List<GluuLdapConfiguration> newConfigurations = this.excludeFromConfigurations(allConfiguration, toRemove);
        this.save(newConfigurations);
    }
}

