/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.IOException;
import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.config.oxtrust.AppConfiguration;
import org.gluu.config.oxtrust.AttributeResolverConfiguration;
import org.gluu.config.oxtrust.CacheRefreshConfiguration;
import org.gluu.config.oxtrust.DbApplicationConfiguration;
import org.gluu.config.oxtrust.ImportPersonConfig;
import org.gluu.config.oxtrust.LdapOxAuthConfiguration;
import org.gluu.config.oxtrust.LdapOxTrustConfiguration;
import org.gluu.oxtrust.model.GluuConfiguration;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.BasePersistenceException;
import org.gluu.service.JsonService;
import org.gluu.service.cache.CacheConfiguration;
import org.gluu.service.cache.RedisConfiguration;
import org.gluu.service.config.ConfigurationFactory;
import org.gluu.service.document.store.conf.DocumentStoreConfiguration;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="jsonConfigurationService")
public class JsonConfigurationService
implements Serializable {
    private static final long serialVersionUID = -3840968275007784641L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private JsonService jsonService;
    @Inject
    private StringEncrypter stringEncrypter;
    @Inject
    private ConfigurationFactory<?> configurationFactory;
    @Inject
    private ConfigurationService configurationService;

    public AppConfiguration getOxTrustappConfiguration() {
        LdapOxTrustConfiguration ldapOxTrustConfiguration = this.getOxTrustConfiguration();
        return ldapOxTrustConfiguration.getApplication();
    }

    public CacheConfiguration getOxMemCacheConfiguration() {
        return this.configurationService.getConfiguration().getCacheConfiguration();
    }

    public DocumentStoreConfiguration getDocumentStoreConfiguration() {
        return this.configurationService.getConfiguration().getDocumentStoreConfiguration();
    }

    public ImportPersonConfig getOxTrustImportPersonConfiguration() {
        return this.getOxTrustConfiguration().getImportPersonConfig();
    }

    public CacheRefreshConfiguration getOxTrustCacheRefreshConfiguration() {
        return this.getOxTrustConfiguration().getCacheRefresh();
    }

    private LdapOxTrustConfiguration getOxTrustConfiguration() {
        String configurationDn = this.configurationFactory.getConfigurationDn();
        return this.loadOxTrustConfig(configurationDn);
    }

    public String getOxAuthDynamicConfigJson() throws IOException {
        String configurationDn = this.configurationFactory.getConfigurationDn();
        return this.loadOxAuthConfig(configurationDn).getOxAuthConfigDynamic();
    }

    public org.gluu.oxauth.model.configuration.AppConfiguration getOxauthAppConfiguration() throws IOException {
        return (org.gluu.oxauth.model.configuration.AppConfiguration)this.jsonService.jsonToObject(this.getOxAuthDynamicConfigJson(), org.gluu.oxauth.model.configuration.AppConfiguration.class);
    }

    public boolean saveOxTrustappConfiguration(AppConfiguration oxTrustappConfiguration) {
        LdapOxTrustConfiguration ldapOxTrustConfiguration = this.getOxTrustConfiguration();
        ldapOxTrustConfiguration.setApplication(oxTrustappConfiguration);
        ldapOxTrustConfiguration.setRevision(ldapOxTrustConfiguration.getRevision() + 1L);
        this.persistenceEntryManager.merge((Object)ldapOxTrustConfiguration);
        return true;
    }

    public boolean saveOxTrustImportPersonConfiguration(ImportPersonConfig oxTrustImportPersonConfiguration) {
        LdapOxTrustConfiguration ldapOxTrustConfiguration = this.getOxTrustConfiguration();
        ldapOxTrustConfiguration.setImportPersonConfig(oxTrustImportPersonConfiguration);
        ldapOxTrustConfiguration.setRevision(ldapOxTrustConfiguration.getRevision() + 1L);
        this.persistenceEntryManager.merge((Object)ldapOxTrustConfiguration);
        return true;
    }

    public boolean saveOxTrustCacheRefreshConfiguration(CacheRefreshConfiguration oxTrustCacheRefreshConfiguration) {
        LdapOxTrustConfiguration ldapOxTrustConfiguration = this.getOxTrustConfiguration();
        ldapOxTrustConfiguration.setCacheRefresh(oxTrustCacheRefreshConfiguration);
        ldapOxTrustConfiguration.setRevision(ldapOxTrustConfiguration.getRevision() + 1L);
        this.persistenceEntryManager.merge((Object)ldapOxTrustConfiguration);
        return true;
    }

    public boolean saveOxTrustAttributeResolverConfigurationConfiguration(AttributeResolverConfiguration attributeResolverConfiguration) {
        LdapOxTrustConfiguration ldapOxTrustConfiguration = this.getOxTrustConfiguration();
        ldapOxTrustConfiguration.setAttributeResolverConfig(attributeResolverConfiguration);
        ldapOxTrustConfiguration.setRevision(ldapOxTrustConfiguration.getRevision() + 1L);
        this.persistenceEntryManager.merge((Object)ldapOxTrustConfiguration);
        return true;
    }

    public boolean saveOxAuthAppConfiguration(org.gluu.oxauth.model.configuration.AppConfiguration appConfiguration) {
        try {
            String appConfigurationJson = this.jsonService.objectToJson((Object)appConfiguration);
            return this.saveOxAuthDynamicConfigJson(appConfigurationJson);
        }
        catch (IOException e) {
            this.log.error("Failed to serialize AppConfiguration", (Throwable)e);
            return false;
        }
    }

    public boolean saveOxAuthDynamicConfigJson(String oxAuthDynamicConfigJson) throws IOException {
        String configurationDn = this.configurationFactory.getConfigurationDn();
        LdapOxAuthConfiguration ldapOxAuthConfiguration = this.loadOxAuthConfig(configurationDn);
        ldapOxAuthConfiguration.setOxAuthConfigDynamic(oxAuthDynamicConfigJson);
        ldapOxAuthConfiguration.setRevision(ldapOxAuthConfiguration.getRevision() + 1L);
        this.persistenceEntryManager.merge((Object)ldapOxAuthConfiguration);
        return true;
    }

    public boolean saveOxMemCacheConfiguration(CacheConfiguration cachedConfiguration) {
        this.encrypPassword(cachedConfiguration.getRedisConfiguration());
        GluuConfiguration gluuConfiguration = this.configurationService.getConfiguration();
        gluuConfiguration.setCacheConfiguration(cachedConfiguration);
        this.configurationService.updateConfiguration(gluuConfiguration);
        return true;
    }

    public boolean saveDocumentStoreConfiguration(DocumentStoreConfiguration documentStoreConfiguration) {
        GluuConfiguration gluuConfiguration = this.configurationService.getConfiguration();
        gluuConfiguration.setDocumentStoreConfiguration(documentStoreConfiguration);
        this.configurationService.updateConfiguration(gluuConfiguration);
        return true;
    }

    private LdapOxTrustConfiguration loadOxTrustConfig(String configurationDn) {
        try {
            LdapOxTrustConfiguration conf = (LdapOxTrustConfiguration)this.persistenceEntryManager.find(LdapOxTrustConfiguration.class, (Object)configurationDn);
            return conf;
        }
        catch (BasePersistenceException ex) {
            this.log.error("Failed to load configuration from LDAP");
            return null;
        }
    }

    private LdapOxAuthConfiguration loadOxAuthConfig(String configurationDn) {
        try {
            configurationDn = configurationDn.replace("ou=oxtrust", "ou=oxauth");
            LdapOxAuthConfiguration conf = (LdapOxAuthConfiguration)this.persistenceEntryManager.find(LdapOxAuthConfiguration.class, (Object)configurationDn);
            return conf;
        }
        catch (BasePersistenceException ex) {
            this.log.error("Failed to load configuration from LDAP");
            return null;
        }
    }

    private void encrypPassword(RedisConfiguration redisConfiguration) {
        try {
            String password = redisConfiguration.getPassword();
            if (StringUtils.isNotBlank((String)password)) {
                redisConfiguration.setPassword(this.stringEncrypter.encrypt(password));
                this.log.trace("Decrypted redis password successfully.");
            }
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error("Error during redis password decryption", (Throwable)e);
        }
    }

    public DbApplicationConfiguration loadFido2Configuration() {
        try {
            String configurationDn = this.configurationFactory.getBaseConfiguration().getString("fido2_ConfigurationEntryDN");
            DbApplicationConfiguration conf = (DbApplicationConfiguration)this.persistenceEntryManager.find(DbApplicationConfiguration.class, (Object)configurationDn);
            return conf;
        }
        catch (BasePersistenceException ex) {
            this.log.error("Failed to load Fido2 configuration from LDAP");
            return null;
        }
    }

    public void saveFido2Configuration(String fido2ConfigJson) {
        DbApplicationConfiguration fido2Configuration = this.loadFido2Configuration();
        fido2Configuration.setDynamicConf(fido2ConfigJson);
        fido2Configuration.setRevision(fido2Configuration.getRevision() + 1L);
        this.persistenceEntryManager.merge((Object)fido2Configuration);
    }
}

