/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxtrust.service.external.ExternalIdGeneratorService;
import org.gluu.util.StringHelper;

@ApplicationScoped
public class IdGenService {
    public static final int MAX_IDGEN_TRY_COUNT = 10;
    @Inject
    private ExternalIdGeneratorService externalIdGenerationService;

    public String generateId(String idType) {
        String generatedId;
        if (this.externalIdGenerationService.isEnabled() && StringHelper.isNotEmpty((String)(generatedId = this.externalIdGenerationService.executeExternalDefaultGenerateIdMethod("oxtrust", idType, "")))) {
            return generatedId;
        }
        return this.generateDefaultId();
    }

    public String generateDefaultId() {
        return UUID.randomUUID().toString();
    }
}

