/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxtrust.model.GluuCustomPerson;
import org.gluu.oxtrust.model.GluuGroup;
import org.gluu.oxtrust.model.GluuGroupVisibility;
import org.gluu.oxtrust.service.IGroupService;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.oxtrust.service.PersonService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.exception.operation.DuplicateEntryException;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.util.ArrayHelper;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
public class GroupService
implements Serializable,
IGroupService {
    private static final long serialVersionUID = -9167587377957719152L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private PersonService personService;

    @Override
    public void addGroup(GluuGroup group) throws Exception {
        GluuGroup displayNameGroup = new GluuGroup();
        displayNameGroup.setDisplayName(group.getDisplayName());
        List<GluuGroup> groups = this.findGroups(displayNameGroup, 1);
        if (groups != null && groups.size() != 0) {
            throw new DuplicateEntryException("Duplicate displayName: " + group.getDisplayName());
        }
        this.persistenceEntryManager.persist((Object)group);
    }

    @Override
    public void updateGroup(GluuGroup group) {
        this.persistenceEntryManager.merge((Object)group);
    }

    @Override
    public void removeGroup(GluuGroup group) {
        if (group.getMembers() != null) {
            List memberDNs = group.getMembers();
            for (String memberDN : memberDNs) {
                if (!this.personService.contains(memberDN)) continue;
                GluuCustomPerson person = this.personService.getPersonByDn(memberDN);
                List groupDNs = person.getMemberOf();
                ArrayList updatedGroupDNs = new ArrayList();
                updatedGroupDNs.addAll(groupDNs);
                updatedGroupDNs.remove(group.getDn());
                person.setMemberOf(updatedGroupDNs);
                try {
                    this.personService.updatePerson(person);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.persistenceEntryManager.remove((Object)group);
    }

    @Override
    public List<GluuGroup> getAllGroups() {
        return this.persistenceEntryManager.findEntries(this.getDnForGroup(null), GluuGroup.class, null);
    }

    @Override
    public boolean isMemberOrOwner(String groupDN, String personDN) {
        Filter ownerFilter = Filter.createEqualityFilter((String)"owner", (Object)personDN);
        Filter memberFilter = Filter.createEqualityFilter((String)"member", (Object)personDN);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{ownerFilter, memberFilter});
        boolean isMemberOrOwner = false;
        try {
            isMemberOrOwner = this.persistenceEntryManager.findEntries(groupDN, GluuGroup.class, searchFilter, 1).size() > 0;
        }
        catch (EntryPersistenceException ex) {
            this.log.error("Failed to determine if person '{}' memeber or owner of group '{}'", new Object[]{personDN, groupDN, ex});
        }
        return isMemberOrOwner;
    }

    @Override
    public GluuGroup getGroupByInum(String inum) {
        GluuGroup result = null;
        try {
            result = (GluuGroup)this.persistenceEntryManager.find(GluuGroup.class, (Object)this.getDnForGroup(inum));
        }
        catch (Exception e) {
            this.log.error("Failed to find group by Inum " + inum, (Throwable)e);
        }
        return result;
    }

    @Override
    public String getDnForGroup(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=groups,%s", orgDn);
        }
        return String.format("inum=%s,ou=groups,%s", inum, orgDn);
    }

    @Override
    public int countGroups() {
        String dn = this.getDnForGroup(null);
        Class<GluuGroup> searchClass = GluuGroup.class;
        if (this.persistenceEntryManager.hasBranchesSupport(dn)) {
            searchClass = SimpleBranch.class;
        }
        return this.persistenceEntryManager.countEntries(dn, searchClass, null, SearchScope.BASE);
    }

    public boolean contains(String groupDn) {
        return this.persistenceEntryManager.contains(groupDn, GluuCustomPerson.class);
    }

    @Override
    public String generateInumForNewGroup() throws Exception {
        GluuGroup group = new GluuGroup();
        String newInum = null;
        String newDn = null;
        do {
            newInum = this.generateInumForNewGroupImpl();
            newDn = this.getDnForGroup(newInum);
            group.setDn(newDn);
        } while (this.persistenceEntryManager.contains(newDn, GluuCustomPerson.class));
        return newInum;
    }

    @Override
    public List<GluuGroup> searchGroups(String pattern, int sizeLimit) throws Exception {
        String[] targetArray = new String[]{pattern};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter});
        return this.persistenceEntryManager.findEntries(this.getDnForGroup(null), GluuGroup.class, searchFilter, sizeLimit);
    }

    @Override
    public List<GluuGroup> getAllGroups(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForGroup(null), GluuGroup.class, null, sizeLimit);
    }

    @Override
    public GluuGroupVisibility[] getVisibilityTypes() {
        return GluuGroupVisibility.values();
    }

    private String generateInumForNewGroupImpl() throws Exception {
        return UUID.randomUUID().toString();
    }

    @Override
    public GluuGroup getGroupByDn(String Dn) {
        return (GluuGroup)this.persistenceEntryManager.find(GluuGroup.class, (Object)Dn);
    }

    @Override
    public GluuGroup getGroupByDisplayName(String DisplayName) throws Exception {
        GluuGroup group = new GluuGroup();
        group.setBaseDn(this.getDnForGroup(null));
        group.setDisplayName(DisplayName);
        List groups = this.persistenceEntryManager.findEntries((Object)group);
        if (groups != null && groups.size() > 0) {
            return (GluuGroup)groups.get(0);
        }
        return null;
    }

    @Override
    public List<GluuGroup> findGroups(GluuGroup group, int sizeLimit) {
        group.setBaseDn(this.getDnForGroup(null));
        return this.persistenceEntryManager.findEntries((Object)group, sizeLimit);
    }

    @Override
    public boolean isMemberOrOwner(String[] groupDNs, String personDN) throws Exception {
        boolean result = false;
        if (ArrayHelper.isEmpty((Object[])groupDNs)) {
            return result;
        }
        for (String groupDN : groupDNs) {
            if (!StringHelper.isEmpty((String)groupDN) && (result = this.isMemberOrOwner(groupDN, personDN))) break;
        }
        return result;
    }
}

