/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxtrust.model.fido.GluuCustomFidoDevice;
import org.gluu.oxtrust.service.IFidoDeviceService;
import org.gluu.oxtrust.service.IPersonService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.slf4j.Logger;

@ApplicationScoped
public class FidoDeviceService
implements IFidoDeviceService,
Serializable {
    private static final long serialVersionUID = -206231314840676189L;
    @Inject
    private Logger log;
    @Inject
    private IPersonService personService;
    @Inject
    private PersistenceEntryManager ldapEntryManager;

    @Override
    public String getDnForFidoDevice(String userId, String id) {
        String baseDn;
        if (userId != null && !userId.isEmpty()) {
            baseDn = "ou=fido," + this.personService.getDnForPerson(userId);
            if (id != null && !id.isEmpty()) {
                baseDn = "oxId=" + id + "," + baseDn;
            }
        } else {
            baseDn = this.personService.getDnForPerson(null);
        }
        return baseDn;
    }

    @Override
    public GluuCustomFidoDevice getGluuCustomFidoDeviceById(String userId, String id) {
        GluuCustomFidoDevice gluuCustomFidoDevice = null;
        try {
            String dn = this.getDnForFidoDevice(userId, id);
            if (StringUtils.isNotEmpty((String)userId)) {
                gluuCustomFidoDevice = (GluuCustomFidoDevice)this.ldapEntryManager.find(GluuCustomFidoDevice.class, (Object)dn);
            } else {
                Filter filter = Filter.createEqualityFilter((String)"oxId", (Object)id);
                gluuCustomFidoDevice = (GluuCustomFidoDevice)this.ldapEntryManager.findEntries(dn, GluuCustomFidoDevice.class, filter).get(0);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to find device by id " + id, (Throwable)e);
        }
        return gluuCustomFidoDevice;
    }

    public GluuCustomFidoDevice searchFidoDevice(Filter filter, String userId, String id) throws Exception {
        GluuCustomFidoDevice gluuCustomFidoDevice = null;
        List gluuCustomFidoDevices = this.ldapEntryManager.findEntries(this.getDnForFidoDevice(userId, id), GluuCustomFidoDevice.class, filter, 1);
        if (gluuCustomFidoDevices != null && !gluuCustomFidoDevices.isEmpty()) {
            gluuCustomFidoDevice = (GluuCustomFidoDevice)gluuCustomFidoDevices.get(0);
        }
        return gluuCustomFidoDevice;
    }

    @Override
    public void updateGluuCustomFidoDevice(GluuCustomFidoDevice gluuCustomFidoDevice) {
        this.ldapEntryManager.merge((Object)gluuCustomFidoDevice);
    }

    @Override
    public void removeGluuCustomFidoDevice(GluuCustomFidoDevice gluuCustomFidoDevice) {
        this.ldapEntryManager.removeRecursively(gluuCustomFidoDevice.getDn());
    }

    @Override
    public List<GluuCustomFidoDevice> searchFidoDevices(String userInum, String ... returnAttributes) {
        try {
            Filter equalityFilter = Filter.createEqualityFilter((String)"personInum", (Object)userInum);
            return this.ldapEntryManager.findEntries(this.getDnForFidoDevice(userInum, null), GluuCustomFidoDevice.class, equalityFilter, returnAttributes);
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
            return new ArrayList<GluuCustomFidoDevice>();
        }
    }
}

