/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.model.GluuStatus;
import org.gluu.oxtrust.model.GluuMetadataSourceType;
import org.gluu.oxtrust.model.GluuSAMLFederationProposal;
import org.gluu.oxtrust.service.ConfigurationService;
import org.gluu.oxtrust.service.Shibboleth3ConfService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.util.INumGenerator;
import org.gluu.util.StringHelper;

@ApplicationScoped
public class FederationService
implements Serializable {
    private static final long serialVersionUID = 3701922947171190714L;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private Shibboleth3ConfService shibboleth3ConfService;

    public void addFederationProposal(GluuSAMLFederationProposal federationProposal) {
        this.persistenceEntryManager.persist((Object)federationProposal);
    }

    public String generateInumForNewFederationProposal() {
        String newInum;
        String newDn;
        while (this.containsFederationProposal(newDn = this.getDnForFederationProposal(newInum = this.generateInumForNewFederationProposalImpl()))) {
        }
        return newInum;
    }

    private String generateInumForNewFederationProposalImpl() {
        return "!0006!" + INumGenerator.generate((int)2);
    }

    public boolean containsFederationProposal(String dn) {
        return this.persistenceEntryManager.contains(dn, GluuSAMLFederationProposal.class);
    }

    public String getDnForFederationProposal(String inum) {
        String configurationDn = this.configurationService.getDnForConfiguration();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=federations,%s", configurationDn);
        }
        return String.format("inum=%s,ou=federations,%s", inum, configurationDn);
    }

    public void updateFederationProposal(GluuSAMLFederationProposal federationProposal) {
        this.persistenceEntryManager.merge((Object)federationProposal);
    }

    public List<GluuSAMLFederationProposal> getAllFederationProposals() {
        return this.persistenceEntryManager.findEntries(this.getDnForFederationProposal(null), GluuSAMLFederationProposal.class, null);
    }

    public GluuSAMLFederationProposal getProposalByInum(String inum) {
        return (GluuSAMLFederationProposal)((Object)this.persistenceEntryManager.find(GluuSAMLFederationProposal.class, (Object)this.getDnForFederationProposal(inum)));
    }

    public void removeFederationProposal(GluuSAMLFederationProposal federationProposal) {
        if (federationProposal.isFederation()) {
            for (GluuSAMLFederationProposal proposal : this.getAllFederationProposals()) {
                if (proposal.getContainerFederation() == null || !proposal.getContainerFederation().equals((Object)federationProposal)) continue;
                this.shibboleth3ConfService.removeMetadataFile(proposal.getSpMetaDataFN());
                this.removeFederationProposal(proposal);
            }
        } else {
            this.shibboleth3ConfService.removeMetadataFile(federationProposal.getSpMetaDataFN());
        }
        this.persistenceEntryManager.remove((Object)federationProposal);
    }

    public GluuMetadataSourceType[] getMetadataSourceTypes() {
        List<GluuMetadataSourceType> trTypes = Arrays.asList(GluuMetadataSourceType.values());
        ArrayList<GluuMetadataSourceType> proposalTypes = new ArrayList<GluuMetadataSourceType>(trTypes);
        proposalTypes.remove(GluuMetadataSourceType.FEDERATION);
        return proposalTypes.toArray(new GluuMetadataSourceType[0]);
    }

    public List<GluuSAMLFederationProposal> getAllActiveFederationProposals() {
        GluuSAMLFederationProposal federationProposal = new GluuSAMLFederationProposal();
        federationProposal.setBaseDn(this.getDnForFederationProposal(null));
        federationProposal.setStatus(GluuStatus.ACTIVE);
        return this.persistenceEntryManager.findEntries((Object)federationProposal);
    }

    public List<GluuSAMLFederationProposal> getAllFederations() {
        ArrayList<GluuSAMLFederationProposal> result = new ArrayList<GluuSAMLFederationProposal>();
        for (GluuSAMLFederationProposal trust : this.getAllActiveFederationProposals()) {
            if (!trust.isFederation()) continue;
            result.add(trust);
        }
        return result;
    }

    public GluuSAMLFederationProposal getProposalByDn(String dn) {
        if (StringHelper.isNotEmpty((String)dn)) {
            return (GluuSAMLFederationProposal)((Object)this.persistenceEntryManager.find(GluuSAMLFederationProposal.class, (Object)dn));
        }
        return null;
    }
}

