/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.service;

import java.io.Serializable;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.config.oxtrust.LdapShibbolethCASProtocolConfiguration;
import org.gluu.config.oxtrust.ShibbolethCASProtocolConfiguration;
import org.gluu.oxtrust.service.OrganizationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.util.INumGenerator;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
public class CASService
implements Serializable {
    private static final long serialVersionUID = -6130872937911013810L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    OrganizationService organizationService;

    @PostConstruct
    public void init() {
    }

    @PreDestroy
    public void destroy() {
    }

    public ShibbolethCASProtocolConfiguration loadCASConfiguration() {
        this.log.info("loadCASConfiguration() call");
        List entries = this.persistenceEntryManager.findEntries(this.getDnForLdapShibbolethCASProtocolConfiguration(null), LdapShibbolethCASProtocolConfiguration.class, null);
        if (!entries.isEmpty()) {
            return ((LdapShibbolethCASProtocolConfiguration)entries.get(0)).getCasProtocolConfiguration();
        }
        return null;
    }

    public void updateCASConfiguration(ShibbolethCASProtocolConfiguration entry) {
        this.log.info("updateCASConfiguration() call");
        LdapShibbolethCASProtocolConfiguration ldapEntry = (LdapShibbolethCASProtocolConfiguration)this.persistenceEntryManager.find(LdapShibbolethCASProtocolConfiguration.class, (Object)this.getDnForLdapShibbolethCASProtocolConfiguration(entry.getInum()));
        ldapEntry.setInum(entry.getInum());
        ldapEntry.setCasProtocolConfiguration(entry);
        this.persistenceEntryManager.merge((Object)ldapEntry);
    }

    public void addCASConfiguration(ShibbolethCASProtocolConfiguration entry) {
        this.log.info("addCASConfiguration() call");
        try {
            LdapShibbolethCASProtocolConfiguration ldapEntry = new LdapShibbolethCASProtocolConfiguration();
            ldapEntry.setCasProtocolConfiguration(entry);
            String inum = CASService.generateInum();
            this.log.info("getDnForLdapShibbolethCASProtocolConfiguration(inum) retsult: " + this.getDnForLdapShibbolethCASProtocolConfiguration(inum));
            entry.setInum(inum);
            ldapEntry.setInum(inum);
            ldapEntry.setDn(this.getDnForLdapShibbolethCASProtocolConfiguration(inum));
            this.persistenceEntryManager.persist((Object)ldapEntry);
        }
        catch (Exception e) {
            this.log.error("addIDPEntry() exception", (Throwable)e);
        }
    }

    private String getDnForLdapShibbolethCASProtocolConfiguration(String inum) {
        String organizationDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=cas,ou=oxidp,%s", organizationDn);
        }
        return String.format("inum=%s,ou=cas,ou=oxidp,%s", inum, organizationDn);
    }

    private static String generateInum() {
        return INumGenerator.generate((int)1);
    }
}

