/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.auth.oauth;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.model.common.IntrospectionResponse;
import org.gluu.oxtrust.auth.IProtectionService;
import org.gluu.oxtrust.auth.oauth.BaseOAuthProtectionService;
import org.gluu.oxtrust.service.filter.ProtectedApi;
import org.slf4j.Logger;

@ApplicationScoped
public class DefaultOAuthProtectionService
extends BaseOAuthProtectionService {
    @Inject
    private Logger log;

    @Override
    public Response processIntrospectionResponse(IntrospectionResponse iresponse, ResourceInfo resourceInfo) {
        Response response = null;
        List<String> scopes = this.getRequestedScopes(resourceInfo);
        this.log.info("Call requires scopes: {}", scopes);
        List tokenScopes = Optional.ofNullable(iresponse).map(IntrospectionResponse::getScope).orElse(null);
        if (tokenScopes == null || !iresponse.isActive() || !tokenScopes.containsAll(scopes)) {
            String msg = "Invalid token or insufficient scopes";
            this.log.error("{}. Token scopes: {}", (Object)msg, (Object)tokenScopes);
            response = IProtectionService.simpleResponse(Response.Status.FORBIDDEN, msg);
        }
        return response;
    }

    private List<String> getRequestedScopes(ResourceInfo resourceInfo) {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.addAll(this.getScopesFromAnnotation(resourceInfo.getResourceClass()));
        scopes.addAll(this.getScopesFromAnnotation(resourceInfo.getResourceMethod()));
        return scopes;
    }

    private List<String> getScopesFromAnnotation(AnnotatedElement elem) {
        return DefaultOAuthProtectionService.optAnnnotation(elem, ProtectedApi.class).map(ProtectedApi::oauthScopes).map(Arrays::asList).orElse(Collections.emptyList());
    }

    private static <T extends Annotation> Optional<T> optAnnnotation(AnnotatedElement elem, Class<T> cls) {
        return Optional.ofNullable(elem.getAnnotation(cls));
    }
}

